/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.file.i;
import io.axoniq.axonserver.localstorage.query.AggregateIdExtractor;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final FileSystemMonitor D;
    private final Synchronizer i;
    protected final AtomicLong a;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> B;
    private final EventTransformer e;
    private final MeterFactory A;
    protected final AtomicReference<WritePosition> h;
    private final Gauge L;
    private Path G;
    private static final Logger A = LoggerFactory.getLogger(WritableFileStorageTier.class);

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.H(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.H((long)a2, a3.intValue());
    }

    public long G() {
        WritableFileStorageTier a3;
        return (Long)a3.H((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.B.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.H(0L);
        }
        if (a4.L.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.H((File)a4.E(a3))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition H(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(DistributeLicenseService.H((Object)"WErLyHr\tj[\u007fGmH}]wFp\tm@dL$\t;M"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.h.getAndUpdate(arg_0 -> WritableFileStorageTier.H((int)a3, n4, (int)a2, arg_0))).E(n4) && !a4.H((int)a2)) continue;
            A.debug(AggregateIdExtractor.H((Object)"\u00187Yj 8\u0006+\u0017#\r-C$\u0006=C9\u0006-\u000e/\r>C1\u001e"), (Object)a5.e, (Object)a4.G);
            WritePosition writePosition = a4;
            writePosition.a.H(writePosition.h, -1);
            WritableEventSource writableEventSource = a5.H(new FileVersion(a4.G, (int)a2), n4 + 5 + 4, true);
            a5.h.set(a4.H(writableEventSource, (int)a2));
        } while (!a4.G(n4) || a4.H((int)a2));
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion H(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.H((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::H).filter(arg_0 -> WritableFileStorageTier.H((long)a3, arg_0)).max(FileVersion::H).orElse((FileVersion)a2);
    }

    private static /* synthetic */ Stream E(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.H(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.H(a5.H());
                a5 = writableFileStorageTier3.H(a5, (StorageProperties)a4);
                writableFileStorageTier3.H((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.H());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.H();
                a4 = writableFileStorageTier4.H(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.L.remove(a5);
                a6 = a5.H();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.H();
                        if (eventInformation.H()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.H().getAggregateSequenceNumber(), eventInformation.H(), a6);
                            a222.computeIfAbsent(eventInformation.H().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.H();
                writableFileStorageTier2.a.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.L.addToActiveSegment(Long.valueOf(a5.H()), a222);
        a4.H(n, 0);
        a3 = new WritePosition(a6, n, a5.H(), a4, Long.valueOf(a5.H()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.h.set(a3);
        writableFileStorageTier6.i.H((WritePosition)a3);
        A.info(DistributeLicenseService.H((Object)"eT$\tMLyD{GjZ>@p@j@\u007fEwS{M"), (Object)writableFileStorageTier2.e);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource H(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.C.get();
            File file = storageProperties.dataFile(writableFileStorageTier.m, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.B.remove(a4.H());
                    if (object != null) {
                        object.H(0L);
                    }
                    FileUtils.H((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.H() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.m, new FileVersion(a4.H(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.B.remove(a4.H());
                    if (a32222 != null) {
                        a32222.H(0L);
                    }
                    FileUtils.H((File)object);
                }
            }
            object = new RandomAccessFile(file, DistributeLicenseService.H((Object)"l^"));
            a32222 = ((RandomAccessFile)object).getChannel();
            A.info(AggregateIdExtractor.H((Object)"\u00187Yj,:\u0006$\n$\u0004j\u0005#\u000f/C1\u001e"), (Object)writableFileStorageTier.e, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.H(), a4.H(), writableFileStorageTier.e, storageProperties);
            writableFileStorageTier.B.put(a4.H(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.e + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    private static /* synthetic */ Optional H(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    private /* synthetic */ String H() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.e + "-" + writableFileStorageTier.e.H().name().toLowerCase();
    }

    private /* synthetic */ void E() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.B.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.e + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction H(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.e);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.H((List)a3);
        WritePosition a22 = writableFileStorageTier.H(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void G(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.B.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.H();
            byteBufferEventSource2.H(0L);
        }
        writableFileStorageTier.H((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.H((long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new i(a4, (WritePosition)a3), () -> a4.H((WritePosition)a3));
    }

    public long E() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.h.get()).G;
    }

    public long H() {
        WritableFileStorageTier a2;
        return a2.a.get();
    }

    private /* synthetic */ void H() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.H((SortedSet)a2);
        }
        A.info(AggregateIdExtractor.H((Object)"\u00187Yj*$\u0007/\u001bj\f$C.\n9\bj\n9C?\u0013j\u0017%C.\u0002>\u0006"), (Object)writableFileStorageTier.e);
    }

    public long H(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.D.checkFreeSpace(writableFileStorageTier2.G);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.H((List)a2, a222);
        WritePosition a222 = a2.H();
        writableFileStorageTier2.H(a222, a2.H(), hashMap);
        writableFileStorageTier.L.addToActiveSegment(a222.L, hashMap);
        writableFileStorageTier.a.set(a222.G + (long)a2.H().size() - 1L);
        writableFileStorageTier.i.E(a222);
        return a222.G;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.H((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    public void initSegments(long a2) {
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.a.H((List)a3, writableFileStorageTier.h, writableFileStorageTier.G, (arg_0, arg_1, arg_2) -> a5.H((Map)a2, arg_0, arg_1, arg_2));
    }

    private /* synthetic */ int H(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.e + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    private static /* synthetic */ Stream H(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition H(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.H(a5, (int)a3, (int)a2);
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.H(arg_0 -> WritableFileStorageTier.H((String)a2, arg_0), (Object)Flux.empty());
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.B.get(a2);
        if (a3 != null) {
            return a3.H();
        }
        return (Integer)writableFileStorageTier.H(arg_0 -> WritableFileStorageTier.H((Long)a2, arg_0), (Object)0);
    }

    private static /* synthetic */ Optional E(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.H(arg_0 -> WritableFileStorageTier.H((long)a2, a3, arg_0));
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.m);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.D.unregisterPath(writableFileStorageTier2.H());
        writableFileStorageTier.A.remove((Meter)a3.L);
        writableFileStorageTier2.i.H();
        writableFileStorageTier.B.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.H(0L);
            if (a2 != false) {
                void a5;
                a4.G(a5.longValue());
            }
        });
        a3.H((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.L.cleanup(bl2);
        if (bl2) {
            FileUtils.H((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.B.containsKey((long)a2)) {
            return a4.H((long)a2, a3);
        }
        return (Boolean)a4.H(arg_0 -> WritableFileStorageTier.H((long)a2, a3, arg_0), (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.h = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.a = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.B = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.A = a6;
        writableFileStorageTier3.D = a4;
        writableFileStorageTier3.e = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.i = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.L.complete(new FileVersion(a3.L.longValue(), 0));
            writableFileStorageTier.H(arg_0 -> writableFileStorageTier.H((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.H();
        stringArray[2] = "type";
        stringArray[3] = a10.H().name();
        a11.L = a6.gauge((MetricName)BaseMetricName.s, Tags.of((String[])stringArray), (Object)a11.i, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.a.get() - (double)a2.H();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion H(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.L.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.H((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.H();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.H());
            try {
                while (a42222.hasNext()) {
                    a42222.H();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.B.remove(a3.H());
            a2.H(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.B.remove(a3.H());
        a2.H(0L);
        return new FileVersion(l2, 0);
    }

    private static /* synthetic */ Boolean H(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.B.remove(a2.L);
        A.debug(DistributeLicenseService.H((Object)"VHpM{M>FhLl\teT2\tlLsHwGwGy\tmLyD{GjZ$\teT"), (Object)a2.L, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.H((long)((StorageProperties)writableFileStorageTier.C.get()).getPrimaryCleanupDelay());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void H(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.C.get();
        File file = new File(writableFileStorageTier.m);
        FileUtils.H((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.L.init();
        writableFileStorageTier2.H((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.G = file.toPath();
        writableFileStorageTier2.D.registerPath(writableFileStorageTier.H(), writableFileStorageTier.G, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    private /* synthetic */ void H(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        A.warn(DistributeLicenseService.H((Object)"Rc\u0013>kkEu\u0004}[{Hj@pN>@pM{Q>Lp]l@{Z>Oq[>Rc\tmLyD{GjZ"), (Object)a3.e, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.L.canBatchIndexParallel() && ((StorageProperties)a3.C.get()).isBulkIndexAllowParallel()) {
            A.info(AggregateIdExtractor.H((Object)"1\u001epC\u0003\r.\u00062\n$\u0004j\u0014#\u0017\"C:\u00028\u0002&\u000f/\u000fj\u0010?\u0013:\f8\u0017"), (Object)a3.e);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.H(arg_0 -> WritableFileStorageTier.E((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.H());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.H();
                        if (!eventInformation.H()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.H().getAggregateSequenceNumber(), eventInformation.H(), eventInformation.H());
                        hashMap.computeIfAbsent(eventInformation.H().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.L.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.e;
            objectArray[1] = a3.L.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.C.get()).isBulkIndexAllowParallel();
            A.info(DistributeLicenseService.H((Object)"Rc\u0013>`pM{QwGy\tmLo\\{Gj@\u007fErP>\u0001[_\u007fEkHj@qG>Fx\tnHlHrE{E>@pM{QwGy\u0013>@pM{Q]HnH|@r@j@{Z$Rc\t8\u000f>JqGjLf]MLj]wGyZ$Rc\u0000"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.H(arg_0 -> WritableFileStorageTier.E((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.H());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.H();
                        if (!eventInformation.H()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.H().getAggregateSequenceNumber(), eventInformation.H(), eventInformation.H());
                        hashMap.computeIfAbsent(eventInformation.H().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.L.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        A.warn(AggregateIdExtractor.H((Object)"\u00187Yj!?\u000f!N)\u0011/\u0002>\n$\u0004j\n$\u0007/\u001bj\u0017%\f!C1\u001e"), (Object)a3.e, (Object)Duration.between(instant, Instant.now()));
    }

    public int H() {
        WritableFileStorageTier a2;
        return a2.B.size();
    }

    protected Optional<EventSource> H(long a2) {
        WritableFileStorageTier a3;
        if (a3.B.containsKey(a2)) {
            return Optional.of((EventSource)a3.B.get(a2));
        }
        return Optional.empty();
    }

    protected Optional<EventSource> H(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.H(a2.H());
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.B.keySet();
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.B.values().stream().mapToLong(a2 -> a2.h.capacity()).sum() + (Long)a3.H(StorageTier::size, (Object)0L);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> H(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.B.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.H((File)a3.E(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).H())));
            }), (Stream)a5.H(arg_0 -> WritableFileStorageTier.E((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.H(arg_0 -> WritableFileStorageTier.H((long)a2, a4, arg_0), Stream.empty());
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.H((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.H(arg_0 -> WritableFileStorageTier.H((FileVersion)a2, arg_0), Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    public void E(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.B.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.B.firstKey()).longValue()) {
            A.info(DistributeLicenseService.H((Object)"eT$\tXFlJwGy\tpLf]>Z{NsLp]>]q\t|L>JlL\u007f]{M"), (Object)writableFileStorageTier.e);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.C.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.h.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.H(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.E(a22.getSegmentSize())) {
                A.debug(AggregateIdExtractor.H((Object)"\u00187Yj 8\u0006+\u0017#\r-C$\u0006=C9\u0006-\u000e/\r>C1\u001e"), (Object)writableFileStorageTier.e, (Object)writePosition2.G);
                WritePosition writePosition3 = writePosition2;
                writePosition3.a.H(writePosition3.h, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.H(new FileVersion(writePosition2.G, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.h.set(writePosition2.H((WritableEventSource)a3, 0));
                writableFileStorageTier2.i.E(new WritePosition(writePosition2.G, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.G), writePosition2.e));
            }
        }
        writableFileStorageTier.E();
    }

    private static /* synthetic */ boolean H(long a2, FileVersion a3) {
        if (a3.H() < a2) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    private static /* synthetic */ void H(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    private static /* synthetic */ Integer H(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    private static /* synthetic */ Flux H(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.H((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.H(arg_0 -> WritableFileStorageTier.H((long)a2, arg_0), Optional.empty());
    }

    private static /* synthetic */ Optional H(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }
}

