/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file.xref;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.integration.EndpointConnectionManager;
import io.axoniq.axonserver.integration.EventHandlerController;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.xref.Index;
import io.axoniq.axonserver.localstorage.file.xref.JumpSkipIndexEntries;
import io.axoniq.axonserver.localstorage.file.xref.i;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ReadOnlyJumpSkipIndexManager
implements IndexManager {
    protected final String K;
    protected static final Serializer<JumpSkipIndexEntries> k;
    protected final EventType m;
    public static final String J = "index";
    protected static final ScheduledExecutorService d;
    protected final String C;
    protected final Supplier<IndexManager> E;
    protected final ConcurrentSkipListMap<FileVersion, Index> l;
    protected final AtomicLong f;
    protected final AtomicBoolean D;
    protected final Supplier<StorageProperties> i;
    protected final MeterFactory.RateMeter a;
    protected final String B;
    protected final ConcurrentNavigableMap<Long, Integer> e;
    private static final Logger A;
    protected final AtomicLong h;
    protected final MeterFactory.RateMeter L;
    protected ScheduledFuture<?> G;

    public void addExistingIndex(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.e.put(a2.H(), a2.H());
        a3.H();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            void a2;
            void a3;
            ReadOnlyJumpSkipIndexManager a4;
            long a5;
            long l4 = a5 = a5;
            while (l4 >= (Long)readOnlyJumpSkipIndexManager.e.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a4 = readOnlyJumpSkipIndexManager2.H(a5);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.H((FileVersion)a4).H((String)a3);
                if (jumpSkipIndexEntries == null) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = readOnlyJumpSkipIndexManager.C;
                    objectArray[1] = a3;
                    objectArray[2] = a4;
                    A.debug(EndpointConnectionManager.H((Object)"\u0000\u0014AI\u001e\u0007\u000f\u001b\u0012\f\bI\u001d\u0006\tI\u0000\u0014[\u0007\u0014\u001d[\u000f\u0014\u001c\u0015\r[\u0000\u0015I\b\f\u001c\u0004\u001e\u0007\u000fI\u0000\u0014"), objectArray);
                    return null;
                }
                if (jumpSkipIndexEntries.firstSequenceNumber() < a2) {
                    JumpSkipIndexEntries jumpSkipIndexEntries2 = jumpSkipIndexEntries;
                    return new SegmentIndexEntries((FileVersion)a4, jumpSkipIndexEntries2.range(jumpSkipIndexEntries2.firstSequenceNumber(), (long)a2, EventType.L.equals((Object)readOnlyJumpSkipIndexManager.m)));
                }
                l4 = jumpSkipIndexEntries.H();
            }
            a4 = (IndexManager)readOnlyJumpSkipIndexManager.E.get();
            if (a4 == null) return null;
            return a4.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, a5);
        }
        catch (IndexNotFoundException a5) {
            A.debug(EventHandlerController.H((Object)"^J\u001f\u0017LYAR]\u0017KXQ\u0017CXPYA"), (Object)readOnlyJumpSkipIndexManager.C, (Object)a5);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = fileVersion;
        ReadOnlyJumpSkipIndexManager a4 = this;
        if (a4.e.containsKey(a3.H())) {
            return a4.H((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.E.get();
        if (indexManager != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.C;
            objectArray[1] = a3.H();
            objectArray[2] = a3.H();
            A.debug(EventHandlerController.H((Object)"^J\u001f\u0017DTQ^SVQR\u0005LX\u0017CXW\u0017^J\u0005^K\u0017KR]C\u0005CLRW"), objectArray);
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    protected void E() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager = this;
        while (readOnlyJumpSkipIndexManager2.l.size() > ((StorageProperties)readOnlyJumpSkipIndexManager.i.get()).getMaxIndexesInMemory()) {
            Map.Entry a2 = readOnlyJumpSkipIndexManager.l.pollFirstEntry();
            A.debug(EventHandlerController.H((Object)"LX\r\u0005tIXV^KP\u0005^KS@O\u0005LX"), (Object)readOnlyJumpSkipIndexManager.C, a2.getKey());
            readOnlyJumpSkipIndexManager.G = d.schedule(() -> ((Index)a2.getValue()).close(), 2L, TimeUnit.SECONDS);
            readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(FileVersion fileVersion, HTreeMap hTreeMap, String string, List list) {
        void a2;
        int n;
        List a3;
        void a4;
        JumpSkipIndexEntries a5;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = list2;
        List list2 = list;
        ReadOnlyJumpSkipIndexManager a6 = readOnlyJumpSkipIndexManager;
        a5 = a6.H((FileVersion)a5, (String)a4);
        IndexEntry indexEntry = (IndexEntry)a3.get(0);
        Integer[] integerArray = new Integer[a3.size()];
        int n2 = n = 0;
        while (n2 < a3.size()) {
            int n3 = n++;
            integerArray[n3] = ((IndexEntry)a3.get(n3)).H();
            n2 = n;
        }
        a2.put((Object)a4, (Object)new JumpSkipIndexEntries(a5.H(), indexEntry.H(), integerArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(File file, File file2) {
        void a2;
        File a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.C;
        objectArray[1] = a3.getAbsolutePath();
        objectArray[2] = a2.getAbsolutePath();
        A.debug(EndpointConnectionManager.H((Object)"\u0012\u0006S[;\u001e\u0007\u001a\u0004\u0012\u0007\u001cI\u000f\u0001\u001eI\u000f\f\u0016\u0019\u0014\u001b\u001a\u001b\u0002I\u0012\u0007\u001f\f\u0003I\u0000\u0014[\u001d\u0014I\u0000\u0014"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public void E(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = this;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        if (a3.H((FileVersion)a4)) {
            a3.H((FileVersion)a4, (Map)a2);
            return;
        }
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = (ReadOnlyJumpSkipIndexManager)a3.E.get();
        if (readOnlyJumpSkipIndexManager != null) {
            readOnlyJumpSkipIndexManager.E((FileVersion)a4, (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean validIndex(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        boolean a3 = false;
        try {
            StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.i.get();
            a3 = storageProperties.newIndex(readOnlyJumpSkipIndexManager.B, (FileVersion)a2).exists();
            return a3;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = readOnlyJumpSkipIndexManager.C;
            objectArray[1] = a2;
            objectArray[2] = exception;
            A.warn(EndpointConnectionManager.H((Object)"\u0000\u0014AI=\b\u0012\u0005\u001e\r[\u001d\u0014I\r\b\u0017\u0000\u001f\b\u000f\f[\u0000\u0015\r\u001e\u0011[\u000f\u0014\u001b[\u001a\u001e\u000e\u0016\f\u0015\u001dAI\u0000\u0014"), objectArray);
            return a3;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        long a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        try {
            void a4;
            void a5;
            void a6;
            ReadOnlyJumpSkipIndexManager a7;
            void a8;
            while (a3 >= a8 && a3 >= (Long)readOnlyJumpSkipIndexManager.e.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a7 = readOnlyJumpSkipIndexManager2.H(a3);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.H((FileVersion)a7, (String)a2);
                if (jumpSkipIndexEntries != null) {
                    IndexEntries indexEntries = jumpSkipIndexEntries.range((long)a6, (long)a5, EventType.L.equals((Object)readOnlyJumpSkipIndexManager.m));
                    if (!indexEntries.isEmpty()) {
                        treeMap.put((FileVersion)a7, indexEntries);
                        if (readOnlyJumpSkipIndexManager.H((long)a6, (long)(a4 -= (long)indexEntries.size()), (IndexEntries)jumpSkipIndexEntries)) {
                            return treeMap;
                        }
                    }
                    if (jumpSkipIndexEntries.H() >= a7.H()) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = readOnlyJumpSkipIndexManager.C;
                        objectArray[1] = readOnlyJumpSkipIndexManager.m;
                        objectArray[2] = a2;
                        objectArray[3] = a7;
                        throw new MessagingPlatformException(ErrorCode.INDEX_READ_ERROR, String.format(EndpointConnectionManager.H((Object)"L\bS[ \u0015\u001f\u001a\u0005\u0012\r[\u0000\u0015\r\u001e\u0011[\f\u0015\u001d\t\u0010[\u000f\u0014\u001b[L\bI^\u001a[\u0000\u0015I\b\f\u001c\u0004\u001e\u0007\u000fI^\u001aWI\u0017\u0000\u0015\u0002\bI\u000f\u0006[\u0007\u001e\u001e\u001e\u001b[\u001d\u0014\u0002\u001e\u0007"), objectArray));
                    }
                    if (jumpSkipIndexEntries.firstSequenceNumber() > 0L && jumpSkipIndexEntries.H() == -1L) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = readOnlyJumpSkipIndexManager.C;
                        objectArray[1] = a2;
                        objectArray[2] = a7;
                        objectArray[3] = jumpSkipIndexEntries.firstSequenceNumber();
                        A.warn(EventHandlerController.H((Object)"^J\u001f\u0017LYSVI^A\u0017UE@ALXPD\u0005CJ\\@Y\u0005@M^IR\u0005E@VA^KP\u0005RSRKCV\u0017CXW\u0017^J\t\u0017UE@ALXPD\u0005CJ\\@Y\u0005\u001a\u0014\u0017LY\u0005D@PHRKC\u0005LX\u0017GBQ\u0017C^WDQ\u0017VRTB@YFR\u0005YPZGRW\u0017LD\u0005LX\u001b\u0005TJYQ^KB@\u0017LY\u0005GWRS^JBV\u0017VRBZ@YQ"), objectArray);
                        a3 = a7.H() - 1L;
                        continue;
                    }
                    a3 = jumpSkipIndexEntries.H();
                    continue;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.C;
                objectArray[1] = a2;
                objectArray[2] = a7;
                A.warn(EndpointConnectionManager.H((Object)"\u0012\u0006S[\u0000\u0015\u001f\u001a\u0005\u0012\r[\u0019\t\f\r\u0000\u0014\u001c\bI\u000f\u0006\u0010\f\u0015I\f\u0001\u0012\u0005\u001eI\t\f\u001a\r\u0012\u0007\u001cI\u001e\u001f\u001e\u0007\u000f\u001a[\u000f\u0014\u001b[\u0012\u0006E[\b\u001c\u000e\t\f\u001c\b\u000f\f[\u0007\u0014\u001d[\u000f\u0014\u001c\u0015\r[\u0000\u0015I\b\f\u001c\u0004\u001e\u0007\u000fI\u0000\u0014WI\u0018\u0006\u0015\u001d\u0012\u0007\u000e\f[\u0000\u0015I\u000b\u001b\u001e\u001f\u0012\u0006\u000e\u001a[\u001a\u001e\u000e\u0016\f\u0015\u001d"), objectArray);
                a3 = a7.H() - 1L;
            }
            a7 = (IndexManager)readOnlyJumpSkipIndexManager.E.get();
            if (a7 == null) return treeMap;
            treeMap.putAll(((IndexManager)readOnlyJumpSkipIndexManager.E.get()).lookupAggregateInClosedSegments((String)a2, (long)a6, (long)a5, (long)a4, (long)a8, a3));
            return treeMap;
        }
        catch (IndexNotFoundException a7) {
            Object[] objectArray = new Object[4];
            objectArray[0] = readOnlyJumpSkipIndexManager.C;
            objectArray[1] = a2;
            objectArray[2] = a3;
            objectArray[3] = readOnlyJumpSkipIndexManager.e;
            A.warn(EventHandlerController.H((Object)"LX\r\u0005RWEJE\u0005E@VA^KP\u0005RSRKCV\u0017CXW\u0017^J\t\u0017UE@ALXPD\u0005CJ\\@Y\u0005LX\u001b\u0005^KS@O@D\u0005LX"), objectArray);
        }
        return treeMap;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(FileVersion fileVersion, Throwable throwable) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = fileVersion;
        ReadOnlyJumpSkipIndexManager a4 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4.C;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a2;
        A.warn(EventHandlerController.H((Object)"LX\r\u0005rWEJE\u0005@M^IR\u0005VFCLADCLYB\u0017VRBZ@YQ\u0017^J\u0005A@EV^JY\u0005LX"), objectArray);
    }

    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(EventHandlerController.H((Object)"xURWVQ^JY\u0005XK[\\\u0017VBUGJEQRA\u0017CXW\u0017UELZDE\\\u0017LYAR]\u0017HVKVBRW"));
    }

    public long size() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a2 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.E.get();
        if (a2 != null) {
            return readOnlyJumpSkipIndexManager.h.get() + a2.size();
        }
        return readOnlyJumpSkipIndexManager.h.get();
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return a3.H((FileVersion)a2).H();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ File H(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return a2.newIndex(a4.B, new FileVersion(((Long)a3.getKey()).longValue(), ((Integer)a3.getValue()).intValue()));
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a2;
        void a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a4 = (StorageProperties)readOnlyJumpSkipIndexManager.i.get();
        return readOnlyJumpSkipIndexManager.e.entrySet().stream().filter(arg_0 -> ReadOnlyJumpSkipIndexManager.H((long)a3, (int)a2, arg_0)).map(arg_0 -> readOnlyJumpSkipIndexManager.H((StorageProperties)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StorageProperties storageProperties;
        block10: {
            StorageProperties storageProperties2;
            block8: {
                Map<String, List> a2;
                void a32;
                int a222 = n;
                ReadOnlyJumpSkipIndexManager a4 = this;
                storageProperties2 = (StorageProperties)a4.i.get();
                Object a222 = new FileVersion((long)a32, a222);
                if (a2 == null) {
                    a2 = Collections.emptyMap();
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = a222;
                objectArray[1] = storageProperties2.newIndex(a4.B, (long)a32);
                objectArray[2] = a2.keySet();
                A.debug(EventHandlerController.H((Object)"LX\r\u0005TWRDC@\u0017^J\t\u0017NR\\D\u0005LX"), objectArray);
                a222 = storageProperties2.newTransformedIndex(a4.B, (FileVersion)a222);
                try {
                    Files.deleteIfExists(((File)a222).toPath());
                }
                catch (IOException iOException) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, EndpointConnectionManager.H((Object)"/\u001a\u0000\u0017\f\u001fI\u000f\u0006[\r\u001e\u0005\u001e\u001d\u001eI\u000f\u001b\u001a\u0007\b\u000f\u0014\u001b\u0016\f\u001fI\u0012\u0007\u001f\f\u0003I\u001d\u0000\u0017\f"), (Throwable)iOException);
                }
                storageProperties2 = DBMaker.fileDB((File)a222).fileMmapEnable().cleanerHackEnable().make();
                a222 = storageProperties2.hashMap(J, (Serializer)Serializer.STRING, k).createOrOpen();
                try {
                    Integer n2 = (Integer)a4.e.get((long)a32);
                    FileVersion a32 = new FileVersion((long)a32, n2.intValue());
                    a2.forEach((arg_0, arg_1) -> a4.H(a32, (HTreeMap)a222, arg_0, arg_1));
                    if (a222 == null) break block8;
                    storageProperties = storageProperties2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a222 != null) {
                            try {
                                a222.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable a32) {
                                throwable.addSuppressed(a32);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a222.close();
                break block10;
            }
            storageProperties = storageProperties2;
        }
        storageProperties.close();
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        readOnlyJumpSkipIndexManager.l.forEach((fileVersion, index) -> {
            FileVersion a2 = index;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        readOnlyJumpSkipIndexManager.l.clear();
        if (a2 != false) {
            readOnlyJumpSkipIndexManager.e.keySet().forEach(arg_0 -> readOnlyJumpSkipIndexManager.removeAllVersions(arg_0));
        }
        if (readOnlyJumpSkipIndexManager.G != null && !readOnlyJumpSkipIndexManager.G.isDone()) {
            readOnlyJumpSkipIndexManager.G.cancel(true);
        }
        try {
            ReadOnlyJumpSkipIndexManager a3 = (IndexManager)readOnlyJumpSkipIndexManager.E.get();
            if (a3 != null) {
                a3.cleanup((boolean)a2);
                return;
            }
        }
        catch (Exception a3) {
            A.info(EndpointConnectionManager.H((Object)"\u0012\u0006S[*\u0017\f\u001a\u0007\u000e\u0019[\u0006\u001dI\u0012\u0007\u001f\f\u0003I\u001d\b\u0012\u0005\u001e\r"), (Object)readOnlyJumpSkipIndexManager.C, (Object)a3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono H(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        Object a3 = ((StorageProperties)readOnlyJumpSkipIndexManager.i.get()).newTransformedIndex(readOnlyJumpSkipIndexManager.B, (FileVersion)a2);
        return readOnlyJumpSkipIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntry;
        ReadOnlyJumpSkipIndexManager a2 = readOnlyJumpSkipIndexManager;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean H(long l2, long l3, IndexEntries indexEntries) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3;
        void a4;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntries;
        ReadOnlyJumpSkipIndexManager a5 = readOnlyJumpSkipIndexManager;
        if (a4 >= a3.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    public void init() {
        File[] fileArray = this;
        if (!fileArray.D.get()) {
            int n2;
            File[] a2 = new File(fileArray.B).listFiles(file -> {
                File a2 = file;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return a2.getName().endsWith(a3.K);
            });
            if (a2 == null) {
                return;
            }
            int n3 = a2.length;
            int n4 = n2 = 0;
            while (n4 < n3) {
                File file2 = a2[n2];
                FileVersion fileVersion = FileUtils.H((String)file2.getName());
                fileArray.e.compute(fileVersion.H(), (l2, n) -> {
                    Integer a2 = n;
                    FileVersion a3 = fileVersion;
                    return a2 == null ? a3.H() : Math.max(a3.H(), a2);
                });
                fileArray.h.addAndGet(file2.length());
                n4 = ++n2;
            }
            fileArray.H();
            fileArray.D.set(true);
        }
    }

    public void complete(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        fileVersion = this;
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Mono.defer(() -> a3.H((FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    public Index H(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        A.debug(EventHandlerController.H((Object)"iXJ\\LYB\u0017CXW\u0017^J\t\u0017LYAR]RV\r\u0005LX"), (Object)((long)a2), (Object)readOnlyJumpSkipIndexManager.e);
        Object a3 = (Integer)readOnlyJumpSkipIndexManager.e.get((long)a2);
        if (a3 != null) {
            return readOnlyJumpSkipIndexManager.H(new FileVersion((long)a2, ((Integer)a3).intValue()));
        }
        a3 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.E.get();
        if (a3 != null) {
            A.debug(EndpointConnectionManager.H((Object)"\u0000\u0014AI\u001d\u0000\u0015\r[\u0000\u0015\r\u001e\u0011[\u000f\u0014\u001b[\u0012\u0006I\u0012\u0007[\u0007\u001e\u0011\u000fI\u000f\u0000\u001e\u001b"), (Object)readOnlyJumpSkipIndexManager.C, (Object)((long)a2));
            return a3.H((long)a2);
        }
        throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.C + ": Index not found: " + (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected FileVersion H(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        NavigableSet<Long> a3 = readOnlyJumpSkipIndexManager.e.keySet().tailSet((long)a2, true);
        if (a3.isEmpty()) {
            throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.C + ": Index for token not found: " + (long)a2);
        }
        return new FileVersion(((Long)a3.first()).longValue(), ((Integer)readOnlyJumpSkipIndexManager.e.get(a3.first())).intValue());
    }

    private /* synthetic */ void H(FileVersion fileVersion, File file) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        A.debug(EventHandlerController.H((Object)"^J\u001f\u0017dTQ^SVQ^KP\u0005^KS@O\u0005QJE\u0005QL[@A@EV^JY\u0005LX"), (Object)a3.C, (Object)a2);
    }

    MeterFactory.RateMeter H() {
        ReadOnlyJumpSkipIndexManager a2;
        return a2.L;
    }

    /*
     * WARNING - void declaration
     */
    protected File H(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        void a2;
        File a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2;
        block9: {
            ReadOnlyJumpSkipIndexManager a222;
            block7: {
                readOnlyJumpSkipIndexManager2 = this;
                a222 = (StorageProperties)readOnlyJumpSkipIndexManager2.i.get();
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = a222.newIndex(readOnlyJumpSkipIndexManager2.B, (FileVersion)a3);
                objectArray[2] = a2.keySet();
                A.debug(EventHandlerController.H((Object)"LX\r\u0005TWRDC@\u0017^J\t\u0017NR\\D\u0005LX"), objectArray);
                a3 = a222.newIndexTemp(readOnlyJumpSkipIndexManager2.B, a3.H());
                try {
                    Files.deleteIfExists(a3.toPath());
                }
                catch (IOException a222) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, EndpointConnectionManager.H((Object)"/\u001a\u0000\u0017\f\u001fI\u000f\u0006[\r\u001e\u0005\u001e\u001d\u001eI\u000f\f\u0016\u0019\u0014\u001b\u001a\u001b\u0002I\u0012\u0007\u001f\f\u0003I\u001d\u0000\u0017\f"), (Throwable)a222);
                }
                a222 = DBMaker.fileDB((File)a3).fileMmapEnable().cleanerHackEnable().make();
                HTreeMap hTreeMap = a222.hashMap(J, (Serializer)Serializer.STRING, k).create();
                try {
                    hTreeMap.putAll((Map)a2);
                    a222.commit();
                    if (hTreeMap == null) break block7;
                    readOnlyJumpSkipIndexManager = a222;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block9;
            }
            readOnlyJumpSkipIndexManager = a222;
        }
        readOnlyJumpSkipIndexManager.close();
        File file = a3;
        readOnlyJumpSkipIndexManager2.H(file, a2.size());
        return file;
    }

    protected void H() {
        ReadOnlyJumpSkipIndexManager a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a2;
        readOnlyJumpSkipIndexManager.f.set(readOnlyJumpSkipIndexManager.e.keySet().stream().skip(((StorageProperties)a2.i.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    static {
        A = LoggerFactory.getLogger(ReadOnlyJumpSkipIndexManager.class);
        k = new i();
        d = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(EndpointConnectionManager.H((Object)"\u0003\bD\u0012\u0007\u001f\f\u0003D\u0016\b\u0015\b\u001c\f\tD")));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ JumpSkipIndexEntries H(FileVersion fileVersion, String string) {
        void a2;
        void a3;
        int n;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        int n2 = n = 3;
        while (n2 > 0) {
            try {
                ReadOnlyJumpSkipIndexManager a4 = readOnlyJumpSkipIndexManager.H((FileVersion)a3);
                return a4.H((String)a2);
            }
            catch (DBException a4) {
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.C;
                objectArray[1] = a3;
                objectArray[2] = a4;
                A.debug(EventHandlerController.H((Object)"^J\u001f\u0017lYAR]\u0017au\u0005R]T@GQ^JY\u0005LX"), objectArray);
                n2 = --n;
            }
            catch (IllegalAccessError a4) {
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.C;
                objectArray[1] = a3;
                objectArray[2] = a4;
                A.debug(EndpointConnectionManager.H((Object)"\u0012\u0006S[\u0000\u0017\u0005\u001e\u000e\u001a\u0005[\b\u0018\n\u001e\u001a\bI\u0000\u0014"), objectArray);
                n2 = --n;
            }
        }
        throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.C + ": Index not found for segment " + (FileVersion)a3 + ", aggregate " + (String)a2);
    }

    private /* synthetic */ File H(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.i.get()).newIndex(a3.B, (FileVersion)a2);
    }

    private static /* synthetic */ boolean H(long l2, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ Mono H(File file, File file2, File file3) {
        File a2 = file2;
        File a3 = file;
        return FileUtils.H((File)a3, (File)a2);
    }

    public boolean remove(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a22 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Index index = (Index)a3.l.remove(a22);
        if (index != null) {
            A.debug(EventHandlerController.H((Object)"tIXVR\u0005^KS@O\u0005LX"), (Object)a22);
            index.close();
        }
        a3.e.remove(a22.H(), a22.H());
        if (A.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.hashCode();
            objectArray[1] = a22;
            objectArray[2] = a3.e.keySet();
            A.debug(EndpointConnectionManager.H((Object)"\u0012\u0006S[-\u001e\u0005\u001e\u001d\u001e\r[\u001a\u001e\u000e\u0016\f\u0015\u001d[\u0012\u0006E[\u001b\u001e\u0004\u001a\u0000\u0015\u0000\u0015\u000e[\u001a\u001e\u000e\u0016\f\u0015\u001d\bI\u0000\u0014"), objectArray);
        }
        File file = ((StorageProperties)a3.i.get()).newIndex(a3.B, (FileVersion)a22);
        long l2 = file.length();
        boolean a22 = FileUtils.H((File)file);
        if (a22) {
            a3.h.addAndGet(-l2);
        }
        return a22;
    }

    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        ReadOnlyJumpSkipIndexManager a2 = searchHint;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    protected void H(File var1_2, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        Object a2 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(EndpointConnectionManager.H((Object)"0\u0014\u001c[\n\u001a\u0007[\u0006\u0015\u0005\u0002I\u0018\u001b\u001e\b\u000f\f[\b\u0015I\u0012\u0007\u001f\f\u0003I\u001d\u001b\u0014\u0004[\u001d\u0013\f[9\t\u0000\u0016\b\t\u00101\u001c\u0016\u0019(\u0002\u0012\u00192\u0007\u001f\f\u0003$\u001a\u0007\u001a\u000e\u001e\u001b"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> H(FileVersion fileVersion, File file) {
        void a3;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        ReadOnlyJumpSkipIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.H((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).doOnNext(arg_0 -> a5.H((FileVersion)a4, arg_0)).flatMap(arg_0 -> a5.H((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.H((FileVersion)a4, arg_0)).doOnError(arg_0 -> a5.H((FileVersion)a4, arg_0));
    }

    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> readOnlyJumpSkipIndexManager) {
        Object a2 = readOnlyJumpSkipIndexManager;
        readOnlyJumpSkipIndexManager = this;
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Collections.singletonList(((StorageProperties)a3.i.get()).newIndex(a3.B, (FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono H(File file, File file2) {
        void a2;
        Object a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return Mono.fromSupplier(() -> ReadOnlyJumpSkipIndexManager.H((File)a2)).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).doOnNext(arg_0 -> a4.H((File)a3, arg_0)).flatMap(arg_0 -> ReadOnlyJumpSkipIndexManager.H((File)a2, (File)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.i.get();
        Integer n = (Integer)readOnlyJumpSkipIndexManager.e.remove((long)a2);
        if (n != null) {
            int a3;
            int n2 = a3 = 0;
            while (n2 < n) {
                FileVersion fileVersion = new FileVersion((long)a2, a3);
                if (storageProperties.newIndex(readOnlyJumpSkipIndexManager.B, fileVersion).exists()) {
                    readOnlyJumpSkipIndexManager.remove(fileVersion);
                }
                n2 = ++a3;
            }
            return readOnlyJumpSkipIndexManager.remove(new FileVersion((long)a2, n.intValue()));
        }
        return true;
    }

    private /* synthetic */ void H(FileVersion fileVersion, Void void_) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.e.put(a2.H(), a2.H());
    }

    /*
     * WARNING - void declaration
     */
    public ReadOnlyJumpSkipIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        ReadOnlyJumpSkipIndexManager a7;
        Object a8 = string;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a7 = this;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = a7;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager3 = a7;
        a7.l = new ConcurrentSkipListMap();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager4 = a7;
        readOnlyJumpSkipIndexManager3.e = new ConcurrentSkipListMap(Comparator.reverseOrder());
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager5 = a7;
        a7.f = new AtomicLong();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager6 = a7;
        a7.D = new AtomicBoolean(false);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager7 = a7;
        a7.h = new AtomicLong();
        readOnlyJumpSkipIndexManager2.C = a8;
        readOnlyJumpSkipIndexManager2.i = a6;
        readOnlyJumpSkipIndexManager.B = a5;
        readOnlyJumpSkipIndexManager.m = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a8;
        stringArray[2] = "type";
        stringArray[3] = a4.name();
        a8 = Tags.of((String[])stringArray);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager8 = a7;
        readOnlyJumpSkipIndexManager8.L = a3.rateMeter((MetricName)BaseMetricName.Ca, (Tags)a8);
        readOnlyJumpSkipIndexManager8.a = a3.rateMeter((MetricName)BaseMetricName.j, (Tags)a8);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager9 = a7;
        readOnlyJumpSkipIndexManager9.E = a2;
        readOnlyJumpSkipIndexManager9.K = ((StorageProperties)a6.get()).getNewIndexSuffix();
        d.scheduleAtFixedRate(() -> a7.E(), 10L, 10L, TimeUnit.SECONDS);
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5, long l6) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(EventHandlerController.H((Object)"jG@EDCLXK\u0017JYIN\u0005DPGUXWC@S\u0005XK\u0017UELZDE\\\u0017LYAR]\u0017HVKVBRW"));
    }

    /*
     * WARNING - void declaration
     */
    protected Index H(FileVersion fileVersion2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            return readOnlyJumpSkipIndexManager.l.computeIfAbsent(a2, fileVersion -> {
                ReadOnlyJumpSkipIndexManager a2 = fileVersion;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return new Index(a3, (FileVersion)a2);
            }).H();
        }
        catch (IndexNotFoundException a3) {
            readOnlyJumpSkipIndexManager.l.remove(a2);
            throw a3;
        }
    }

    private /* synthetic */ boolean H(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.i.get()).dataFile(a3.B, (FileVersion)a2).exists();
    }

    private static /* synthetic */ File H(File a2) {
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        Object a222 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.C;
        objectArray[1] = a3.m;
        objectArray[2] = a2;
        A.info(EndpointConnectionManager.H((Object)"\u0000\u0014AI\u0018\u001b\u001e\b\u000f\f[\u0012\u0006I\u0012\u0007\u001f\f\u0003I\u001d\u0006\tI\u0000\u0014"), objectArray);
        StorageProperties storageProperties = (StorageProperties)a3.i.get();
        Object object = a222 == null ? Collections.emptyMap() : a222;
        a222 = a3.H((FileVersion)a2, (Map)object);
        object = storageProperties.newIndex(a3.B, (FileVersion)a2);
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(((File)a222).toPath(), ((File)object).toPath(), copyOptionArray);
            a3.h.addAndGet(((File)object).length());
            a3.e.put(a2.H(), a2.H());
            return;
        }
        catch (IOException a222) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a3.B, (FileVersion)a2), (Throwable)a222);
        }
    }
}

