/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.component.processor.EventProcessorResultListener;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalNode;
import io.axoniq.axonserver.logging.i;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger G = AuditLog.getLogger();

    @EventListener
    public void on(AbstractAuthenticationEvent abstractAuthenticationEvent) {
        AuditLog a2 = abstractAuthenticationEvent;
        AuditLog a3 = this;
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (G.isDebugEnabled()) {
            G.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            G.info(EventProcessorResultListener.H((Object)"\u000fh$n-'4n7ocr0b1i\"j&'a|>%m"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            G.error(InternalNode.H((Object)"\u007f`Tf]/DfGg\u0013z@jAaRbV/\u0011tN-\u0013IrF\u007fJw5\u0013tN"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    public static String username(String a2) {
        if (a2 == null) {
            return EventProcessorResultListener.H((Object)"\u007ff-h-~.h6t}");
        }
        return StringUtils.sanitize((String)a2);
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated adminUserUpdated) {
        AuditLog a2 = adminUserUpdated;
        AuditLog a3 = this;
        if (G.isDebugEnabled()) {
            G.debug(a2.toString());
        }
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return InternalNode.H((Object)"\u000fn]`]v^`F|\r");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted adminUserDeleted) {
        AuditLog a2 = adminUserDeleted;
        AuditLog a3 = this;
        if (G.isDebugEnabled()) {
            G.debug(a2.toString());
        }
    }

    public AuditLog() {
        AuditLog a2;
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return EventProcessorResultListener.H((Object)"\u0006I\u0002E\u000fB\u0007");
        }
        return InternalNode.H((Object)"Kz\\rM\u007fJw");
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + i.G.H()[2].getName()));
    }
}

