/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final Predicate<String> l;
    private final RaftConfigServiceFactory f;
    private static final Logger D = AuditLog.getLogger();
    public static final String i = "_none";
    private final ClusterTemplateController a;
    private final DistributeLicenseService B;
    private final ClusterTopology e;
    private final FeatureChecker A;
    private static final Logger h = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterController L;
    private final ApplicationEventPublisher G;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void H(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        D.info(ContextNameValidation.H((Object)"\u001e\u001c8:e5 \u00160\u00026\u0013e\u000b,\u0004 \t6\u0002e\u00125\u0003$\u0013 I"), (Object)AuditLog.username((Principal)a2));
        h.info(AccessControlConfiguration.H((Object)"h1QtJ=E1H'CtS$J;G0C0\ntV1T2I&K=H3\u00068O7C:U1\u0006!V0G Cz\bz"));
        try {
            void licenseFile;
            clusterRestController.B.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, ContextNameValidation.H((Object)")*G)\u0002$\u0003 \u0015e\u0001*\u0015e8$\u0003(\u000e+Ie\"+\u00140\u0015 G1\u000f$\u0013e\u0013-\u0002e8$\u0003(\u000e+G7\u00025\u000b,\u0004$\u0013,\b+G\"\u0015*\u00125G,\u0014e\u00047\u0002$\u0013 \u0003e\u0005 \u0001*\u0015 G0\u0017)\b$\u0003,\t\"G$G)\u000e&\u0002+\u0014 I"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void H(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        D.info(AccessControlConfiguration.H((Object)"\u000f]){tt1W!C'RtE8S'R1TtR1K$J5R1\u00060I#H8I5Bz"), (Object)AuditLog.username((Principal)object));
        if (a2.e.isAdminNode()) {
            ServletOutputStream resp;
            object = ContextNameValidation.H((Object)"&\u000b0\u00141\u00027J1\u0002(\u0017)\u00061\u0002k\u001e(\u000b");
            String string = a2.a.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(AccessControlConfiguration.H((Object)" C,R{V8G=Ho\u00067N5T'C \u001b!R2\u000bl"));
            v1.addHeader(ContextNameValidation.H((Object)"$*\t1\u0002+\u0013h#,\u00145\b6\u000e1\u000e*\t"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(AccessControlConfiguration.H((Object)"\rI!\u00067G:\u0006!U1\u0006 N=Ut@!H7R=I:G8O _tI:J-\u00062T;KtG0K=HtH;B1"));
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode H(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        D.info(AccessControlConfiguration.H((Object)"\u000f]){tt1W!C'RtH;B1\u00060C G=J'\u00062I&\u0006/[z"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.L.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.L.isActive((String)object));
    }

    @GetMapping
    public List<JsonClusterNode> H(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        D.info(ContextNameValidation.H((Object)"<>\u001a\u0018G\u0017\u00024\u0012 \u00141G1\be\u000b,\u00141G+\b!\u00026I"), (Object)AuditLog.username((Principal)object));
        return a2.L.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.L.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void H(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        D.info(AccessControlConfiguration.H((Object)"\u000f]){tt1W!C'RtR;\u00060C8C CtH;B1\u0006/[z"), (Object)AuditLog.username((Principal)a2), object);
        name.f.getRaftConfigService().deleteNode((String)object);
    }

    @PostMapping
    public ResponseEntity<RestResponse> H(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        D.info(ContextNameValidation.H((Object)"\u001e\u001c8:e5 \u00160\u00026\u0013e\u0013*G/\b,\te\u0004)\u00126\u0013 \u0015e\u00061G>\u001a\u007f\u001c8I"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.L.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, AccessControlConfiguration.H((Object)"\u0017G:H;RtE;K6O:CtL;O:O:AtE;H C,RtQ=R<\u0006:I\u0017I:R1^ Uz"));
            }
            if (!RaftAdminGroup.H((String)string) && !jsonClusterNode.l.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            h.debug(ContextNameValidation.H((Object)"$\u0003!Ol]e5 \u0000,\u00141\u00027\u000e+\u0000e\n<\u0014 \u000b#G$\t!G$\u0003!\u000e+\u0000e\n G1\be\u0004*\t1\u0002=\u0013eE>\u001agI"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            h.debug(AccessControlConfiguration.H((Object)"5B0\u000e}\u001ctt1A=U C&O:AtK-U1J2\u00065H0\u00065B0O:AtK1\u0006 ItH;\u00067I:R1^ Uz"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            h.debug(ContextNameValidation.H((Object)"$\u0003!Ol]e5 \u0000,\u00141\u00027\u000e+\u0000e\n<\u0014 \u000b#G$\t!G$\u0003!\u000e+\u0000e\n G1\be\u0006)\u000be\u0004*\t1\u0002=\u00136I"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.L.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, AccessControlConfiguration.H((Object)"h;B1\u00065J&C5B-\u0006&C3O'R1T1BtO:\u00065\u00067J!U C&")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.f.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.G.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, ContextNameValidation.H((Object)"\u0004\u0004&\u00025\u0013 \u0003e\r*\u000e+G7\u00024\u0012 \u00141Ke\n$\u001ee\u0013$\f G$G2\u000f,\u000b G1\be\u00177\b&\u00026\u0014")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.l = new ContextNameValidation();
        a9.L = a8;
        clusterRestController5.f = a7;
        clusterRestController5.A = a6;
        clusterRestController4.B = a5;
        clusterRestController4.G = a4;
        clusterRestController3.e = a3;
        clusterRestController3.a = a2;
    }
}

