/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.google.common.util.concurrent.AtomicDouble;
import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.instance.PlatformClientComponents;
import io.axoniq.axonserver.component.processor.balancing.strategy.MergedProcessorLoadBalancingService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.EnterpriseCommandCache;
import io.axoniq.axonserver.message.command.CommandInformation;
import io.axoniq.axonserver.metric.AxonServerMetric;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricCollector;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.transport.rest.v2.CommandsRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.CounterMetric;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"v2/commands"})
@CrossOrigin
@Tag(name="Commands", description="Operations for monitoring and managing commands in Axon Server")
public class CommandsRestControllerV2 {
    private final PlatformClientComponents i;
    private final MeterRegistry a;
    private static final MetricName B;
    private static final String e = "_all_";
    private static final Logger A;
    private final MetricCollector h;
    private final VisibleContexts L;
    private final EnterpriseCommandCache G;

    static {
        A = AuditLog.getLogger();
        B = BaseMetricName.d;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"}, path={"longrunning"})
    @Operation(summary="List long-running commands", description="Retrieves information about commands that have been running for longer than the specified interval")
    @ApiResponse(responseCode="200", description="Long-running commands retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=LongRunningCommand.class)))})
    public Flux<LongRunningCommand> H(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter commands for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @RequestParam(name="interval", required=false, defaultValue="1000") @Schema(description="Minimum duration in milliseconds to consider a command as long-running", defaultValue="1000") int n) {
        void a2;
        CommandsRestControllerV2 commandsRestControllerV2 = object;
        Object object = string;
        CommandsRestControllerV2 activeContext = commandsRestControllerV2;
        long l2 = System.currentTimeMillis() - (long)a2;
        if (Objects.equals(object, e)) {
            return Flux.fromIterable(() -> {
                CommandsRestControllerV2 a2;
                return a2.G.entrySet().iterator();
            }).filter(a3 -> {
                if (((CommandInformation)a3.getValue()).H() < l2) {
                    return true;
                }
                return false;
            }).map(entry -> {
                Map.Entry a2 = entry;
                CommandsRestControllerV2 a3 = this;
                return new LongRunningCommand((String)a2.getKey(), (CommandInformation)a2.getValue(), a3.i);
            });
        }
        return Flux.fromStream(activeContext.G.getMessagesForContext((String)object).filter(a3 -> {
            if (a3.H() < l2) {
                return true;
            }
            return false;
        }).map(commandInformation -> {
            CommandsRestControllerV2 a2 = commandInformation;
            CommandsRestControllerV2 a3 = this;
            return new LongRunningCommand(a2.F(), (CommandInformation)a2, a3.i);
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean E(Set set, String string, Timer timer) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = timer;
        CommandsRestControllerV2 a5 = this;
        return a5.H((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"}, path={"metrics"})
    @Operation(summary="Get command metrics summary", description="Retrieves summarized metrics for command processing including average duration, count, errors, and active commands")
    @ApiResponse(responseCode="200", description="Command metrics summary retrieved successfully", content={@Content(schema=@Schema(implementation=CommandMetrics.class))})
    public CommandMetrics H(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter metrics for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @Parameter(hidden=true) Principal principal) {
        void activeContext;
        Set a2;
        CommandsRestControllerV2 commandsRestControllerV2;
        CommandsRestControllerV2 commandsRestControllerV22 = commandsRestControllerV2 = atomicLong;
        a2 = commandsRestControllerV22.L.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)((Object)a2)));
        AtomicInteger atomicInteger = new AtomicInteger();
        commandsRestControllerV22.a.find(BaseMetricName.V.metric()).gauges().stream().filter(arg_0 -> commandsRestControllerV2.H(a2, (String)activeContext, arg_0)).forEach(gauge -> {
            AtomicInteger a2 = gauge;
            AtomicInteger a3 = atomicInteger;
            a3.addAndGet((int)a2.value());
        });
        AtomicInteger atomicInteger2 = new AtomicInteger();
        commandsRestControllerV2.a.find(BaseMetricName.ja.metric()).counters().stream().filter(arg_0 -> commandsRestControllerV2.H(a2, (String)activeContext, arg_0)).forEach(counter -> {
            AtomicInteger a2 = counter;
            AtomicInteger a3 = atomicInteger2;
            a3.addAndGet((int)a2.count());
        });
        AtomicDouble atomicDouble = new AtomicDouble();
        AtomicLong atomicLong = new AtomicLong();
        commandsRestControllerV2.a.find(BaseMetricName.d.metric()).timers().stream().filter(arg_0 -> commandsRestControllerV2.H(a2, (String)activeContext, arg_0)).forEach(timer -> {
            void a2;
            AtomicDouble a3 = timer;
            AtomicDouble a4 = atomicDouble;
            a4.addAndGet(a3.totalTime(TimeUnit.MILLISECONDS));
            a2.addAndGet(a3.count());
        });
        double d2 = atomicLong.get() == 0L ? 0.0 : atomicDouble.get() / (double)atomicLong.get();
        return new CommandMetrics(d2, atomicLong.get(), atomicInteger2.get(), atomicInteger.get());
    }

    private static /* synthetic */ boolean H(String string, CommandInformation commandInformation) {
        String a2 = commandInformation;
        String a3 = string;
        return a2.F().equals(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(Meter meter, Set<String> set, String string) {
        void a2;
        void a3;
        Object a4 = meter;
        CommandsRestControllerV2 a5 = this;
        a4 = a4.getId().getTag("context");
        return a5.H((String)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(String string, Set<String> set, String string2) {
        void a2;
        void a3;
        String a4 = string2;
        CommandsRestControllerV2 a5 = this;
        if (a3.contains(a2) && (a4.equals(e) || a4.equals(a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"})
    @Operation(summary="List command metrics", description="Retrieves metrics about command processing across contexts or for a specific context")
    @ApiResponse(responseCode="200", description="Command metrics retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CounterMetric.class)))})
    public Flux<CounterMetric> H(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter metrics for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @Parameter(hidden=true) Principal principal) {
        void activeContext;
        CommandsRestControllerV2 a2;
        CommandsRestControllerV2 commandsRestControllerV2 = object;
        Object object = principal;
        CommandsRestControllerV2 commandsRestControllerV22 = a2 = commandsRestControllerV2;
        object = commandsRestControllerV22.L.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)object));
        return Flux.fromStream(commandsRestControllerV22.a.find(B.metric()).timers().stream().filter(arg_0 -> a2.E((Set)object, (String)activeContext, arg_0))).map(timer -> {
            CommandsRestControllerV2 a2 = timer;
            CommandsRestControllerV2 a3 = this;
            return new CounterMetric((Timer)a2, a3.i);
        }).mergeWith((Publisher)Flux.fromIterable((Iterable)a2.h.getAll(B.metric(), Tags.empty())).filter(arg_0 -> a2.H((Set)object, (String)activeContext, arg_0)).map(axonServerMetric -> {
            CommandsRestControllerV2 a2 = axonServerMetric;
            CommandsRestControllerV2 a3 = this;
            return new CounterMetric((AxonServerMetric)a2, a3.i);
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String H(Principal principal, CommandInformation commandInformation) {
        void a2;
        Object a3 = commandInformation;
        CommandsRestControllerV2 a4 = this;
        CommandsRestControllerV2 commandsRestControllerV2 = a3;
        a3 = commandsRestControllerV2.F();
        commandsRestControllerV2.H().accept(a4.H((String)a3, ErrorCode.OTHER, "Cancelled manually by " + a2.getName()));
        return a3;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(Set set, String string, Counter counter) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = counter;
        CommandsRestControllerV2 a5 = this;
        return a5.H((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"}, path={"cancel"})
    @Operation(summary="Cancel a running command", description="Cancels a command that is currently being processed")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Command successfully cancelled", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Command not found or not accessible")})
    public Optional<String> H(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context where the command is running. Use '_all_' to search in all contexts.", defaultValue="_all_") String string, @RequestParam(name="commandId") @Schema(description="Identifier of the command to cancel", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal) {
        void a2;
        void activeContext;
        CommandsRestControllerV2 commandsRestControllerV2 = object;
        Object object = string2;
        CommandsRestControllerV2 commandId = commandsRestControllerV2;
        A.info(MergedProcessorLoadBalancingService.H((Object)"\u0003\u0003.\u0001%\u000e`\u0001/\u000f-\u0003.\u0006`\u0019=B)\f`\u0001/\f4\u00078\u0016`\u0019="), object, (Object)activeContext);
        Set set = commandId.L.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)a2));
        if (Objects.equals(activeContext, e)) {
            return Optional.of((CommandInformation)commandId.G.remove((String)object)).map(commandInformation -> {
                Object a2 = commandInformation;
                CommandsRestControllerV2 a3 = this;
                CommandsRestControllerV2 commandsRestControllerV2 = a2;
                a2 = commandsRestControllerV2.F();
                commandsRestControllerV2.H().accept(a3.H((String)a2, ErrorCode.OTHER, MeterFactory.H((Object)"\u0016I;K0D9M1\b8I;]4D9QuJ,\b [0Z")));
                return a2;
            });
        }
        if (!set.contains(activeContext)) {
            return Optional.empty();
        }
        return commandId.G.getMessagesForContext((String)activeContext).filter(arg_0 -> CommandsRestControllerV2.H((String)object, arg_0)).findFirst().map(arg_0 -> commandId.H((String)object, arg_0)).map(arg_0 -> commandId.H((Principal)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(Set set, String string, Timer timer) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = timer;
        CommandsRestControllerV2 a5 = this;
        return a5.H((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(Set set, String string, Gauge gauge) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = gauge;
        CommandsRestControllerV2 a5 = this;
        return a5.H((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(Set set, String string, AxonServerMetric axonServerMetric) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = axonServerMetric;
        CommandsRestControllerV2 a5 = this;
        return a5.H(a4.tag("context"), (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public CommandsRestControllerV2(MeterRegistry meterRegistry, MetricCollector metricCollector, VisibleContexts visibleContexts, PlatformClientComponents platformClientComponents, EnterpriseCommandCache enterpriseCommandCache) {
        CommandsRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        CommandsRestControllerV2 a7;
        CommandsRestControllerV2 commandsRestControllerV2 = commandsRestControllerV22;
        CommandsRestControllerV2 commandsRestControllerV22 = enterpriseCommandCache;
        CommandsRestControllerV2 commandsRestControllerV23 = a7 = commandsRestControllerV2;
        CommandsRestControllerV2 commandsRestControllerV24 = a7;
        a7.a = a6;
        commandsRestControllerV24.h = a5;
        commandsRestControllerV24.L = a4;
        commandsRestControllerV23.i = a3;
        commandsRestControllerV23.G = a2;
    }

    private /* synthetic */ CommandInformation H(String string, CommandInformation commandInformation) {
        Object a2 = string;
        CommandsRestControllerV2 a3 = this;
        return (CommandInformation)a3.G.remove((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ SerializedCommandResponse H(String string, ErrorCode errorCode, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        CommandsRestControllerV2 a5 = this;
        return new SerializedCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier((String)a3).setErrorCode(a2.getCode()).setErrorMessage(ErrorMessageFactory.H((String)a4)).build());
    }
}

