/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.admin.application.api.ClientApplication;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.CommandHandler;
import io.axoniq.axonserver.configuration.runtime.CommandHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminCommandHandlerLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.RoleRestController;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Command Handlers", description="Operations to manage command handlers for integration endpoints")
public class IntegrationCommandHandlerControllerV2 {
    private final CommandHandlers e;
    private static final Integer A = 100;
    private final RaftGroupServiceFactory h;
    private final ObjectMapper L;
    private static final Logger G = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints/{endpoint}/commandHandlers"})
    @Operation(summary="Register a command handler", description="Register a new command handler for a specific endpoint. Command handlers process commands sent to the endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Command handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> H(@RequestBody @Schema(description="Command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", requiredMode=Schema.RequiredMode.REQUIRED, example="default") String string2) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.H((String)endpoint);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.E((String)integrationCommandHandlerControllerV22.name(), (String)ClientApplication.H((Object)"\f!/%"));
            ValidationUtils.H((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)RoleRestController.H((Object)"&\n%\u000e"));
            ValidationUtils.H((String)integrationCommandHandlerControllerV22.commandUrl(), (int)2000, (String)ClientApplication.H((Object)"!//-#.&\u00150,"));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, RoleRestController.H((Object)"''\n,K.\n+\u001f'\u0019h\u0006=\u0018<K*\u000eh[h\u0004:K$\n:\f-\u0019"));
            }
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(ClientApplication.H((Object)"\u001b9=\u001f`\u0010%35'36`6/b2''+36%0`!//-#.&`*!,$.%0`9=b),`'.&0-),4b;?n"), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), A, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.L.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.h.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.H((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationCommandHandlerControllerV2(ObjectMapper objectMapper, CommandHandlers commandHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationCommandHandlerControllerV2 a4;
        IntegrationCommandHandlerControllerV2 a5 = raftGroupServiceFactory;
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = a4 = this;
        a4.L = a3;
        integrationCommandHandlerControllerV2.e = a2;
        integrationCommandHandlerControllerV2.h = a5;
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Update a command handler", description="Update an existing command handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> H(@RequestBody @Schema(description="Updated command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.H((String)endpoint);
            ValidationUtils.H((String)handlerId);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.E((String)integrationCommandHandlerControllerV22.name(), (String)RoleRestController.H((Object)"&\n%\u000e"));
            ValidationUtils.H((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)ClientApplication.H((Object)",!/%"));
            ValidationUtils.H((String)object.commandUrl(), (int)2000, (String)RoleRestController.H((Object)"+\u0004%\u0006)\u0005,>:\u0007"));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, ClientApplication.H((Object)"\f-!&`$!!4-2b-736` %bpb/0`.!0''2"));
            }
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(RoleRestController.H((Object)"03\u0016\u0015K\u001a\u000e9\u001e-\u0018<K<\u0004h\u001e8\u000f)\u001f-K+\u0004%\u0006)\u0005,K \n&\u000f$\u000e:K3\u0016h\u0002&K-\u0005,\u001b'\u0002&\u001fh\u00105E"), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), A, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.L.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.h.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.H((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)principal2));
        }
    }

    private static /* synthetic */ ResponseEntity H(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ResponseEntity.created((URI)URIUtils.H((StringBuffer)a3.getRequestURL(), (String)a2.getId())).body((Object)new IntegrationAPI.Id(a2.getId()));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Delete a command handler", description="Remove a command handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Deletion request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> H(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = principal;
        IntegrationCommandHandlerControllerV2 principal2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.H((String)endpoint);
            ValidationUtils.H((String)handlerId);
            object = (Principal)ObjectUtils.H((Object)object, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(RoleRestController.H((Object)"03\u0016\u0015K\u001a\u000e9\u001e-\u0018<K<\u0004h\u000f-\u0007-\u001f-K+\u0004%\u0006)\u0005,K \n&\u000f$\u000e:K3\u0016h\u0002&K-\u0005,\u001b'\u0002&\u001fh\u00105E"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.h.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.E((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)this2));
        }
    }

    private static /* synthetic */ ResponseEntity E(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.H((HttpServletRequest)a3);
    }

    private static /* synthetic */ ResponseEntity H(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.H((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.CommandHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> H(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) @RequestParam(value="context") String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = string2;
        IntegrationCommandHandlerControllerV2 handlerId = integrationCommandHandlerControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.H((String)endpoint);
            ValidationUtils.H((String)object);
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(ClientApplication.H((Object)"\u0019;?\u001db\u0012'17%14b4-`%%6`!//-#.&`*!,$.%0`9=b),`'.&0-),4b;?n"), objectArray);
            }
            if (!(object = (CommandHandler)handlerId.e.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, ClientApplication.H((Object)"\b#.&,'2b.-4b&-5,$")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, RoleRestController.H((Object)"#)\u0005,\u0007-\u0019h\u0005'\u001fh\r'\u001e&\u000fh\u0002&K-\u0005,\u001b'\u0002&\u001f"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, ClientApplication.H((Object)"\n!,$.%0`,/6`$/7.&`+.b#-.6%:4"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.CommandHandler(object.getName(), Integer.valueOf(object.getLoadFactor()), object.getCommandUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.H((Throwable)principal2);
        }
    }
}

