/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.processor.balancing.strategy.AdminProcessorLoadBalancingService;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.admin.AdminEndpoint;
import io.axoniq.axonserver.configuration.admin.AdminEndpoints;
import io.axoniq.axonserver.configuration.runtime.Endpoint;
import io.axoniq.axonserver.configuration.runtime.Endpoints;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.EndpointLogMessage;
import io.axoniq.axonserver.integration.EndpointFactory;
import io.axoniq.axonserver.integration.WrappingTypes;
import io.axoniq.axonserver.integration.logconsumer.AdminEndpointLogConsumer;
import io.axoniq.axonserver.integration.logconsumer.AdminPatchEndpointLogConsumer;
import io.axoniq.axonserver.localstorage.query.AggregateIdExtractor;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.MapCodec;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Endpoints", description="Operations for managing integration endpoints")
public class IntegrationEndpointRestControllerV2 {
    private final EndpointFactory i;
    private final VisibleContexts a;
    private final Endpoints B;
    private final RaftGroupServiceFactory e;
    private final ObjectMapper A;
    private final AdminEndpoints h;
    private final Map<UUID, Set<String>> L;
    private static final Logger G = AuditLog.getLogger();

    private /* synthetic */ void H(IntegrationAPI.Endpoint endpoint) {
        IntegrationEndpointRestControllerV2 a2 = endpoint;
        IntegrationEndpointRestControllerV2 a3 = this;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = a2;
        ValidationUtils.E((String)integrationEndpointRestControllerV2.name(), (String)AdminProcessorLoadBalancingService.H((Object)"\u0015\u001d\u0016\u0019"));
        ValidationUtils.E((String)integrationEndpointRestControllerV2.baseUrl(), (String)AggregateIdExtractor.H((Object)"\u0001+\u0010/68\u000f"));
        ValidationUtils.E((String)integrationEndpointRestControllerV2.type(), (String)"type");
        ValidationUtils.E((String)integrationEndpointRestControllerV2.wrappingType(), (String)AdminProcessorLoadBalancingService.H((Object)"\f\u000e\u001a\f\u000b\u0015\u0015\u001b/\u0005\u000b\u0019"));
        ValidationUtils.E((String)integrationEndpointRestControllerV2.contentType(), (String)AggregateIdExtractor.H((Object)"\u0000%\r>\u0006$\u0017\u001e\u001a:\u0006"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.type(), (String)"type", (Collection)a3.H());
        ValidationUtils.H((String)integrationEndpointRestControllerV2.wrappingType(), (String)AdminProcessorLoadBalancingService.H((Object)"\f\u000e\u001a\f\u000b\u0015\u0015\u001b/\u0005\u000b\u0019"), (Collection)a3.H());
        ValidationUtils.H((String)integrationEndpointRestControllerV2.contentType(), (String)AggregateIdExtractor.H((Object)"\u0000%\r>\u0006$\u0017\u001e\u001a:\u0006"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.name(), (int)200, (String)AdminProcessorLoadBalancingService.H((Object)"\u0015\u001d\u0016\u0019"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.baseUrl(), (int)2000, (String)AggregateIdExtractor.H((Object)"\u0001+\u0010/68\u000f"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.healthUrl(), (int)2000, (String)AdminProcessorLoadBalancingService.H((Object)"\u0014\u001e\u001d\u0017\b\u0013)\t\u0010"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.commandUrl(), (int)2000, (String)AggregateIdExtractor.H((Object)")\f'\u000e+\r.68\u000f"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.queryUrl(), (int)2000, (String)AdminProcessorLoadBalancingService.H((Object)"\n\t\u001e\u000e\u0002)\t\u0010"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.eventUrl(), (int)2000, (String)AggregateIdExtractor.H((Object)"/\u0015/\r>68\u000f"));
        ValidationUtils.H((String)integrationEndpointRestControllerV2.contentType(), (int)200, (String)AdminProcessorLoadBalancingService.H((Object)"\u001f\u0014\u0012\u000f\u0019\u0015\b/\u0005\u000b\u0019"));
        ValidationUtils.H((String)MapCodec.encode((Map)integrationEndpointRestControllerV2.metaData()), (int)4000, (String)"metaData");
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints"})
    @Operation(summary="Register a new endpoint", description="Creates a new integration endpoint with the provided configuration")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Endpoint successfully created"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> H(@RequestBody @Schema(description="Endpoint configuration details", implementation=IntegrationAPI.Endpoint.class) IntegrationAPI.Endpoint endpoint, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = endpoint;
        IntegrationEndpointRestControllerV2 endpoint2 = integrationEndpointRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            endpoint2.H((IntegrationAPI.Endpoint)object);
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                G.info(AdminProcessorLoadBalancingService.H((Object)"'\u0000\u0001&\\)\u0019\n\t\u001e\u000f\u000f\\\u000f\u0013[\u000e\u001e\u001b\u0012\u000f\u000f\u0019\t\\\u001e\u0012\u001f\f\u0014\u0015\u0015\b[\u0007\u0006R"), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object.name()));
            }
            IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpoint2;
            object = integrationEndpointRestControllerV22.A.writeValueAsString(object);
            object = EndpointLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationEndpointRestControllerV22.e.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.H((HttpServletRequest)request, (EndpointLogMessage)object, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)principal2));
        }
    }

    @EventListener
    public void H(TopologyEvents.EndpointDisconnected endpointDisconnected) {
        IntegrationEndpointRestControllerV2 a2 = endpointDisconnected;
        IntegrationEndpointRestControllerV2 a3 = this;
        a3.L.getOrDefault(a2.H(), Collections.emptySet()).remove(a2.G());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PatchMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Change endpoint active state", description="Activates or deactivates an integration endpoint. When deactivated, the endpoint will not process messages.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="State change request accepted"), @ApiResponse(responseCode="400", description="Invalid endpoint ID format"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> H(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="active") @Schema(description="Activation state: true to activate, false to deactivate") boolean bl, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        void var1_3;
        void this_2 = var1_3;
        IntegrationEndpointRestControllerV2 endpointId = this;
        try {
            void request;
            void a2;
            void active;
            Principal principal2;
            ValidationUtils.H((String)this_2);
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = active != false ? AggregateIdExtractor.H((Object)"8\u00069\u0016'\u0006") : AdminProcessorLoadBalancingService.H((Object)"\f\u001a\t\b\u0019");
                objectArray[2] = StringUtils.sanitize((String)this_2);
                G.info(AdminProcessorLoadBalancingService.H((Object)"'\u0000\u0001&\\)\u0019\n\t\u001e\u000f\u000f\\\u000f\u0013[\u0007\u0006\\\u001e\u0012\u001f\f\u0014\u0015\u0015\b[\u0007\u0006R"), objectArray);
            }
            EndpointLogMessage this_2 = EndpointLogMessage.newBuilder().setId((String)this_2).setData(String.valueOf((boolean)active)).setContext((String)a2).setAction(Action.UPDATE).build();
            return ((CompletableFuture)endpointId.e.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminPatchEndpointLogConsumer.class.getSimpleName(), this_2.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.E((HttpServletRequest)request, this_2, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (MessagingPlatformException principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)principal2));
        }
    }

    @GetMapping(value={"internal/raft/endpoints"})
    @Transactional(readOnly=true)
    @Operation(summary="List internal endpoints", description="Internal API to list all endpoints for Raft synchronization (not for public use)")
    @ApiResponse(responseCode="200", description="List of internal endpoints retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.EndpointOverview.class)))})
    public List<IntegrationAPI.EndpointOverview> E(@Parameter(hidden=true) Principal principal) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 a2 = integrationEndpointRestControllerV2;
        object = new PrincipalAuthentication((Principal)ObjectUtils.H((Object)object, (Object)GrpcContextAuthenticationProvider.h));
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = a2;
        object = integrationEndpointRestControllerV22.a.visibleContexts(false, (Authentication)object);
        return integrationEndpointRestControllerV22.B.findAll().stream().filter(arg_0 -> IntegrationEndpointRestControllerV2.H((Set)object, arg_0)).map(endpoint -> {
            IntegrationEndpointRestControllerV2 a2 = endpoint;
            IntegrationEndpointRestControllerV2 a3 = this;
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            LinkedList linkedList3 = new LinkedList();
            a2.getCommandHandlers().forEach(commandHandler -> {
                List a2 = commandHandler;
                List a3 = linkedList;
                a3.add(new IntegrationAPI.CommandHandlerOverview(a2.getId().toString(), a2.getName(), a2.getLoadFactor(), a2.getCommandUrl()));
            });
            a2.getEventHandlers().forEach(eventHandler -> {
                List a2 = eventHandler;
                List a3 = linkedList2;
                a3.add(new IntegrationAPI.EventHandlerOverview(a2.getId().toString(), a2.getName(), a2.getBatchSize(), a2.getFilter(), a2.getSequencingPolicy(), a2.getSequencingPolicyParameters(), a2.getEventUrl()));
            });
            a2.getQueryHandlers().forEach(queryHandler -> {
                List a2 = queryHandler;
                List a3 = linkedList3;
                a3.add(new IntegrationAPI.QueryHandlerOverview(a2.getId().toString(), a2.getName(), a2.getQueryUrl()));
            });
            return new IntegrationAPI.EndpointOverview(a2.getContext(), a2.getId().toString(), a2.getName(), a2.getType(), a2.getBaseUrl(), a2.getCommandUrl(), a2.getQueryUrl(), a2.getEventUrl(), a2.getHealthUrl(), a2.getWrappingType(), a2.getContentType(), a2.isActive(), a2.getMetaData(), linkedList, linkedList2, linkedList3, a3.L.getOrDefault(a2.getId(), Collections.emptySet()).size());
        }).toList();
    }

    private static /* synthetic */ boolean H(Set set, AdminEndpoint adminEndpoint) {
        Set a2 = adminEndpoint;
        Set a3 = set;
        return a3.contains(a2.getContext());
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Update an endpoint", description="Updates an existing integration endpoint with the provided configuration")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> H(@RequestBody @Schema(description="Updated endpoint configuration", implementation=IntegrationAPI.Endpoint.class) IntegrationAPI.Endpoint endpoint, @PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = endpoint;
        IntegrationEndpointRestControllerV2 endpoint2 = integrationEndpointRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpointId;
            ValidationUtils.H((String)endpointId);
            endpoint2.H((IntegrationAPI.Endpoint)object);
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                G.info(AggregateIdExtractor.H((Object)"81\u001e\u0017C\u0018\u0006;\u0016/\u0010>C>\fj\u0016:\u0007+\u0017/C/\r.\u0013%\n$\u0017j\u00187M"), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object.name()));
            }
            IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpoint2;
            object = integrationEndpointRestControllerV22.A.writeValueAsString(object);
            object = EndpointLogMessage.newBuilder().setId((String)endpointId).setData((String)object).setContext((String)a2).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationEndpointRestControllerV22.e.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.H((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)principal2));
        }
    }

    private static /* synthetic */ boolean H(Set set, Endpoint endpoint) {
        Set a2 = endpoint;
        Set a3 = set;
        return a3.contains(a2.getContext());
    }

    private static /* synthetic */ ResponseEntity E(HttpServletRequest httpServletRequest, EndpointLogMessage endpointLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = endpointLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.H((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationEndpointRestControllerV2(ObjectMapper objectMapper, RaftGroupServiceFactory raftGroupServiceFactory, AdminEndpoints adminEndpoints, Endpoints endpoints, VisibleContexts visibleContexts, EndpointFactory endpointFactory) {
        IntegrationEndpointRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        IntegrationEndpointRestControllerV2 a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = integrationEndpointRestControllerV22;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpointFactory;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV23 = a8 = integrationEndpointRestControllerV2;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV24 = a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV25 = a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV26 = a8;
        integrationEndpointRestControllerV26.L = new ConcurrentHashMap();
        integrationEndpointRestControllerV25.A = a7;
        integrationEndpointRestControllerV25.e = a6;
        integrationEndpointRestControllerV24.h = a5;
        integrationEndpointRestControllerV24.B = a4;
        integrationEndpointRestControllerV23.a = a3;
        integrationEndpointRestControllerV23.i = a2;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Delete an endpoint", description="Removes an integration endpoint and all its associated handlers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Endpoint successfully deleted"), @ApiResponse(responseCode="400", description="Invalid endpoint ID format"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> H(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 principal2 = integrationEndpointRestControllerV2;
        try {
            void a3;
            EndpointLogMessage endpointId;
            ValidationUtils.H((String)endpointId);
            object = (Principal)ObjectUtils.H((Object)object, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                G.info(AggregateIdExtractor.H((Object)"81\u001e\u0017C\u0018\u0006;\u0016/\u0010>C>\fj\u0007/\u000f/\u0017/C/\r.\u0013%\n$\u0017j\u00187M"), (Object)AuditLog.username((String)object.getName()), (Object)StringUtils.sanitize((String)endpointId));
            }
            endpointId = EndpointLogMessage.newBuilder().setId((String)endpointId).setContext((String)a3).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.e.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), endpointId.toByteArray()).thenApply(a2 -> ValidationUtils.H())).exceptionally(ValidationUtils::H);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)this2));
        }
    }

    private static /* synthetic */ ResponseEntity H(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.H((HttpServletRequest)a3);
    }

    @GetMapping(value={"v2/endpointTypes"})
    @Operation(summary="Get available endpoint types", description="Retrieves all available endpoint types that can be used when creating an integration endpoint")
    @ApiResponse(responseCode="200", description="List of endpoint types retrieved successfully", content={@Content(schema=@Schema(implementation=Set.class))})
    public Set<IntegrationAPI.EndpointType> E() {
        IntegrationEndpointRestControllerV2 a2;
        return a2.i.types();
    }

    private /* synthetic */ Set<String> H() {
        IntegrationEndpointRestControllerV2 a2;
        return a2.i.typeNames();
    }

    @EventListener
    public void H(TopologyEvents.EndpointConnected endpointConnected) {
        IntegrationEndpointRestControllerV2 a3 = endpointConnected;
        IntegrationEndpointRestControllerV2 a4 = this;
        a4.L.computeIfAbsent(a3.H(), a2 -> new CopyOnWriteArraySet()).add(a3.H());
    }

    private static /* synthetic */ ResponseEntity H(HttpServletRequest httpServletRequest, EndpointLogMessage endpointLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = endpointLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.H((HttpServletRequest)a3, (String)a2.getId());
    }

    @GetMapping(value={"v2/endpoints"})
    @Transactional(readOnly=true)
    @Operation(summary="List all endpoints", description="Retrieves all integration endpoints with their handlers and connection status")
    @ApiResponse(responseCode="200", description="List of endpoints retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.EndpointOverview.class)))})
    public List<IntegrationAPI.EndpointOverview> H(@Parameter(hidden=true) Principal principal) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 a2 = integrationEndpointRestControllerV2;
        object = new PrincipalAuthentication((Principal)ObjectUtils.H((Object)object, (Object)GrpcContextAuthenticationProvider.h));
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = a2;
        object = integrationEndpointRestControllerV22.a.visibleContexts(false, (Authentication)object);
        return integrationEndpointRestControllerV22.h.findAll().stream().filter(arg_0 -> IntegrationEndpointRestControllerV2.H((Set)object, arg_0)).map(adminEndpoint -> {
            IntegrationEndpointRestControllerV2 a3 = adminEndpoint;
            IntegrationEndpointRestControllerV2 a4 = this;
            return new IntegrationAPI.EndpointOverview(a3.getContext(), a3.getId().toString(), a3.getName(), a3.getType(), a3.getBaseUrl(), a3.getCommandUrl(), a3.getQueryUrl(), a3.getEventUrl(), a3.getHealthUrl(), a3.getWrappingType(), a3.getContentType(), a3.isActive(), a3.getMetaData(), a3.getCommandHandlers().stream().map(a2 -> new IntegrationAPI.CommandHandlerOverview(a2.getId().toString(), a2.getName(), a2.getLoadFactor(), a2.getCommandUrl())).toList(), a3.getEventHandlers().stream().map(a2 -> new IntegrationAPI.EventHandlerOverview(a2.getId().toString(), a2.getName(), a2.getBatchSize(), a2.getFilter(), a2.getSequencingPolicy(), a2.getSequencingPolicyParameters(), a2.getEventUrl())).toList(), a3.getQueryHandlers().stream().map(a2 -> new IntegrationAPI.QueryHandlerOverview(a2.getId().toString(), a2.getName(), a2.getQueryUrl())).toList(), a4.L.getOrDefault(a3.getId(), Collections.emptySet()).size());
        }).toList();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpointId}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.Endpoint.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> H(@PathVariable(value="endpointId") String string, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = string;
        IntegrationEndpointRestControllerV2 endpointId = integrationEndpointRestControllerV2;
        try {
            void a2;
            Principal principal2;
            ValidationUtils.H((String)object);
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                G.info(AggregateIdExtractor.H((Object)"\u0011\u00187>j1/\u0012?\u00069\u0017j\u0017%C/\r.\u0013%\n$\u0017j\u00187M"), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object));
            }
            if (!(object = (Endpoint)endpointId.B.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, AggregateIdExtractor.H((Object)"\u000f\r.\u0013%\n$\u0017j\r%\u0017j\u0005%\u0016$\u0007")))).getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, AdminProcessorLoadBalancingService.H((Object)"9\u0015\u0018\u000b\u0013\u0012\u0012\u000f\\\u0015\u0013\u000f\\\u001d\u0013\u000e\u0012\u001f\\\u0012\u0012[\u001f\u0014\u0012\u000f\u0019\u0003\b"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.Endpoint(object.getName(), object.getType(), object.getBaseUrl(), object.getCommandUrl(), object.getQueryUrl(), object.getEventUrl(), object.getHealthUrl(), object.getWrappingType(), object.getContentType(), object.getMetaData()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.H((Throwable)principal2);
        }
    }

    @GetMapping(value={"v2/wrappingTypes"})
    @Operation(summary="Get available wrapping types", description="Retrieves all available wrapping types that can be used when creating an integration endpoint")
    @ApiResponse(responseCode="200", description="List of wrapping types retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(type="string")))})
    public List<String> H() {
        return List.of(WrappingTypes.h.H(), WrappingTypes.G.H());
    }
}

