/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.QueryHandler;
import io.axoniq.axonserver.configuration.runtime.QueryHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminQueryHandlerLogConsumer;
import io.axoniq.axonserver.integration.rsocket.RsocketClients;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginConfigurationSerializer;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Query Handlers", description="Operations to manage query handlers for integration endpoints")
public class IntegrationQueryHandlerRestControllerV2 {
    private final ObjectMapper A;
    private final QueryHandlers h;
    private final RaftGroupServiceFactory L;
    private static final Logger G = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete a query handler", description="Remove a query handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query handler successfully deleted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @DeleteMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> H(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = principal;
        IntegrationQueryHandlerRestControllerV2 principal2 = integrationQueryHandlerRestControllerV2;
        try {
            void a3;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.H((String)endpoint);
            ValidationUtils.H((String)handlerId);
            object = (Principal)ObjectUtils.H((Object)object, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(RsocketClients.H((Object)"}U[s\u0006|C_SKUZ\u0006ZI\u000eBKJKRK\u0006_SKTW\u0006FG@BBC\\\u0006U[\u000eO@\u0006KHJVAO@R\u000e]S\b"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a3).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.L.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(a2 -> ValidationUtils.H())).exceptionally(ValidationUtils::H);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Update a query handler", description="Update an existing query handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PutMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> H(@RequestBody @Schema(description="Updated query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.H((String)endpoint);
            ValidationUtils.H((String)handlerId);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.E((String)integrationQueryHandlerRestControllerV22.name(), (String)RsocketClients.H((Object)"@GCC"));
            ValidationUtils.H((String)object.name(), (int)200, (String)PluginConfigurationSerializer.H((Object)"iujq"));
            ValidationUtils.H((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)RsocketClients.H((Object)"_SKTWs\\J"));
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(PluginConfigurationSerializer.H((Object)"O|iZ4Uqvabgs4s{'awpf`b4vabf~4ouipkqu4|i'}i4bzcdh}i`'oz:"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.A.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.L.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.H((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Register a query handler", description="Register a new query handler for a specific endpoint to handle incoming query requests")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Query handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PostMapping(value={"v2/endpoints/{endpoint}/queryHandlers"})
    public CompletableFuture<ResponseEntity<Object>> H(@RequestBody @Schema(description="Query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.H((String)endpoint);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.E((String)integrationQueryHandlerRestControllerV22.name(), (String)RsocketClients.H((Object)"@GCC"));
            ValidationUtils.H((String)integrationQueryHandlerRestControllerV22.name(), (int)200, (String)PluginConfigurationSerializer.H((Object)"iujq"));
            ValidationUtils.H((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)RsocketClients.H((Object)"_SKTWs\\J"));
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(PluginConfigurationSerializer.H((Object)"O|iZ4Uqvabgs4s{'fbsngsqu4vabf~4ouipkqu4|i'}i4bzcdh}i`'oz:"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.A.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.L.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.H((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::H);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.H((Throwable)principal2));
        }
    }

    private static /* synthetic */ ResponseEntity H(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.H((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.QueryHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> H(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = string2;
        IntegrationQueryHandlerRestControllerV2 handlerId = integrationQueryHandlerRestControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.H((String)endpoint);
            ValidationUtils.H((String)object);
            principal2 = (Principal)ObjectUtils.H((Object)principal2, (Object)GrpcContextAuthenticationProvider.h);
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                G.info(PluginConfigurationSerializer.H((Object)"\\ozI'Fberqt`'`h4`qs4vabf~4ouipkqu4|i'}i4bzcdh}i`'oz:"), objectArray);
            }
            if (!(object = (QueryHandler)handlerId.h.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, RsocketClients.H((Object)"nOHJJKT\u000eHAR\u000e@AS@B")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, RsocketClients.H((Object)"nOHJJKT\u000eHAR\u000e@AS@B\u000eO@\u0006KHJVAO@R"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, PluginConfigurationSerializer.H((Object)"Ouipkqu4i{s4a{rzc4nz'whzsq\u007f`"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.QueryHandler(object.getName(), object.getQueryUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.H((Throwable)principal2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationQueryHandlerRestControllerV2(ObjectMapper objectMapper, QueryHandlers queryHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationQueryHandlerRestControllerV2 a4;
        IntegrationQueryHandlerRestControllerV2 a5 = raftGroupServiceFactory;
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = a4 = this;
        a4.A = a3;
        integrationQueryHandlerRestControllerV2.h = a2;
        integrationQueryHandlerRestControllerV2.L = a5;
    }

    private static /* synthetic */ ResponseEntity H(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.H((HttpServletRequest)a3, (String)a2.getId());
    }
}

