/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import io.axoniq.axonserver.util.TimeLimitedCache;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private static final Logger h = AuditLog.getLogger();
    private final Sinks.Many<SimpleUpdate> L;
    private final Logger G = LoggerFactory.getLogger(ClusterUpdatesService.class);

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated replicationGroupCreated) {
        ClusterUpdatesService a2 = replicationGroupCreated;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.A, a2.replicationGroup(), SimpleUpdateState.G);
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin contextUnregisteredInAdmin) {
        ClusterUpdatesService a2 = contextUnregisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.h, a2.context(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected axonServerInstanceConnected) {
        ClusterUpdatesService a2 = axonServerInstanceConnected;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.a, a2.getNodeName(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin contextRegisteredInAdmin) {
        ClusterUpdatesService a2 = contextRegisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.h, a2.context(), SimpleUpdateState.G);
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown leaderStepDown) {
        ClusterUpdatesService a2 = leaderStepDown;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.G, a2.replicationGroup(), SimpleUpdateState.h);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        ClusterUpdatesService a2 = applicationDisconnected;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.D, a2.g(), SimpleUpdateState.e);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ClusterUpdatesService a2 = leaderConfirmation;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.G, a2.replicationGroup(), SimpleUpdateState.h);
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication authentication) {
        ClusterUpdatesService clusterUpdatesService = clusterUpdatesService2;
        ClusterUpdatesService clusterUpdatesService2 = authentication;
        ClusterUpdatesService a2 = clusterUpdatesService;
        return a2.L.asFlux().publish().autoConnect().doFirst(() -> ClusterUpdatesService.H((Authentication)clusterUpdatesService2));
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        ClusterUpdatesService a2 = replicationGroupUpdated;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.A, a2.replicationGroup(), SimpleUpdateState.h);
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin contextUpdatedInAdmin) {
        ClusterUpdatesService a2 = contextUpdatedInAdmin;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.h, a2.H(), SimpleUpdateState.h);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected axonServerNodeConnected) {
        ClusterUpdatesService a2 = axonServerNodeConnected;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.L, a2.getNodeInfo().getHostName(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        ClusterUpdatesService a2 = replicationGroupDeleted;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.A, a2.replicationGroup(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ClusterUpdatesService a2 = becomeLeader;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.G, a2.replicationGroup(), SimpleUpdateState.h);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
        a2.L = Sinks.many().multicast().onBackpressureBuffer();
    }

    @EventListener
    public void on(TopologyEvents.EndpointDisconnected endpointDisconnected) {
        ClusterUpdatesService a2 = endpointDisconnected;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.e, a2.H().toString(), SimpleUpdateState.e);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(UpdateType updateType, String string, SimpleUpdateState simpleUpdateState) {
        void a2;
        void a3;
        ClusterUpdatesService a4 = simpleUpdateState;
        ClusterUpdatesService a5 = this;
        a5.L.emitNext((Object)new SimpleUpdate((UpdateType)a3, (String)a2 + ":" + a4.name()), (signalType, emitResult) -> {
            SignalType a2 = emitResult;
            SignalType a3 = signalType;
            if (a2 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected axonServerInstanceDisconnected) {
        ClusterUpdatesService a2 = axonServerInstanceDisconnected;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.a, a2.getNodeName(), SimpleUpdateState.e);
    }

    @EventListener
    public void on(TopologyEvents.EndpointConnected endpointConnected) {
        ClusterUpdatesService a2 = endpointConnected;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.e, a2.H().toString(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted axonServerNodeDeleted) {
        ClusterUpdatesService a2 = axonServerNodeDeleted;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.L, a2.node(), SimpleUpdateState.B);
    }

    private static /* synthetic */ void H(Authentication a2) {
        h.info(TimeLimitedCache.H((Object)"\u001dk;MfC3r5s4y$u\"02\u007ffs)~2u>dfe6t'd#ch"), (Object)AuditLog.username((String)a2.username()));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        ClusterUpdatesService a2 = applicationConnected;
        ClusterUpdatesService a3 = this;
        a3.H(UpdateType.D, a2.g(), SimpleUpdateState.A);
    }
}

