/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.serialisation;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.migration.source.BaseEvent;
import java.util.HashMap;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.Serializer;
import org.springframework.stereotype.Service;

@Service
public class EventSerializer {
    private final Serializer serializer;
    private final GrpcMetaDataConverter grpcMetaDataConverter;

    public EventSerializer(Serializer serializer) {
        this.serializer = serializer;
        this.grpcMetaDataConverter = new GrpcMetaDataConverter(this.serializer);
    }

    public void convertMetadata(byte[] metadataBytes, Event.Builder eventBuilder) {
        if (metadataBytes != null) {
            MetaData metaData = (MetaData)this.serializer.deserialize((org.axonframework.serialization.SerializedObject)new SerializedMetaData((Object)metadataBytes, byte[].class));
            HashMap metaDataValues = new HashMap();
            metaData.forEach((k, v) -> metaDataValues.put(k, this.grpcMetaDataConverter.convertToMetaDataValue(v)));
            eventBuilder.putAllMetaData(metaDataValues);
        }
    }

    public SerializedObject toPayload(BaseEvent entry) {
        SerializedObject.Builder builder = SerializedObject.newBuilder().setData(ByteString.copyFrom((byte[])entry.getPayload())).setType(entry.getPayloadType());
        if (entry.getPayloadRevision() != null) {
            builder.setRevision(entry.getPayloadRevision());
        }
        return builder.build();
    }
}

