/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration;

import io.axoniq.axonserver.migration.MigrationBaseProperties;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(value="axoniq.migration")
@Configuration
public class MigrationBaseProperties {
    private MigrationSource source;
    private int batchSize = 100;
    private int recentMillis = 10000;
    private boolean migrateSnapshots;
    private boolean migrateEvents;
    private boolean reorderSequenceNumbers;
    private List<String> ignoredEvents = Collections.emptyList();
    private boolean continuous = false;
    private int continuousTimeout = 100;
    private MigrationDestination destination;

    public boolean shouldRequestSequenceNumbers() {
        return !this.ignoredEvents.isEmpty() || this.reorderSequenceNumbers;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public int getContinuousTimeout() {
        return this.continuousTimeout;
    }

    public MigrationSource getSource() {
        return this.source;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getRecentMillis() {
        return this.recentMillis;
    }

    public boolean isMigrateSnapshots() {
        return this.migrateSnapshots;
    }

    public boolean isMigrateEvents() {
        return this.migrateEvents;
    }

    public boolean isReorderSequenceNumbers() {
        return this.reorderSequenceNumbers;
    }

    public List<String> getIgnoredEvents() {
        return this.ignoredEvents;
    }

    public MigrationDestination getDestination() {
        return this.destination;
    }

    public void setSource(MigrationSource source) {
        this.source = source;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRecentMillis(int recentMillis) {
        this.recentMillis = recentMillis;
    }

    public void setMigrateSnapshots(boolean migrateSnapshots) {
        this.migrateSnapshots = migrateSnapshots;
    }

    public void setMigrateEvents(boolean migrateEvents) {
        this.migrateEvents = migrateEvents;
    }

    public void setReorderSequenceNumbers(boolean reorderSequenceNumbers) {
        this.reorderSequenceNumbers = reorderSequenceNumbers;
    }

    public void setIgnoredEvents(List<String> ignoredEvents) {
        this.ignoredEvents = ignoredEvents;
    }

    public void setContinuous(boolean continuous) {
        this.continuous = continuous;
    }

    public void setContinuousTimeout(int continuousTimeout) {
        this.continuousTimeout = continuousTimeout;
    }

    public void setDestination(MigrationDestination destination) {
        this.destination = destination;
    }
}

