/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.source.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.boot.orm.jpa.hibernate.SpringImplicitNamingStrategy;
import org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(value={"axoniq.migration.source"}, havingValue="RDBMS")
@EnableJpaRepositories(basePackages={"io.axoniq.axonserver.migration.source.jpa"}, entityManagerFactoryRef="eventStoreEntityManagerFactory")
public class EventStoreDBConfiguration {
    @Bean
    @Primary
    @Qualifier(value="eventStoreEntityManagerFactory")
    public LocalContainerEntityManagerFactoryBean eventStoreEntityManagerFactory(EntityManagerFactoryBuilder builder, @Value(value="${axoniq.migration.disable-naming-strategy:false}") boolean disableNamingStrategy) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!disableNamingStrategy) {
            properties.put("hibernate.physical_naming_strategy", SpringPhysicalNamingStrategy.class.getName());
            properties.put("hibernate.implicit_naming_strategy", SpringImplicitNamingStrategy.class.getName());
        }
        return builder.dataSource(this.eventStoreDataSource()).packages(new String[]{"io.axoniq.axonserver.migration.source.jpa"}).persistenceUnit("eventstore").properties(properties).build();
    }

    @Bean
    @Primary
    @ConfigurationProperties(value="axoniq.datasource.eventstore")
    public DataSourceProperties eventStoreDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean(name={"eventStoreTransactionManager"})
    public PlatformTransactionManager barTransactionManager(@Qualifier(value="eventStoreEntityManagerFactory") EntityManagerFactory barEntityManagerFactory) {
        return new JpaTransactionManager(barEntityManagerFactory);
    }

    @Bean
    @Primary
    public DataSource eventStoreDataSource() {
        return this.eventStoreDataSourceProperties().initializeDataSourceBuilder().build();
    }
}

