/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.access.application.AccessControllerDB;
import io.axoniq.axonserver.access.user.ReplicationGroupUserController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final ClusterTagsCache K;
    private final Logger M;
    private final ApplicationEventPublisher a;
    private final AdminConfigurationFactory j;
    private final Limits h;
    private final CurrentNodeProvider D;
    private volatile boolean C;
    private final MessagingPlatformConfiguration I;
    private final AdminNodes l;
    private final RemoteConnections k;

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.B((ClusterNode)clusterController.D.get());
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.D.isAdmin();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.k.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.B(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.I.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.M.info(ReplicationGroupUserController.B((Object)"Y3t(c&-5bag.d/-6d5ean4\u007f3h/yac.i$-/l,h{-:p"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.I.getInternalHostname()) && a2.getGrpcInternalPort() == a3.I.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, AccessControllerDB.B((Object)"\t$$+%1j/%,$e))?6> 8e=,>-j6+(/e\"*91$$' j$$!j,$1/7$$&e:*81"));
        }
        ClusterNode clusterNode = a3.l.findById(a2.getNodeName()).orElseGet(() -> a3.B((NodeInfo)a2));
        if (!a3.k.contains(a2.getNodeName())) {
            a3.B((NodeInfo)a2);
        }
        return clusterNode;
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.k.activeConnections();
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.C;
    }

    private /* synthetic */ ClusterNode B(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.M.info(ReplicationGroupUserController.B((Object)"L%iac.i$-:p"), (Object)a3);
        a3 = clusterController.j.clusterNode((NodeInfo)a3);
        return clusterController.l.save((ClusterNode)a3);
    }

    private /* synthetic */ void B() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.l.findById(clusterController2.I.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.l.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.I.getName();
                a2 = String.format(ReplicationGroupUserController.B((Object)"\u0002x3\u007f$c5-/b%hac `$-)l2-\"e c&h%!ac$zac `$-d~o-\u0012y \u007f5-\u0000u.c\u0012h3{$\u007faz(y)-3h\"b7h3tak(a$#"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.j.clusterNode(clusterController3.I.getName(), clusterController.I.getFullyQualifiedHostname(), clusterController.I.getFullyQualifiedInternalHostname(), clusterController.I.getPort(), clusterController.I.getInternalPort(), clusterController.I.getHttpPort());
            clusterController3.l.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.I.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.I.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.I.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.I.getInternalPort();
            object = String.format(AccessControllerDB.B((Object)"\t087/+>e$*. m6j,$1/7$$&e\"*91$$' e5%7>eb`9\u007fo!ce\"$9e)-++- .ije$ =e<$&0/6j`9\u007fo!de\u00191+7>e\u000b=%+\u0019 83/7j2#1\"e8 )*< 8<j##)/k"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.B((NodeInfo)a3);
        clusterController.k.updateNodeInfo((NodeInfo)a3);
        clusterController.a.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a2;
        void a3;
        ClusterController clusterController = this;
        if (a3.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.k.get((String)a3);
        ClusterNode clusterNode = a2 = remoteConnection == null ? (ClusterNode)clusterController.l.findById((String)a3).orElse(null) : remoteConnection.getClusterNode();
        if (a2 == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a2);
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.k.get((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.M = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.I = messagingPlatformConfiguration2;
        clusterController6.l = clusterNodeRepository;
        clusterController5.j = adminConfigurationFactory2;
        clusterController5.K = clusterTagsCache2;
        clusterController4.a = applicationEventPublisher2;
        clusterController4.h = limits2;
        clusterController3.k = remoteConnections2;
        clusterController3.D = clusterController2;
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.l.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.K.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.l.deleteAllByNameNot(clusterController.getName());
        clusterController.k.sync();
    }

    private /* synthetic */ void B(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.I.getName())) {
            return;
        }
        a3.k.connect((NodeInfo)a2, true);
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.M.info(AccessControllerDB.B((Object)"\u0001/)/1/e$*. pe18"), a3);
        clusterController2.a.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.I.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.l.deleteAllByNameNot((String)a3);
            clusterController3.k.closeAll();
        } else {
            a2.l.findById((String)a3).ifPresent(arg_0 -> a2.B((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.a.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.k.sync();
    }

    public void stop() {
        a.C = false;
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.k.nodes();
    }

    public ClusterNode getNode(String string) {
        Object a2 = string;
        Object a3 = this;
        if (((String)a2).equals(a3.getName())) {
            return a3.getMe();
        }
        a2 = a3.l.findById((String)a2).orElseGet(() -> ((ClusterController)a3).B((String)a2));
        return a3.B((ClusterNode)a2);
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.k.disconnect((String)a2);
    }

    private /* synthetic */ ClusterNode B(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if ((a2 = a3.k.get((String)a2)) == null) {
            return null;
        }
        return a2.getClusterNode();
    }

    private /* synthetic */ void B(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.l.deleteById((String)a2);
    }

    public int getPhase() {
        return 50;
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.k.connections();
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.I.getName()) || a3.k.get(a2) != null && a3.k.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.a.publishEvent(a2);
    }

    private /* synthetic */ void B(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.k.contains((String)a2) || a3.I.getName().equals(a2)) {
            return;
        }
        a3.h.getMaxClusterSize().ifPresent(arg_0 -> a3.B((String)a2, arg_0));
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.B();
        a2.C = true;
    }
}

