/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.interceptor.InterceptorTimer;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final List<AxonServerInternalService> b;
    private final Logger e;
    private AdvancedTlsX509KeyManager.Closeable K;
    private static final DataSize M = DataSize.ofMegabytes((long)32L);
    private final LeaderElectionService a;
    private final MessagingPlatformConfiguration j;
    private boolean h;
    private final ExecutorService D;
    private final Supplier<ScheduledExecutorService> C;
    private final ApplicationEventPublisher I;
    private Server l;
    private final LogReplicationService k;

    public int getPhase() {
        return 50;
    }

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.e = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.j = a8;
        messagingClusterServer3.k = a6;
        messagingClusterServer3.a = a5;
        messagingClusterServer2.b = a4;
        messagingClusterServer2.C = a3;
        messagingClusterServer.I = a2;
        messagingClusterServer.D = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(InterceptorTimer.B((Object)"H\u0017^\b_\u001eYVN\u0003N\u0018^\u000fD\t\u0006")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = InterceptorTimer.B((Object)"\u0015D[x(g");
            if (messagingClusterServer.j.getSsl() != null && messagingClusterServer.j.getSsl().isEnabled()) {
                Object object = messagingClusterServer.j.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(ProcessorEventPublisher.B((Object)"w\u0019y\u000f\u007f\u00108\u0000n\u000ex\u0012s\u0013`\u0004dOe\u0012zOu\u0004d\u0015;\u0002~\u0000\u007f\u000f;\u0007\u007f\rsAx\u000ebAe\u0004b"));
                }
                Object object2 = messagingClusterServer.j.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(InterceptorTimer.B((Object)"\u001aS\u0014E\u0012ZUJ\u0003D\u0015X\u001eY\rN\t\u0005\bX\u0017\u0005\u000bY\u0012]\u001a_\u001e\u0006\u0010N\u0002\u0006\u001dB\u0017N[E\u0014_[X\u001e_"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.K = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.C.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.j.getInternalPort(), (ServerCredentials)object);
                string = ProcessorEventPublisher.B((Object)"E2ZAs\u000fw\u0003z\u0004r");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.j.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.j.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(M.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.j.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.j));
            messagingClusterServer.b.forEach(arg_0 -> MessagingClusterServer.B((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.a);
            a2.addService((BindableService)messagingClusterServer2.k);
            if (messagingClusterServer2.j.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.j.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.j.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.j.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.D);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(InterceptorTimer.B((Object)"H\u0017^\b_\u001eYVI\u0014X\b\u0006"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ProcessorEventPublisher.B((Object)"u\rc\u0012b\u0004dLa\u000ed\ns\u0013;"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(InterceptorTimer.B((Object)"H\u0017^\b_\u001eYVI\u0014X\b\u0006"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ProcessorEventPublisher.B((Object)"u\rc\u0012b\u0004dLa\u000ed\ns\u0013;"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.l = a2.build();
            messagingClusterServer.l.start();
            messagingClusterServer.e.info(InterceptorTimer.B((Object)"j\u0003D\u0015\u000b(N\t]\u001eY[h\u0017^\b_\u001eY[x\u001eY\rN\t\u000b\b_\u001aY\u000fN\u001f\u000b\u0014E[[\u0014Y\u000f\u0011[P\u0006\u000bV\u000b\u0000V"), (Object)messagingClusterServer.j.getInternalPort(), (Object)string);
            messagingClusterServer.I.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.h = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(ProcessorEventPublisher.B((Object)"E\u0015w\u0013b\bx\u00066 n\u000exAE\u0004d\u0017s\u00136\"z\u0014e\u0015s\u001362s\u0013`\u0004dAp\u0000\u007f\rs\u00056"), (Throwable)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void B(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.K != null) {
            messagingClusterServer.K.close();
        }
        messagingClusterServer.D.shutdown();
        try {
            if (!messagingClusterServer.l.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.e.debug(ProcessorEventPublisher.B((Object)"'y\u0013u\u0004p\u0014z\roAe\u0015y\u0011f\bx\u00066\"z\u0014e\u0015s\u001362s\u0013`\u0004d"));
                messagingClusterServer2.l.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.e.debug(InterceptorTimer.B((Object)"2E\u000fN\tY\u000e[\u000fN\u001f\u000b\u001f^\tB\u0015L[X\u0013^\u000fO\u0014\\\u0015\u000b\u0014M[B\u0015_\u001eY\u0015J\u0017\u000b:S\u0014E(N\t]\u001eY"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.h = false;
        messagingClusterServer.e.info(ProcessorEventPublisher.B((Object)" n\u000exAE\u0004d\u0017s\u00136\"z\u0014e\u0015s\u001362s\u0013`\u0004dAe\u0015y\u0011f\u0004r"));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.h;
    }
}

