/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.ContextReplicationIndexProvider;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.integration.WrappedEventHandler;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.PositionKeepingDataInputStream;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager,
ContextReplicationIndexProvider {
    private final ReplicationGroupController d;
    private final FileSystemMonitor c;
    private final Map<String, Long> b;
    private final Map<String, RaftGroup> e;
    private final GrpcRaftGroupFactory K;
    private final LifecycleController M;
    private final Logger a;
    private volatile boolean j;
    public static final String h = "replication-logs";
    private final ApplicationEventPublisher D;
    private final RaftGroupRepositoryManager C;
    private final RaftProperties I;
    private final AtomicBoolean l;
    private final MessagingPlatformConfiguration k;

    public long lastReplicationIndex(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.a.atInfo().addArgument(a2).addArgument(() -> a3.B((String)a2)).log(PositionKeepingDataInputStream.B((Object)"kRTG\u0007ABCKZDRSZH]\u0007ZIWBK\u0007UHA\u0007PH]SV_G\u0007HZ\u0013N@\u0007HZ"));
        return a3.getRaftNodeForContext((String)a2).B().localLogEntryStore().lastLogIndex();
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.a = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.e = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.b = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.l = new AtomicBoolean();
        grpcRaftController6.k = a9;
        grpcRaftController6.C = a8;
        grpcRaftController5.d = a7;
        grpcRaftController5.I = a6;
        grpcRaftController4.D = a5;
        grpcRaftController4.K = a4;
        grpcRaftController3.c = a3;
        grpcRaftController3.M = a2;
    }

    private /* synthetic */ Object B(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).B().localLogEntryStore().lastLogIndex();
    }

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.k.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(WrappedEventHandler.B((Object)"bOTLE\u0000OOU\u0000GIOD\u0001CTRSEOT\u0001NNDD\u0000HN\u0001NNDDS"));
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.l.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.j) {
            throw new IllegalStateException(WrappedEventHandler.B((Object)"sDRWES\u0000RT@RUUQ\u000fRHTTEOVN\u0001IO\u0000QRNGSERS"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.e.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.e;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.e.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.B((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, PositionKeepingDataInputStream.B((Object)"aBCKZDRSZH]\u0007TU\\RC\u0007WB_BGN\\I\u0013N]\u0007CU\\@AB@T"));
                }
                a3 = grpcRaftController.B((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.C.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.D.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.e.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.k.getName();
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.B((String)a3);
        }
        a4.e.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.d.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.D.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.c.unregisterPath(h);
        grpcRaftController.e.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.j = false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.c();
        long l2 = a2.B();
        if (v0.c() && !a3.B()) {
            grpcRaftController.D.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l2));
            return;
        }
        if (a3.B() && !a3.c()) {
            grpcRaftController.D.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).B(), l2));
            return;
        }
        if (a3.d()) {
            grpcRaftController.D.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.B())) {
            grpcRaftController.D.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.B(), l2));
        }
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().B() || a2.logEntryProcessor().B() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(PositionKeepingDataInputStream.B((Object)"zIGBAUFWG\u0007DOZKV\u0007DFZSZIT\u0007GH\u0013EVD\\JV\u0007_BRCVU"));
            }
        }
        return a2.localNode();
    }

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.e.get(a2);
    }

    public int getPhase() {
        return 100;
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.d.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.B((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.k.getFullyQualifiedInternalHostname()).setPort(a5.k.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.B((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.a.debug(WrappedEventHandler.B((Object)"sUAST\u0001FSOL\u0000HNHTsAGTfRNUQ\u0000Z]"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup B(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.e;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.a.info(PositionKeepingDataInputStream.B((Object)"HZ\t\u0007ZIZS\u0013UVW_NPFGN\\I\u0013@AHFW"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.e.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.K.create((String)a4, (String)a2);
            a2.localNode().c(arg_0 -> a3.B((RaftGroup)a2, arg_0));
            a3.e.put(a4, a2);
            return a2;
        }
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).F();
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.j) {
            throw new IllegalStateException(WrappedEventHandler.B((Object)"hNHTHAMI[AUINN\u0001OS\u0000RHTTEOVN\u0001IO\u0000QRNGSERS"));
        }
        if (!a3.e.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.k.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.e.get(a2)).localNode();
    }

    private /* synthetic */ boolean B(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.b.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.I.getMaxElectionTimeout();
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.C.contexts();
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.e.keySet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.B(a2.localNode(), (StateChanged)a3);
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.j;
    }

    private /* synthetic */ void B(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.b.put(a2, System.currentTimeMillis() + 2L * (long)a3.I.getMaxElectionTimeout());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.a.info(WrappedEventHandler.B((Object)"[\\\u001a\u0001rDPMIBAUINN\u0001GSOTP\u0001SUASTDD"), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.M.setCleanShutdown();
                grpcRaftController2.l.set(true);
                return;
            }
        } else {
            a3.a.warn(PositionKeepingDataInputStream.B((Object)"HZ\t\u0007aBCKZDRSZH]\u0007TU\\RC\u0007@SRUG\u0007UFZKVC"), (Object)a.groupId(), a2);
        }
    }

    private /* synthetic */ MessagingPlatformException B(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.k.getName() + ": Not a member of " + (String)a2);
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.I.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.B((File)a2);
        grpcRaftController2.c.registerPath(h, ((File)a2).toPath(), grpcRaftController.I.minFreeSpace(), grpcRaftController.I.warnFreeSpace());
        a2 = grpcRaftController2.C.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.B(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.j = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.a.info(WrappedEventHandler.B((Object)"Z]\u001b\u0000sEQLHC@THOO\u0000FRNUQ\u0000RT@RUIOG"), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.e.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.B((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.a.warn(PositionKeepingDataInputStream.B((Object)"\\N\u001d\u0013aRN_BW\u0007GH\u0013N]NGNRKZ]V\u0007ABCKZDRSZH]`AHFW"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.a.info(PositionKeepingDataInputStream.B((Object)"aBCKZDRSZH]\u0007TU\\RC\u0007PH]SAH_KVU\u0013UFI]N]@"));
        if (a2.isEmpty()) {
            grpcRaftController.l.set(true);
        }
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.e.keySet();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.j) {
            a2.e.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).B();
            });
        }
    }
}

