/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import io.axoniq.axonserver.localstorage.file.AggregateWithoutSnapshotException;
import io.axoniq.axonserver.localstorage.file.PositionKeepingDataInputStream;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.ClusterMetric;
import io.axoniq.axonserver.metric.MetricCollector;
import io.axoniq.axonserver.topology.Topology;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.ServerTransportFilter;
import io.grpc.Status;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ConnectedApplicationsFilter
extends ServerTransportFilter {
    private final ContextLeaderProvider j;
    private final MetricCollector h;
    private final AtomicInteger D;
    private final String C;
    private final Logger I;
    private final FeatureChecker l;
    private final Map<String, List<UUID>> k;

    @EventListener
    public void on(ClusterEvents.ContextLeaderStepDown contextLeaderStepDown) {
        ConnectedApplicationsFilter a2;
        ConnectedApplicationsFilter a3 = contextLeaderStepDown;
        ConnectedApplicationsFilter connectedApplicationsFilter = a2 = this;
        connectedApplicationsFilter.D.addAndGet(-connectedApplicationsFilter.k.getOrDefault(a3.context(), List.of()).size());
        a2.I.debug(AggregateWithoutSnapshotException.B((Object)"\u001cuGi\u0017x\u000ba\u0004i\u0013a\bf\u0014(\u0004g\tf\u0002k\u0013m\u0003(\u000bg\u0004i\u000bd\u001e"), (Object)a2.D);
    }

    /*
     * WARNING - void declaration
     */
    public Attributes transportReady(Attributes attributes) {
        void a2;
        ConnectedApplicationsFilter connectedApplicationsFilter = this;
        int a3 = (int)((ClusterMetric)connectedApplicationsFilter.h.apply((Object)BaseMetricName.ea.metric(), (Object)Tags.empty())).value();
        ConnectedApplicationsFilter connectedApplicationsFilter2 = connectedApplicationsFilter;
        int n = connectedApplicationsFilter2.D.incrementAndGet();
        connectedApplicationsFilter2.I.debug(AggregateWithoutSnapshotException.B((Object)"s\u001a(\u0006x\u0017d\u000ek\u0006|\u000eg\t{Gk\bf\tm\u0004|\u0002lGd\bk\u0006d\u000bqK(\u001cuGz\u0002e\b|\u0002d\u001e"), (Object)connectedApplicationsFilter.D, (Object)a3);
        if (a3 + n > connectedApplicationsFilter.l.maxConnections()) {
            connectedApplicationsFilter.I.warn(PositionKeepingDataInputStream.B((Object)"aBUR@BW\u0007PH]IVDGN\\I\u0013AAH^\u0007HZ\u001f\u0007GH\\\u0007^F]^\u0013\u000fHZ\u001a\u0007\\WVI\u0013D\\I]BPSZH]T"), a2.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), (Object)(a3 + n));
            throw Status.RESOURCE_EXHAUSTED.withDescription(AggregateWithoutSnapshotException.B((Object)"3g\b(\ni\tqGg\u0017m\t(\u0004g\tf\u0002k\u0013a\bf\u0014")).asRuntimeException();
        }
        return a2;
    }

    public void transportTerminated(Attributes attributes) {
        ConnectedApplicationsFilter a2 = attributes;
        ConnectedApplicationsFilter a3 = this;
        a3.D.decrementAndGet();
    }

    @EventListener
    public void on(TopologyEvents.EndpointDisconnected endpointDisconnected) {
        ConnectedApplicationsFilter a2 = endpointDisconnected;
        ConnectedApplicationsFilter a3 = this;
        if (a3.C.equals(a2.B())) {
            a3.k.getOrDefault(a2.c(), Collections.emptyList()).remove(a2.B());
            if (a3.j.isLeader(a2.c())) {
                a3.D.decrementAndGet();
            }
        }
        a3.I.debug(AggregateWithoutSnapshotException.B((Object)"\u001cuGi\u0017x\u000ba\u0004i\u0013a\bf\u0014(\u0004g\tf\u0002k\u0013m\u0003(\u000bg\u0004i\u000bd\u001e"), (Object)a3.D);
    }

    @EventListener
    public void on(ClusterEvents.BecomeContextLeader becomeContextLeader) {
        ConnectedApplicationsFilter a2;
        ConnectedApplicationsFilter a3 = becomeContextLeader;
        ConnectedApplicationsFilter connectedApplicationsFilter = a2 = this;
        connectedApplicationsFilter.D.addAndGet(connectedApplicationsFilter.k.getOrDefault(a3.context(), List.of()).size());
        a2.I.debug(PositionKeepingDataInputStream.B((Object)"\\N\u0007RWCKZDRSZH]T\u0013D\\I]BPSVC\u0013K\\DRK_^"), (Object)a2.D);
    }

    @EventListener
    public void on(TopologyEvents.EndpointConnected endpointConnected) {
        ConnectedApplicationsFilter a3 = endpointConnected;
        ConnectedApplicationsFilter a4 = this;
        if (a4.C.equals(a3.F())) {
            a4.k.computeIfAbsent(a3.c(), a2 -> new CopyOnWriteArrayList()).add(a3.B());
            if (a4.j.isLeader(a3.c())) {
                a4.D.incrementAndGet();
            }
        }
        a4.I.debug(PositionKeepingDataInputStream.B((Object)"\\N\u0007RWCKZDRSZH]T\u0013D\\I]BPSVC\u0013K\\DRK_^"), (Object)a4.D);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectedApplicationsFilter(MeterRegistry meterRegistry, MetricCollector metricCollector, ContextLeaderProvider contextLeaderProvider, Topology topology, FeatureChecker featureChecker) {
        void a2;
        void a3;
        ConnectedApplicationsFilter a4;
        void a5;
        void a6;
        ConnectedApplicationsFilter a7;
        ConnectedApplicationsFilter connectedApplicationsFilter = connectedApplicationsFilter2;
        ConnectedApplicationsFilter connectedApplicationsFilter2 = featureChecker;
        ConnectedApplicationsFilter connectedApplicationsFilter3 = a7 = connectedApplicationsFilter;
        ConnectedApplicationsFilter connectedApplicationsFilter4 = a7;
        ConnectedApplicationsFilter connectedApplicationsFilter5 = a7;
        a7.D = new AtomicInteger();
        ConnectedApplicationsFilter connectedApplicationsFilter6 = a7;
        connectedApplicationsFilter5.k = new ConcurrentHashMap();
        a7.I = AuditLog.getLogger();
        connectedApplicationsFilter4.h = a6;
        connectedApplicationsFilter4.j = a5;
        connectedApplicationsFilter3.l = a4;
        connectedApplicationsFilter3.C = a3.getName();
        Gauge.builder((String)BaseMetricName.ea.metric(), a7.D::get).description(BaseMetricName.ea.description()).register((MeterRegistry)a2);
    }

    public boolean allowNewConnection() {
        int a2;
        ConnectedApplicationsFilter connectedApplicationsFilter = this;
        int n = (int)((ClusterMetric)connectedApplicationsFilter.h.apply((Object)BaseMetricName.ea.metric(), (Object)Tags.empty())).value();
        if (n + (a2 = connectedApplicationsFilter.D.incrementAndGet()) < connectedApplicationsFilter.l.maxConnections()) {
            return true;
        }
        return false;
    }
}

