/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.localstorage.file.PositionKeepingDataInputStream;
import io.axoniq.axonserver.localstorage.query.AggregateIdExtractor;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"}, matchIfMissing=true)
public class HeartbeatMonitor {
    private final ApplicationEventPublisher j;
    private final long h;
    private final Map<ClientStreamIdentification, ClientInformation> D;
    private final Logger C;
    private final Publisher<PlatformOutboundInstruction> I;
    private final Map<ClientStreamIdentification, Instant> l;
    private final Clock k;

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:1000}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.I.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.D.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.D.get(a4);
            String string = clientInformation.k;
            String string2 = clientInformation.l;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.h;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.C.info(PositionKeepingDataInputStream.B((Object)"d_NVIG\u0007ZIRDGNENG^\u0013CVSVDGBW\u0007UHA\u0007^HAB\u0013S[F]\u0007HZ\u0013JZK_N@BPH]C@\t\u0013d_NVIG\u001d\u0013\\N\u000b\u0013KRTGfPSZQZSJ\u001d\u0013\\N\u000b\u0013SZJVHFS\t\u0007HZ\u001d\u0007"), objectArray);
            a5.j.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.I)));
        }
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.A(), a2.B());
        a3.l.remove(a2);
        a3.D.remove(a2);
        a3.C.debug(AggregateIdExtractor.B((Object)".n\u0012j]w\u0012t\u0014n\u0012h\u0014t\u001a:\u0015\u007f\u001ch\tx\u0018{\t:\u001bu\u000f:\u001ev\u0014\u007f\u0013n]a\u00004"), (Object)a2);
    }

    public static String B(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a2 = n - 1;
        char[] cArray = new char[n];
        int n2 = (3 ^ 5) << 4 ^ 3 << 1;
        int cfr_ignored_0 = (3 ^ 5) << 3 ^ (3 ^ 5);
        int n3 = a2;
        int n4 = 5 << 3 ^ (2 ^ 5);
        while (n3 >= 0) {
            int n5 = a2--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a2 < 0) break;
            int n6 = a2--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a2;
        }
        return new String(cArray);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.i(), a2.d());
        a3.D.put(clientStreamIdentification, new ClientInformation(a2.A(), a2.F(), a2.i()));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void B(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.C.debug(PositionKeepingDataInputStream.B((Object)"d[BPLZIT\u0007PH]IVDGBW\u0007PKZB]S@\u0007RUV\u0007@SZK_\u0007RKZQV\t\u001d\t"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.k).minus(heartbeatMonitor3.h, ChronoUnit.MILLIS);
        heartbeatMonitor3.l.forEach((arg_0, arg_1) -> heartbeatMonitor.B((Instant)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l2, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.C = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.D = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.l = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.C.trace(AggregateIdExtractor.B((Object)"5\u007f\u001ch\tX\u0018{\t:\u000f\u007f\u001e\u007f\u0014l\u0018~]|\u000fu\u0010:\u0006g"), (Object)a3);
            heartbeatMonitor.l.put(a3, Instant.now(a2.k));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.k = a5;
        heartbeatMonitor5.j = a4;
        heartbeatMonitor4.h = a3;
        heartbeatMonitor4.I = a2;
    }

    private static /* synthetic */ void B(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.B((BiConsumer)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l2) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.B((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }
}

