/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.integration.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.configuration.runtime.Endpoint;
import io.axoniq.axonserver.configuration.runtime.EventHandler;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.eventstore.PersistentStreamEvent;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.integration.EndpointMessageFactory;
import io.axoniq.axonserver.integration.EventPublisher;
import io.axoniq.axonserver.integration.PayloadUtils;
import io.axoniq.axonserver.integration.WrappingTypes;
import io.axoniq.axonserver.integration.config.IntegrationConfiguration;
import io.axoniq.axonserver.integration.http.HttpCustomHeaders;
import io.axoniq.axonserver.integration.http.HttpMetadata;
import io.axoniq.axonserver.streams.connection.StreamEvent;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class HttpEventPublisher
implements EventPublisher {
    private final ObjectMapper M;
    private static final Logger a = LoggerFactory.getLogger(HttpEventPublisher.class);
    private final Endpoint j;
    private final String h;
    private final AtomicBoolean D;
    private final IntegrationConfiguration C;
    private final String I;
    private final WebClient l;
    private final MediaType k;

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<Void> publish(List<StreamEvent> list) {
        void a2;
        HttpEventPublisher httpEventPublisher = this;
        if (httpEventPublisher.D.get()) {
            a.debug(HeartbeatMonitor.B((Object)"T\u001b\u0015F{\u0014V\u000fA\u0001\u000f\u0012@F_\u0013M\nF\u0015GF[\t\u000f\u0007\u000f\u0005C\t\\\u0003KF_\u0013M\nF\u0015G\u0003]"), (Object)httpEventPublisher.h);
            return CompletableFuture.failedFuture(new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_CLOSED, RaftConfigServiceFactory.B((Object)"(j\u001as\u0011l\u0010z\n?\u0019s\nz\u0019{\u0001?\u001bs\u0017l\u001d{")));
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.size();
        objectArray[1] = httpEventPublisher.h;
        objectArray[2] = httpEventPublisher.I;
        a.trace(HeartbeatMonitor.B((Object)"k\u000f\\\u0016N\u0012L\u000e\u000f\u001dRFJ\u0010J\b[\u0015\u000f\u001dRF[\t\u000f\u001dR"), objectArray);
        try {
            HttpEventPublisher a3 = ((WebClient.RequestBodySpec)httpEventPublisher.l.post().uri(httpEventPublisher.I, new Object[0])).contentType(httpEventPublisher.B()).body((Publisher)Mono.just((Object)httpEventPublisher.B((List)a2)), byte[].class);
            httpEventPublisher.B((WebClient.RequestHeadersSpec)a3, ((StreamEvent)a2.get(0)).event());
            Mono.defer(() -> httpEventPublisher.B((WebClient.RequestHeadersSpec)a3)).retryWhen((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(httpEventPublisher.C.getEventRetryBackoff())).filter(throwable -> {
                Object a2 = throwable;
                HttpEventPublisher a3 = this;
                if (!a3.D.get()) {
                    return true;
                }
                return false;
            }).maxBackoff(Duration.ofSeconds(30L)).doBeforeRetry(retrySignal -> {
                HttpEventPublisher a2 = retrySignal;
                HttpEventPublisher a3 = this;
                a.debug(HeartbeatMonitor.B((Object)"\u001dRF\u0002F}\u0003[\u0014V\\\u000f\u001dR"), (Object)a3.I, (Object)a2.failure().getMessage());
            })).subscribe(clientResponse -> {
                CompletableFuture a2 = clientResponse;
                CompletableFuture a3 = completableFuture;
                a2.releaseBody().subscribe();
                a3.complete(null);
            }, throwable -> {
                void a2;
                Object a3 = throwable;
                HttpEventPublisher a4 = this;
                a2.completeExceptionally(a4.B((Throwable)a3));
            });
            return completableFuture;
        }
        catch (Exception a3) {
            CompletableFuture<Void> completableFuture2 = completableFuture;
            completableFuture2.completeExceptionally(new MessagingPlatformException(ErrorCode.OTHER, a3.getMessage(), (Throwable)a3));
            return completableFuture2;
        }
    }

    @NotNull
    private /* synthetic */ MediaType B() {
        HttpEventPublisher a2;
        if (WrappingTypes.k.B().equals(a2.j.getWrappingType())) {
            return MediaType.APPLICATION_JSON;
        }
        return a2.k;
    }

    private /* synthetic */ Mono B(WebClient.RequestHeadersSpec requestHeadersSpec) {
        HttpEventPublisher a3 = requestHeadersSpec;
        HttpEventPublisher a4 = this;
        if (a4.D.get()) {
            return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_CLOSED, RaftConfigServiceFactory.B((Object)"(j\u001as\u0011l\u0010z\n?\u0019s\nz\u0019{\u0001?\u001bs\u0017l\u001d{")));
        }
        return a3.exchangeToMono(a2 -> {
            if (a2.statusCode().is2xxSuccessful()) {
                return Mono.just((Object)a2);
            }
            return Mono.error((Throwable)new IllegalStateException(a2.statusCode().toString()));
        }).doOnSubscribe(subscription -> {
            HttpEventPublisher a2 = subscription;
            HttpEventPublisher a3 = this;
            a.debug(HeartbeatMonitor.B((Object)"|\u0003A\u0002F\bHFJ\u0010J\b[F[\t\u000f\u001dR"), (Object)a3.I);
        }).doOnSuccess(clientResponse -> {
            HttpEventPublisher a2 = clientResponse;
            HttpEventPublisher a3 = this;
            a.debug(RaftConfigServiceFactory.B((Object)"=i\u001dq\f?\u000bz\u0016kXk\u0017?\u0003b"), (Object)a3.I);
        }).doOnError(throwable -> {
            Throwable a2 = throwable;
            HttpEventPublisher a3 = this;
            a.warn(HeartbeatMonitor.B((Object)"j\u0014]\t]F\\\u0003A\u0002F\bHFJ\u0010J\b[F[\t\u000f\u001dR\\\u000f\u001dR"), (Object)a3.I, (Object)a2.getMessage());
        });
    }

    /*
     * WARNING - void declaration
     */
    public HttpEventPublisher(Endpoint endpoint, EventHandler eventHandler, ObjectMapper objectMapper, IntegrationConfiguration integrationConfiguration, WebClient webClient) {
        void a2;
        void a3;
        void a4;
        void a5;
        HttpEventPublisher a6;
        HttpEventPublisher a7 = eventHandler;
        HttpEventPublisher httpEventPublisher = a6 = this;
        HttpEventPublisher httpEventPublisher2 = a6;
        HttpEventPublisher httpEventPublisher3 = a6;
        httpEventPublisher3.D = new AtomicBoolean();
        httpEventPublisher2.h = a7.getName();
        httpEventPublisher2.M = a5;
        a6.j = a4;
        a6.k = PayloadUtils.B((String)a6.j.getContentType());
        a6.I = a6.B(a7.getEventUrl());
        httpEventPublisher.C = a3;
        httpEventPublisher.l = a2;
    }

    private /* synthetic */ String B() {
        HttpEventPublisher a2;
        return a2.j.getBaseUrl() + a2.j.getEventUrl();
    }

    public void close() {
        HttpEventPublisher a2;
        HttpEventPublisher httpEventPublisher = a2;
        a.debug(RaftConfigServiceFactory.B((Object)"d\u0005%XZ\u000ez\u0016kXo\r}\u0014v\u000bw\u001dmX|\u0014p\u000bz\u001c?U?\u0003b"), (Object)httpEventPublisher.h, (Object)httpEventPublisher.I);
        a2.D.set(true);
    }

    private /* synthetic */ byte[] B(List<StreamEvent> list) throws JsonProcessingException {
        Object a2 = list;
        HttpEventPublisher a3 = this;
        if (WrappingTypes.I.B().equals(a3.j.getWrappingType())) {
            return ((StreamEvent)a2.get(0)).event().event().getPayload().getData().toByteArray();
        }
        a2 = a2.stream().map(streamEvent -> {
            HttpEventPublisher a2 = streamEvent;
            HttpEventPublisher a3 = this;
            return EndpointMessageFactory.B((long)a2.event().token(), (Event)a2.event().event(), (MediaType)a3.k);
        }).toList();
        return a3.M.writeValueAsBytes(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(WebClient.RequestHeadersSpec<?> requestHeadersSpec, PersistentStreamEvent persistentStreamEvent) {
        void a2;
        HttpEventPublisher a3 = persistentStreamEvent;
        HttpEventPublisher a4 = this;
        a4.j.getMetaData().forEach((arg_0, arg_1) -> HttpEventPublisher.B((WebClient.RequestHeadersSpec)a2, arg_0, arg_1));
        if (WrappingTypes.I.B().equals(a4.j.getWrappingType())) {
            if (!a3.event().getPayload().getType().isBlank()) {
                String[] stringArray = new String[1];
                stringArray[0] = a3.event().getPayload().getType();
                a2.header(HttpCustomHeaders.a.B(), stringArray);
                String[] stringArray2 = new String[1];
                stringArray2[0] = a3.event().getPayload().getType();
                a2.header(HttpCustomHeaders.l.B(), stringArray2);
            }
            if (!a3.event().getPayload().getRevision().isBlank()) {
                String[] stringArray = new String[1];
                stringArray[0] = a3.event().getPayload().getRevision();
                a2.header(HttpCustomHeaders.I.B(), stringArray);
            }
            String[] stringArray = new String[1];
            stringArray[0] = a3.event().getMessageIdentifier();
            a2.header(HttpCustomHeaders.J.B(), stringArray);
            String[] stringArray3 = new String[1];
            stringArray3[0] = OffsetDateTime.ofInstant(Instant.ofEpochMilli(a3.event().getTimestamp()), ZoneId.systemDefault()).toString();
            a2.header(HttpCustomHeaders.K.B(), stringArray3);
            String[] stringArray4 = new String[1];
            stringArray4[0] = "" + a3.token();
            a2.header(HttpCustomHeaders.D.B(), stringArray4);
            if (!a3.event().getAggregateIdentifier().isBlank()) {
                String[] stringArray5 = new String[1];
                stringArray5[0] = a3.event().getAggregateIdentifier();
                a2.header(HttpCustomHeaders.b.B(), stringArray5);
                String[] stringArray6 = new String[1];
                stringArray6[0] = a3.event().getAggregateType();
                a2.header(HttpCustomHeaders.C.B(), stringArray6);
                String[] stringArray7 = new String[1];
                stringArray7[0] = String.valueOf(a3.event().getAggregateSequenceNumber());
                a2.header(HttpCustomHeaders.j.B(), stringArray7);
            }
            if (a3.event().getMetaDataCount() > 0) {
                String[] stringArray8 = new String[1];
                stringArray8[0] = HttpMetadata.B((ObjectMapper)a4.M, (Map)a3.event().getMetaDataMap());
                a2.header(HttpCustomHeaders.d.B(), stringArray8);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void B(WebClient.RequestHeadersSpec requestHeadersSpec, String string, String string2) {
        void a2;
        Object a3 = string2;
        WebClient.RequestHeadersSpec a4 = requestHeadersSpec;
        String[] stringArray = new String[1];
        stringArray[0] = a3;
        a4.header((String)a2, stringArray);
    }

    private /* synthetic */ String B(String string) {
        String a2 = string;
        HttpEventPublisher a3 = this;
        if (a2 != null && !a2.isBlank()) {
            return a3.j.getBaseUrl() + (String)a2;
        }
        return a3.B().replace("{name}", a3.h).replace(RaftConfigServiceFactory.B((Object)"d\u001bp\u0016k\u001dg\fb"), a3.j.getContext());
    }

    private /* synthetic */ Throwable B(Throwable throwable) {
        Throwable a2 = throwable;
        HttpEventPublisher a3 = this;
        if (a2 instanceof MessagingPlatformException) {
            return a2;
        }
        return new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_ERROR, a2.getMessage(), a2);
    }
}

