/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties
implements Cloneable,
Serializable {
    private String storage;
    private int eventsPerSegmentPrefetch;
    private float bloomIndexFpp;
    private boolean useMmapIndex;
    private int segmentsForSequenceNumberCheck;
    private int primaryCleanupDelay;
    private static final String TRANSFORMED_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.transformed";
    private Boolean forceCleanMmapIndex;
    private boolean keepOldVersions;
    private int readBufferSize;
    private int maxIndexesInMemory;
    private int flags;
    private int sksMaxOpenedPositionIndexFiles;
    private String sksPositionIndexFileSuffix;
    private String posIndexSuffix;
    private Boolean forceClean;
    private int streamThreadsPerContext;
    private String bloomIndexSuffix;
    private String indexFormat;
    private String sksAggregateIdEncoder;
    public static final String PRIMARY_STORAGE_KEY = "primary";
    private static final String FILE_FORMAT = "%020d%s";
    private String indexSuffix;
    private int entriesPerSegment;
    private Duration globalIndexPreloadTimeout;
    public static final String TRANSFORMED_SUFFIX = ".transformed";
    private static final String FILE_WITH_VERSION_FORMAT = "%020d_%05d%s";
    private long warnFreeSpace;
    private int validationSegments;
    private static final String OLD_PATH_FORMAT = "%s/%014d%s";
    private boolean bulkIndexAllowParallel;
    private int maxBloomFiltersInMemory;
    private int sksRocksdbCacheSize;
    private long syncInterval;
    private String eventsSuffix;
    private int secondaryCleanupDelay;
    private static final String TEMP_PATH_FORMAT = "%s/%020d%s.temp";
    private String newIndexSuffix;
    private int segmentSize;
    private Map<String, String> storages;
    private static final String TEMP_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.temp";
    private int globalIndexSegmentsCheck;
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    private GlobalIndexPreload globalIndexPreload;
    private long minFreeSpace;
    private String globalIndexSuffix;
    private int memoryMappedSegments;
    private static final String PATH_FORMAT = "%s/%020d%s";
    private final SystemInfoProvider systemInfoProvider;
    private static final String PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s";
    private Duration[] retentionTime;
    private long forceInterval;

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    public void setGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.globalIndexPreloadTimeout = a2;
    }

    public boolean isBulkIndexAllowParallel() {
        StorageProperties a2;
        return a2.bulkIndexAllowParallel;
    }

    public void setBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.bulkIndexAllowParallel = a2;
    }

    public void setSecondaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.secondaryCleanupDelay = a2;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public void setBloomIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.bloomIndexSuffix = a2;
    }

    public void setUseMmapIndex(Boolean bl) {
        Boolean a2 = bl;
        StorageProperties a3 = this;
        a3.useMmapIndex = a2;
    }

    public int getSksRocksdbCacheSize() {
        StorageProperties a2;
        return a2.sksRocksdbCacheSize;
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        return a4.dataFile((String)a3, new FileVersion((long)a2, 0));
    }

    public Boolean getForceClean() {
        StorageProperties a2;
        return a2.forceClean;
    }

    /*
     * WARNING - void declaration
     */
    public StorageProperties(SystemInfoProvider systemInfoProvider, String string, String string2, String string3, String string4, String string5, String string6) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        StorageProperties a9;
        StorageProperties storageProperties = object;
        Object object = string6;
        StorageProperties storageProperties2 = a9 = storageProperties;
        StorageProperties storageProperties3 = a9;
        StorageProperties storageProperties4 = a9;
        a9((SystemInfoProvider)a8);
        storageProperties4.eventsSuffix = a7;
        storageProperties4.indexSuffix = a6;
        storageProperties3.bloomIndexSuffix = a5;
        storageProperties3.globalIndexSuffix = a4;
        storageProperties2.newIndexSuffix = a3;
        storageProperties2.sksPositionIndexFileSuffix = a2;
    }

    public StorageProperties withRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.B().retentionTime = a2;
        return a3.B();
    }

    public float getBloomIndexFpp() {
        StorageProperties a2;
        return a2.bloomIndexFpp;
    }

    public String getNewIndexSuffix() {
        StorageProperties a2;
        return a2.newIndexSuffix;
    }

    public StorageProperties withMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.B().maxBloomFiltersInMemory = a2;
        return a3.B();
    }

    public void setSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksAggregateIdEncoder = a2;
    }

    public void setGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.globalIndexPreload = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public StorageProperties withMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.B().maxIndexesInMemory = a2;
        return a3.B();
    }

    public void setIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexFormat = a2;
    }

    public long getRetentionTime(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        if (a2 < 0 || a2 >= a3.retentionTime.length) {
            return System.currentTimeMillis();
        }
        return a3.retentionTime[a2].toMillis();
    }

    public void setMemoryMappedSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.memoryMappedSegments = a2;
    }

    public StorageProperties withSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.B().sksMaxOpenedPositionIndexFiles = a2;
        return a3.B();
    }

    public void setGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.globalIndexSegmentsCheck = a2;
    }

    public void setStorages(Map<String, String> map) {
        Object a2 = map;
        StorageProperties a3 = this;
        if (a3.storages != null && a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
            a3.storages.putAll(a2);
            return;
        }
        a3.storages = a2;
    }

    public long minFreeSpace() {
        StorageProperties a2;
        return a2.minFreeSpace;
    }

    public int getSksMaxOpenedPositionIndexFiles() {
        StorageProperties a2;
        return a2.sksMaxOpenedPositionIndexFiles;
    }

    public StorageProperties withSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.B().sksRocksdbCacheSize = a2;
        return a3.B();
    }

    public int globalIndexSegmentsCheck() {
        StorageProperties a2;
        return a2.globalIndexSegmentsCheck;
    }

    public String getGlobalIndexSuffix() {
        StorageProperties a2;
        return a2.globalIndexSuffix;
    }

    public void setReadBufferSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.readBufferSize = a2;
    }

    private /* synthetic */ StorageProperties B() {
        StorageProperties storageProperties = this;
        try {
            return (StorageProperties)storageProperties.clone();
        }
        catch (CloneNotSupportedException a2) {
            throw new RuntimeException(a2.getMessage(), a2);
        }
    }

    public StorageProperties withIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.B().indexFormat = a2;
        return a3.B();
    }

    public void setSksPositionIndexFileSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksPositionIndexFileSuffix = a2;
    }

    public void setSyncInterval(long a2) {
        a.syncInterval = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexSuffix = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.B() == 0) {
            return a4.newIndex((String)a2, a3.B());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public String dataFile(long a2) {
        StorageProperties a3;
        Object[] objectArray = new Object[2];
        objectArray[0] = a2;
        objectArray[1] = a3.eventsSuffix;
        return String.format(FILE_FORMAT, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.B() == 0) {
            return a4.transformedIndex((String)a2, a3.B());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public String getSksPositionIndexFileSuffix() {
        StorageProperties a2;
        return a2.sksPositionIndexFileSuffix;
    }

    public String getIndexFormat() {
        StorageProperties a2;
        return a2.indexFormat;
    }

    public void setForceClean(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceClean = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File oldBloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public int getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.B() == 0) {
            return a4.index((String)a2, a3.B());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setBloomIndexFpp(float f2) {
        float a2 = f2;
        StorageProperties a3 = this;
        a3.bloomIndexFpp = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File posIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.posIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public boolean isCleanRequired() {
        StorageProperties a2;
        if (Boolean.TRUE.equals(a2.forceClean) || a2.systemInfoProvider.javaOnWindows()) {
            return true;
        }
        return false;
    }

    public void setMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxIndexesInMemory = a2;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties withSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.B().segmentsForSequenceNumberCheck = a2;
        return a3.B();
    }

    public String getEventsSuffix() {
        StorageProperties a2;
        return a2.eventsSuffix;
    }

    public StorageProperties withGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.B().globalIndexPreloadTimeout = a2;
        return a3.B();
    }

    public void setEventsSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.eventsSuffix = a2;
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    public int segmentsForSequenceNumberCheck() {
        StorageProperties a2;
        return a2.segmentsForSequenceNumberCheck;
    }

    public long getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.minFreeSpace = a2.toBytes();
    }

    public GlobalIndexPreload getGlobalIndexPreload() {
        StorageProperties a2;
        return a2.globalIndexPreload;
    }

    public StorageProperties withGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.B().globalIndexSegmentsCheck = a2;
        return a3.B();
    }

    public StorageProperties withSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.B().sksAggregateIdEncoder = a2;
        return a3.B();
    }

    public void setPrimaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.primaryCleanupDelay = a2;
    }

    public StorageProperties withForceClean(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.B().forceClean = a2;
        return a3.B();
    }

    public String getBloomIndexSuffix() {
        StorageProperties a2;
        return a2.bloomIndexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File oldDataFile(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.eventsSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public void setMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxBloomFiltersInMemory = a2;
    }

    public int getEventsPerSegmentPrefetch() {
        StorageProperties a2;
        return a2.eventsPerSegmentPrefetch;
    }

    public long warnFreeSpace() {
        StorageProperties a2;
        return a2.warnFreeSpace;
    }

    public void setEntriesPerSegment(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.entriesPerSegment = a2;
    }

    public StorageProperties withSegmentSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.B().segmentSize = a2;
        return a3.B();
    }

    public void setValidationSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.validationSegments = a2;
    }

    public boolean isKeepOldVersions() {
        StorageProperties a2;
        return a2.keepOldVersions;
    }

    public void setStreamThreadsPerContext(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.streamThreadsPerContext = a2;
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.warnFreeSpace = a2.toBytes();
    }

    /*
     * WARNING - void declaration
     */
    public File oldIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File newTransformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.B() == 0) {
            return a4.transformedIndex((String)a2, a3.B());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.retentionTime = a2;
    }

    public int getMemoryMappedSegments() {
        StorageProperties a2;
        return a2.memoryMappedSegments;
    }

    public int getEntriesPerSegment() {
        StorageProperties a2;
        return a2.entriesPerSegment;
    }

    public Duration getGlobalIndexPreloadTimeout() {
        StorageProperties a2;
        return a2.globalIndexPreloadTimeout;
    }

    public StorageProperties withBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.B().bulkIndexAllowParallel = a2;
        return a3.B();
    }

    /*
     * WARNING - void declaration
     */
    public File transformedDataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.B() == 0) {
            throw new RuntimeException(UpdateReplicationGroupPayload.B((Object)"\u001e\u007f\u0013p\u0012j]j\u000f\u007f\u0013m\u001bq\u000fs]j\u0012>\u000b{\u000fm\u0014q\u0013>M"));
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.eventsSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.keepOldVersions = a2;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return a2.systemInfoProvider.javaOnWindows();
    }

    public StorageProperties withKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.B().keepOldVersions = a2;
        return a3.B();
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.B() == 0) {
            return a4.newIndexTemp((String)a2, a3.B());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public String getStorage(String string, String string2) {
        void a2;
        Object a3 = string2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        return String.format(UpdateReplicationGroupPayload.B((Object)"XmR;\u000e"), objectArray);
    }

    public StorageProperties withGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.B().globalIndexPreload = a2;
        return a3.B();
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        return a2.useMmapIndex;
    }

    public void setSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksRocksdbCacheSize = a2;
    }

    public String dataFile(FileVersion fileVersion) {
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.B() == 0) {
            return a3.dataFile(a2.B());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.B();
        objectArray[1] = a2.B();
        objectArray[2] = a3.eventsSuffix;
        return String.format(FILE_WITH_VERSION_FORMAT, objectArray);
    }

    public void setFlags(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.flags = a2;
    }

    public void setGlobalIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.globalIndexSuffix = a2;
    }

    public Map<String, String> getAvailableStorages() {
        StorageProperties a2;
        return a2.storages;
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    public void setSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksMaxOpenedPositionIndexFiles = a2;
    }

    public int getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public void setSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.segmentsForSequenceNumberCheck = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.B() == 0) {
            return a4.bloomFilter((String)a2, a3.B());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        return new File((String)a2 + File.separator + a4.dataFile((FileVersion)a3));
    }

    public int getStreamThreadsPerContext() {
        StorageProperties a2;
        return a2.streamThreadsPerContext;
    }

    public Duration getSegmentSealingBlockInterval() {
        return Duration.ofSeconds(1L);
    }

    public StorageProperties(SystemInfoProvider systemInfoProvider) {
        StorageProperties a2;
        StorageProperties a3 = systemInfoProvider;
        StorageProperties storageProperties = a2 = this;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        StorageProperties storageProperties8 = a2;
        StorageProperties storageProperties9 = a2;
        StorageProperties storageProperties10 = a2;
        StorageProperties storageProperties11 = a2;
        a2.eventsSuffix = ".events";
        storageProperties11.indexSuffix = ".index";
        storageProperties11.newIndexSuffix = ".nindex";
        storageProperties10.globalIndexSuffix = ".xref";
        storageProperties10.bloomIndexSuffix = ".bloom";
        storageProperties9.segmentSize = 0x10000000;
        storageProperties9.storage = "./data";
        StorageProperties storageProperties12 = a2;
        storageProperties9.storages = new HashMap();
        storageProperties8.bloomIndexFpp = 0.03f;
        storageProperties8.forceInterval = 1000L;
        storageProperties7.validationSegments = 10;
        storageProperties7.memoryMappedSegments = 5;
        storageProperties6.primaryCleanupDelay = 0;
        storageProperties6.secondaryCleanupDelay = 0;
        storageProperties5.maxIndexesInMemory = 50;
        storageProperties5.maxBloomFiltersInMemory = 100;
        storageProperties4.syncInterval = 1000L;
        storageProperties4.useMmapIndex = true;
        storageProperties3.forceCleanMmapIndex = true;
        storageProperties3.eventsPerSegmentPrefetch = 10;
        storageProperties2.globalIndexSegmentsCheck = Integer.MAX_VALUE;
        storageProperties2.readBufferSize = 32768;
        storageProperties.keepOldVersions = false;
        Duration[] durationArray = new Duration[1];
        durationArray[0] = Duration.ofDays(7L);
        storageProperties.retentionTime = durationArray;
        StorageProperties storageProperties13 = a2;
        StorageProperties storageProperties14 = a2;
        StorageProperties storageProperties15 = a2;
        StorageProperties storageProperties16 = a2;
        StorageProperties storageProperties17 = a2;
        StorageProperties storageProperties18 = a2;
        StorageProperties storageProperties19 = a2;
        storageProperties19.segmentsForSequenceNumberCheck = 10;
        storageProperties19.minFreeSpace = DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties18.warnFreeSpace = DataSize.ofGigabytes((long)5L).toBytes();
        storageProperties18.entriesPerSegment = 1000000;
        storageProperties17.globalIndexPreload = GlobalIndexPreload.l;
        storageProperties17.globalIndexPreloadTimeout = Duration.ofSeconds(10L);
        storageProperties16.sksPositionIndexFileSuffix = ".rindex";
        storageProperties16.sksAggregateIdEncoder = "plain";
        storageProperties15.sksMaxOpenedPositionIndexFiles = 100;
        storageProperties15.sksRocksdbCacheSize = (int)DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties14.posIndexSuffix = ".pos";
        storageProperties14.bulkIndexAllowParallel = false;
        storageProperties13.streamThreadsPerContext = 1;
        storageProperties13.systemInfoProvider = a3;
    }

    public String getPrimaryStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3.storages.getOrDefault(PRIMARY_STORAGE_KEY, a3.storage);
        objectArray[1] = a2;
        return String.format(UserEvents.B((Object)"0G:\u0011f"), objectArray);
    }

    public void setEventsPerSegmentPrefetch(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.eventsPerSegmentPrefetch = a2;
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)UpdateReplicationGroupPayload.B((Object)".{\u001as\u0018p\t>\u000ew\u0007{]s\bm\t>\u001f{]r\u0018m\u000e>\tv\u001cp],L*J*E-K*J"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)UserEvents.B((Object)"FQrYpZa\u0014f]oQ5Y`Ga\u0014wQ5SgQt@pF5@}U{\u0014%"));
        a3.segmentSize = (int)a2.toBytes();
    }

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public int getMaxBloomFiltersInMemory() {
        StorageProperties a2;
        return a2.maxBloomFiltersInMemory;
    }

    public void setStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.storage = a2;
        if (a3.storages != null) {
            if (!a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
                a3.storages.put(PRIMARY_STORAGE_KEY, a2);
                return;
            }
        } else {
            a3.storages = new HashMap();
            a3.storages.put(PRIMARY_STORAGE_KEY, a2);
        }
    }

    public int getReadBufferSize() {
        StorageProperties a2;
        return a2.readBufferSize;
    }

    public String getStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        String string2 = (String)a3.storages.get(a2);
        if (string2 == null) {
            if (PRIMARY_STORAGE_KEY.equals(a2)) {
                return a3.storage;
            }
            Object object = a2;
            throw new IllegalStateException("Storage " + (String)object + " not defined on this node.To define storage set property: axoniq.axonserver.event.storages." + (String)object);
        }
        return string2;
    }

    public int getMaximumNumberOfPendingSegmentSeals() {
        return 3;
    }

    public void setNewIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.newIndexSuffix = a2;
    }

    public String getSksAggregateIdEncoder() {
        StorageProperties a2;
        return a2.sksAggregateIdEncoder;
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setForceInterval(long a2) {
        a.forceInterval = a2;
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceCleanMmapIndex = a2;
    }
}

