/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file.xref;

import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.exception.ConcurrencyExceptions;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.xref.Index;
import io.axoniq.axonserver.localstorage.file.xref.JumpSkipIndexEntries;
import io.axoniq.axonserver.localstorage.file.xref.b;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ReadOnlyJumpSkipIndexManager
implements IndexManager {
    protected final EventType A;
    protected static final ScheduledExecutorService f;
    protected final ConcurrentSkipListMap<FileVersion, Index> J;
    protected final Supplier<IndexManager> B;
    protected static final Serializer<JumpSkipIndexEntries> d;
    protected final Supplier<StorageProperties> c;
    protected final String b;
    protected final AtomicLong e;
    protected ScheduledFuture<?> K;
    protected final AtomicLong M;
    protected final String a;
    protected final AtomicBoolean j;
    protected final MeterFactory.RateMeter h;
    private static final Logger D;
    protected final MeterFactory.RateMeter C;
    protected final String I;
    public static final String l = "index";
    protected final ConcurrentNavigableMap<Long, Integer> k;

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Mono.defer(() -> a3.B((FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(FileVersion fileVersion, HTreeMap hTreeMap, String string, List list) {
        void a2;
        int n;
        List a3;
        void a4;
        JumpSkipIndexEntries a5;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = list2;
        List list2 = list;
        ReadOnlyJumpSkipIndexManager a6 = readOnlyJumpSkipIndexManager;
        a5 = a6.B((FileVersion)a5, (String)a4);
        IndexEntry indexEntry = (IndexEntry)a3.get(0);
        Integer[] integerArray = new Integer[a3.size()];
        int n2 = n = 0;
        while (n2 < a3.size()) {
            int n3 = n++;
            integerArray[n3] = ((IndexEntry)a3.get(n3)).B();
            n2 = n;
        }
        a2.put((Object)a4, (Object)new JumpSkipIndexEntries(a5.B(), indexEntry.B(), integerArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void c(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        Object a222 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.I;
        objectArray[1] = a3.A;
        objectArray[2] = a2;
        D.info(ConcurrencyExceptions.B((Object)"dS%\u000e|\\zOkK?Ub\u000ev@{Kg\u000eyAm\u000edS"), objectArray);
        StorageProperties storageProperties = (StorageProperties)a3.c.get();
        Object object = a222 == null ? Collections.emptyMap() : a222;
        a222 = a3.B((FileVersion)a2, (Map)object);
        object = storageProperties.newIndex(a3.a, (FileVersion)a2);
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(((File)a222).toPath(), ((File)object).toPath(), copyOptionArray);
            a3.e.addAndGet(((File)object).length());
            a3.k.put(a2.B(), a2.B());
            return;
        }
        catch (IOException a222) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a3.a, (FileVersion)a2), (Throwable)a222);
        }
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Collections.singletonList(((StorageProperties)a3.c.get()).newIndex(a3.a, (FileVersion)a2));
    }

    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        Object a2 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(ConcurrencyExceptions.B((Object)"wp[?M~@?AqBf\u000e|\\zOkK?Oq\u000ev@{Kg\u000ey\\pC?ZwK?~mGrOmWU[r^LEv^V@{Kgc~@~Iz\\"));
    }

    /*
     * WARNING - void declaration
     */
    public ReadOnlyJumpSkipIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        ReadOnlyJumpSkipIndexManager a7;
        Object a8 = string;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a7 = this;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = a7;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager3 = a7;
        a7.J = new ConcurrentSkipListMap();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager4 = a7;
        readOnlyJumpSkipIndexManager3.k = new ConcurrentSkipListMap(Comparator.reverseOrder());
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager5 = a7;
        a7.M = new AtomicLong();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager6 = a7;
        a7.j = new AtomicBoolean(false);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager7 = a7;
        a7.e = new AtomicLong();
        readOnlyJumpSkipIndexManager2.I = a8;
        readOnlyJumpSkipIndexManager2.c = a6;
        readOnlyJumpSkipIndexManager.a = a5;
        readOnlyJumpSkipIndexManager.A = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a8;
        stringArray[2] = "type";
        stringArray[3] = a4.name();
        a8 = Tags.of((String[])stringArray);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager8 = a7;
        readOnlyJumpSkipIndexManager8.h = a3.rateMeter((MetricName)BaseMetricName.H, (Tags)a8);
        readOnlyJumpSkipIndexManager8.C = a3.rateMeter((MetricName)BaseMetricName.X, (Tags)a8);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager9 = a7;
        readOnlyJumpSkipIndexManager9.B = a2;
        readOnlyJumpSkipIndexManager9.b = ((StorageProperties)a6.get()).getNewIndexSuffix();
        f.scheduleAtFixedRate(() -> a7.c(), 10L, 10L, TimeUnit.SECONDS);
    }

    private /* synthetic */ void B(FileVersion fileVersion, Void void_) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.k.put(a2.B(), a2.B());
    }

    /*
     * WARNING - void declaration
     */
    protected File B(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        void a2;
        File a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2;
        block9: {
            ReadOnlyJumpSkipIndexManager a222;
            block7: {
                readOnlyJumpSkipIndexManager2 = this;
                a222 = (StorageProperties)readOnlyJumpSkipIndexManager2.c.get();
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = a222.newIndex(readOnlyJumpSkipIndexManager2.a, (FileVersion)a3);
                objectArray[2] = a2.keySet();
                D.debug(ContextNameValidation.B((Object)"\u0006eG8\u001ej\u0018y\t}]c\u00004]s\u0018a\u000e8\u0006e"), objectArray);
                a3 = a222.newIndexTemp(readOnlyJumpSkipIndexManager2.a, a3.B());
                try {
                    Files.deleteIfExists(a3.toPath());
                }
                catch (IOException a222) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, ConcurrencyExceptions.B((Object)"h~GsK{\u000ekA?JzBzZz\u000ekKr^p\\~\\f\u000ev@{Kg\u000eyGsK"), (Throwable)a222);
                }
                a222 = DBMaker.fileDB((File)a3).fileMmapEnable().cleanerHackEnable().make();
                HTreeMap hTreeMap = a222.hashMap(l, (Serializer)Serializer.STRING, d).create();
                try {
                    hTreeMap.putAll((Map)a2);
                    a222.commit();
                    if (hTreeMap == null) break block7;
                    readOnlyJumpSkipIndexManager = a222;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block9;
            }
            readOnlyJumpSkipIndexManager = a222;
        }
        readOnlyJumpSkipIndexManager.close();
        File file = a3;
        readOnlyJumpSkipIndexManager2.B(file, a2.size());
        return file;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        long a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        try {
            void a4;
            void a5;
            void a6;
            ReadOnlyJumpSkipIndexManager a7;
            void a8;
            while (a3 >= a8 && a3 >= (Long)readOnlyJumpSkipIndexManager.k.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a7 = readOnlyJumpSkipIndexManager2.B(a3);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.B((FileVersion)a7, (String)a2);
                if (jumpSkipIndexEntries != null) {
                    IndexEntries indexEntries = jumpSkipIndexEntries.range((long)a6, (long)a5, EventType.k.equals((Object)readOnlyJumpSkipIndexManager.A));
                    if (!indexEntries.isEmpty()) {
                        treeMap.put((FileVersion)a7, indexEntries);
                        if (readOnlyJumpSkipIndexManager.B((long)a6, (long)(a4 -= (long)indexEntries.size()), (IndexEntries)jumpSkipIndexEntries)) {
                            return treeMap;
                        }
                    }
                    if (jumpSkipIndexEntries.B() >= a7.B()) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = readOnlyJumpSkipIndexManager.I;
                        objectArray[1] = readOnlyJumpSkipIndexManager.A;
                        objectArray[2] = a2;
                        objectArray[3] = a7;
                        throw new MessagingPlatformException(ErrorCode.INDEX_READ_ERROR, String.format(ConcurrencyExceptions.B((Object)"\u000bl\u0014?gqX~BvJ?GqJzV?KqZmW?Hp\\?\u000bl\u000e:]?Gq\u000elKxCz@k\u000e:]3\u000esGqEl\u000ekA?@zYz\\?ZpEz@"), objectArray));
                    }
                    if (jumpSkipIndexEntries.firstSequenceNumber() > 0L && jumpSkipIndexEntries.B() == -1L) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = readOnlyJumpSkipIndexManager.I;
                        objectArray[1] = a2;
                        objectArray[2] = a7;
                        objectArray[3] = jumpSkipIndexEntries.firstSequenceNumber();
                        D.warn(ContextNameValidation.B((Object)"c\u0000\"]q\u0013n\u001ct\u0014|]h\u000f}\u000bq\u0012m\u000e8\tw\u0016}\u00138\np\u0014t\u00188\u000f}\u001c|\u0014v\u001a8\u0018n\u0018v\tk]~\u0012j]c\u00004]h\u000f}\u000bq\u0012m\u000e8\tw\u0016}\u00138P)]q\u00138\u000e}\u001au\u0018v\t8\u0006e]z\bl]~\u0014j\u000el]k\u0018i\b}\u0013{\u00188\u0013m\u0010z\u0018j]q\u000e8\u0006eQ8\u001ew\u0013l\u0014v\b}]q\u00138\rj\u0018n\u0014w\bk]k\u0018\u007f\u0010}\u0013l"), objectArray);
                        a3 = a7.B() - 1L;
                        continue;
                    }
                    a3 = jumpSkipIndexEntries.B();
                    continue;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.I;
                objectArray[1] = a2;
                objectArray[2] = a7;
                D.warn(ConcurrencyExceptions.B((Object)"Ub\u0014?GqX~BvJ?^mKiGp[l\u000ekAtKq\u000ehFvBz\u000emK~Jv@x\u000ezXz@k]?Hp\\?Ub\u0002?OxImKxOkK?@pZ?Hp[qJ?Gq\u000elKxCz@k\u000edS3\u000e|AqZv@jK?Gq\u000eo\\zXvAj]?]zIrKqZ"), objectArray);
                a3 = a7.B() - 1L;
            }
            a7 = (IndexManager)readOnlyJumpSkipIndexManager.B.get();
            if (a7 == null) return treeMap;
            treeMap.putAll(((IndexManager)readOnlyJumpSkipIndexManager.B.get()).lookupAggregateInClosedSegments((String)a2, (long)a6, (long)a5, (long)a4, (long)a8, a3));
            return treeMap;
        }
        catch (IndexNotFoundException a7) {
            Object[] objectArray = new Object[4];
            objectArray[0] = readOnlyJumpSkipIndexManager.I;
            objectArray[1] = a2;
            objectArray[2] = a3;
            objectArray[3] = readOnlyJumpSkipIndexManager.k;
            D.warn(ContextNameValidation.B((Object)"\u0006eG8\u0018j\u000fw\u000f8\u000f}\u001c|\u0014v\u001a8\u0018n\u0018v\tk]~\u0012j]c\u00004]h\u000f}\u000bq\u0012m\u000e8\tw\u0016}\u00138\u0006eQ8\u0014v\u0019}\u0005}\u000e8\u0006e"), objectArray);
        }
        return treeMap;
    }

    protected void c() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager = this;
        while (readOnlyJumpSkipIndexManager2.J.size() > ((StorageProperties)readOnlyJumpSkipIndexManager.c.get()).getMaxIndexesInMemory()) {
            Map.Entry a2 = readOnlyJumpSkipIndexManager.J.pollFirstEntry();
            D.debug(ContextNameValidation.B((Object)"\u0006eG8>t\u0012k\u0014v\u001a8\u0014v\u0019}\u00058\u0006e"), (Object)readOnlyJumpSkipIndexManager.I, a2.getKey());
            readOnlyJumpSkipIndexManager.K = f.schedule(() -> ((Index)a2.getValue()).close(), 2L, TimeUnit.SECONDS);
            readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected FileVersion B(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        NavigableSet<Long> a3 = readOnlyJumpSkipIndexManager.k.keySet().tailSet((long)a2, true);
        if (a3.isEmpty()) {
            throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.I + ": Index for token not found: " + (long)a2);
        }
        return new FileVersion(((Long)a3.first()).longValue(), ((Integer)readOnlyJumpSkipIndexManager.k.get(a3.first())).intValue());
    }

    public void addExistingIndex(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.k.put(a2.B(), a2.B());
        a3.B();
    }

    public boolean remove(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a22 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Index index = (Index)a3.J.remove(a22);
        if (index != null) {
            D.debug(ContextNameValidation.B((Object)">t\u0012k\u00188\u0014v\u0019}\u00058\u0006e"), (Object)a22);
            index.close();
        }
        a3.k.remove(a22.B(), a22.B());
        if (D.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.hashCode();
            objectArray[1] = a22;
            objectArray[2] = a3.k.keySet();
            D.debug(ConcurrencyExceptions.B((Object)"Ub\u0014?jzBzZzJ?]zIrKqZ?Ub\u0002?\\zC~GqGqI?]zIrKqZl\u000edS"), objectArray);
        }
        File file = ((StorageProperties)a3.c.get()).newIndex(a3.a, (FileVersion)a22);
        long l2 = file.length();
        boolean a22 = FileUtils.B((File)file);
        if (a22) {
            a3.e.addAndGet(-l2);
        }
        return a22;
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5, long l6) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(ContextNameValidation.B((Object)"W\r}\u000fy\tq\u0012v]w\u0013t\u00048\u000em\rh\u0012j\t}\u00198\u0012v]h\u000fq\u0010y\u000fa]q\u0013|\u0018`]u\u001cv\u001c\u007f\u0018j"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(File file, File file2) {
        void a2;
        File a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.I;
        objectArray[1] = a3.getAbsolutePath();
        objectArray[2] = a2.getAbsolutePath();
        D.debug(ConcurrencyExceptions.B((Object)"Ub\u0014?|z@~Cv@x\u000ekFz\u000ekKr^p\\~\\f\u000ev@{Kg\u000edS?Zp\u000edS"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.c.get();
        Integer n = (Integer)readOnlyJumpSkipIndexManager.k.remove((long)a2);
        if (n != null) {
            int a3;
            int n2 = a3 = 0;
            while (n2 < n) {
                FileVersion fileVersion = new FileVersion((long)a2, a3);
                if (storageProperties.newIndex(readOnlyJumpSkipIndexManager.a, fileVersion).exists()) {
                    readOnlyJumpSkipIndexManager.remove(fileVersion);
                }
                n2 = ++a3;
            }
            return readOnlyJumpSkipIndexManager.remove(new FileVersion((long)a2, n.intValue()));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean B(long l2, long l3, IndexEntries indexEntries) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3;
        void a4;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntries;
        ReadOnlyJumpSkipIndexManager a5 = readOnlyJumpSkipIndexManager;
        if (a4 >= a3.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono B(File file, File file2) {
        void a2;
        Object a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return Mono.fromSupplier(() -> ReadOnlyJumpSkipIndexManager.B((File)a2)).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).doOnNext(arg_0 -> a4.B((File)a3, arg_0)).flatMap(arg_0 -> ReadOnlyJumpSkipIndexManager.B((File)a2, (File)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono B(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        Object a3 = ((StorageProperties)readOnlyJumpSkipIndexManager.c.get()).newTransformedIndex(readOnlyJumpSkipIndexManager.a, (FileVersion)a2);
        return readOnlyJumpSkipIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    public void init() {
        File[] fileArray = this;
        if (!fileArray.j.get()) {
            int n2;
            File[] a2 = new File(fileArray.a).listFiles(file -> {
                File a2 = file;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return a2.getName().endsWith(a3.b);
            });
            if (a2 == null) {
                return;
            }
            int n3 = a2.length;
            int n4 = n2 = 0;
            while (n4 < n3) {
                File file2 = a2[n2];
                FileVersion fileVersion = FileUtils.B((String)file2.getName());
                fileArray.k.compute(fileVersion.B(), (l2, n) -> {
                    Integer a2 = n;
                    FileVersion a3 = fileVersion;
                    return a2 == null ? a3.B() : Math.max(a3.B(), a2);
                });
                fileArray.e.addAndGet(file2.length());
                n4 = ++n2;
            }
            fileArray.B();
            fileArray.j.set(true);
        }
    }

    private static /* synthetic */ boolean B(long l2, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    public void complete(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        fileVersion = this;
    }

    static {
        D = LoggerFactory.getLogger(ReadOnlyJumpSkipIndexManager.class);
        d = new b();
        f = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(ConcurrencyExceptions.B((Object)"Dl\u0003v@{Kg\u0003rOqOxKm\u0003")));
    }

    private static /* synthetic */ File B(File a2) {
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StorageProperties storageProperties;
        block10: {
            StorageProperties storageProperties2;
            block8: {
                Map<String, List> a2;
                void a32;
                int a222 = n;
                ReadOnlyJumpSkipIndexManager a4 = this;
                storageProperties2 = (StorageProperties)a4.c.get();
                Object a222 = new FileVersion((long)a32, a222);
                if (a2 == null) {
                    a2 = Collections.emptyMap();
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = a222;
                objectArray[1] = storageProperties2.newIndex(a4.a, (long)a32);
                objectArray[2] = a2.keySet();
                D.debug(ContextNameValidation.B((Object)"\u0006eG8\u001ej\u0018y\t}]c\u00004]s\u0018a\u000e8\u0006e"), objectArray);
                a222 = storageProperties2.newTransformedIndex(a4.a, (FileVersion)a222);
                try {
                    Files.deleteIfExists(((File)a222).toPath());
                }
                catch (IOException iOException) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, ConcurrencyExceptions.B((Object)"h~GsK{\u000ekA?JzBzZz\u000ek\\~@lHp\\rK{\u000ev@{Kg\u000eyGsK"), (Throwable)iOException);
                }
                storageProperties2 = DBMaker.fileDB((File)a222).fileMmapEnable().cleanerHackEnable().make();
                a222 = storageProperties2.hashMap(l, (Serializer)Serializer.STRING, d).createOrOpen();
                try {
                    Integer n2 = (Integer)a4.k.get((long)a32);
                    FileVersion a32 = new FileVersion((long)a32, n2.intValue());
                    a2.forEach((arg_0, arg_1) -> a4.B(a32, (HTreeMap)a222, arg_0, arg_1));
                    if (a222 == null) break block8;
                    storageProperties = storageProperties2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a222 != null) {
                            try {
                                a222.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable a32) {
                                throwable.addSuppressed(a32);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a222.close();
                break block10;
            }
            storageProperties = storageProperties2;
        }
        storageProperties.close();
    }

    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(ContextNameValidation.B((Object)"2h\u0018j\u001cl\u0014w\u00138\u0012v\u0011a]k\bh\rw\u000fl\u0018|]~\u0012j]h\u000fq\u0010y\u000fa]q\u0013|\u0018`]u\u001cv\u001c\u007f\u0018j"));
    }

    /*
     * WARNING - void declaration
     */
    protected Index c(FileVersion fileVersion2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            return readOnlyJumpSkipIndexManager.J.computeIfAbsent(a2, fileVersion -> {
                ReadOnlyJumpSkipIndexManager a2 = fileVersion;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return new Index(a3, (FileVersion)a2);
            }).B();
        }
        catch (IndexNotFoundException a3) {
            readOnlyJumpSkipIndexManager.J.remove(a2);
            throw a3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(FileVersion fileVersion, Throwable throwable) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = fileVersion;
        ReadOnlyJumpSkipIndexManager a4 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4.I;
        objectArray[1] = a3.B();
        objectArray[2] = a3.B();
        objectArray[3] = a2;
        D.warn(ContextNameValidation.B((Object)"\u0006eG88j\u000fw\u000f8\np\u0014t\u00188\u001c{\tq\u000by\tq\u0013\u007f]k\u0018\u007f\u0010}\u0013l]c\u00008\u000b}\u000fk\u0014w\u00138\u0006e"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public void B(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = this;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        if (a3.B((FileVersion)a4)) {
            a3.c((FileVersion)a4, (Map)a2);
            return;
        }
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = (ReadOnlyJumpSkipIndexManager)a3.B.get();
        if (readOnlyJumpSkipIndexManager != null) {
            readOnlyJumpSkipIndexManager.B((FileVersion)a4, (Map)a2);
        }
    }

    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        ReadOnlyJumpSkipIndexManager a2 = searchHint;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Optional.empty();
    }

    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> readOnlyJumpSkipIndexManager) {
        Object a2 = readOnlyJumpSkipIndexManager;
        readOnlyJumpSkipIndexManager = this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            void a2;
            void a3;
            ReadOnlyJumpSkipIndexManager a4;
            long a5;
            long l4 = a5 = a5;
            while (l4 >= (Long)readOnlyJumpSkipIndexManager.k.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a4 = readOnlyJumpSkipIndexManager2.B(a5);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.c((FileVersion)a4).B((String)a3);
                if (jumpSkipIndexEntries == null) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = readOnlyJumpSkipIndexManager.I;
                    objectArray[1] = a3;
                    objectArray[2] = a4;
                    D.debug(ConcurrencyExceptions.B((Object)"dS%\u000ez@k\\vKl\u000eyAm\u000edS?@pZ?Hp[qJ?Gq\u000elKxCz@k\u000edS"), objectArray);
                    return null;
                }
                if (jumpSkipIndexEntries.firstSequenceNumber() < a2) {
                    JumpSkipIndexEntries jumpSkipIndexEntries2 = jumpSkipIndexEntries;
                    return new SegmentIndexEntries((FileVersion)a4, jumpSkipIndexEntries2.range(jumpSkipIndexEntries2.firstSequenceNumber(), (long)a2, EventType.k.equals((Object)readOnlyJumpSkipIndexManager.A)));
                }
                l4 = jumpSkipIndexEntries.B();
            }
            a4 = (IndexManager)readOnlyJumpSkipIndexManager.B.get();
            if (a4 == null) return null;
            return a4.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, a5);
        }
        catch (IndexNotFoundException a5) {
            D.debug(ContextNameValidation.B((Object)"c\u0000\"]q\u0013|\u0018`]v\u0012l]~\u0012m\u0013|"), (Object)readOnlyJumpSkipIndexManager.I, (Object)a5);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> B(FileVersion fileVersion, File file) {
        void a3;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        ReadOnlyJumpSkipIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.B((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).doOnNext(arg_0 -> a5.B((FileVersion)a4, arg_0)).flatMap(arg_0 -> a5.B((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.B((FileVersion)a4, arg_0)).doOnError(arg_0 -> a5.B((FileVersion)a4, arg_0));
    }

    private /* synthetic */ boolean B(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.c.get()).dataFile(a3.a, (FileVersion)a2).exists();
    }

    /*
     * Exception decompiling
     */
    protected void B(File var1_2, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long size() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a2 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.B.get();
        if (a2 != null) {
            return readOnlyJumpSkipIndexManager.e.get() + a2.size();
        }
        return readOnlyJumpSkipIndexManager.e.get();
    }

    /*
     * WARNING - void declaration
     */
    public boolean validIndex(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        boolean a3 = false;
        try {
            StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.c.get();
            a3 = storageProperties.newIndex(readOnlyJumpSkipIndexManager.a, (FileVersion)a2).exists();
            return a3;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = readOnlyJumpSkipIndexManager.I;
            objectArray[1] = a2;
            objectArray[2] = exception;
            D.warn(ConcurrencyExceptions.B((Object)"dS%\u000eYOvBzJ?Zp\u000eiOsG{OkK?GqJzV?Hp\\?]zIrKqZ%\u000edS"), objectArray);
            return a3;
        }
    }

    private /* synthetic */ void B(FileVersion fileVersion, File file) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        D.debug(ContextNameValidation.B((Object)"c\u0000\"]Y\u001el\u0014n\u001cl\u0014v\u001a8\u0014v\u0019}\u00058\u001bw\u000f8\u001bq\u0011}\u000b}\u000fk\u0014w\u00138\u0006e"), (Object)a3.I, (Object)a2);
    }

    private static /* synthetic */ Mono B(File file, File file2, File file3) {
        File a2 = file2;
        File a3 = file;
        return FileUtils.B((File)a3, (File)a2);
    }

    private /* synthetic */ File B(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.c.get()).newIndex(a3.a, (FileVersion)a2);
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return a3.c((FileVersion)a2).B();
    }

    /*
     * WARNING - void declaration
     */
    public Index B(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        D.debug(ContextNameValidation.B((Object)"T\u0012w\u0016q\u0013\u007f]~\u0012j]c\u00004]q\u0013|\u0018`\u0018kG8\u0006e"), (Object)((long)a2), (Object)readOnlyJumpSkipIndexManager.k);
        Object a3 = (Integer)readOnlyJumpSkipIndexManager.k.get((long)a2);
        if (a3 != null) {
            return readOnlyJumpSkipIndexManager.c(new FileVersion((long)a2, ((Integer)a3).intValue()));
        }
        a3 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.B.get();
        if (a3 != null) {
            D.debug(ConcurrencyExceptions.B((Object)"dS%\u000eyGqJ?GqJzV?Hp\\?Ub\u000ev@?@zVk\u000ekGz\\"), (Object)readOnlyJumpSkipIndexManager.I, (Object)((long)a2));
            return a3.B((long)a2);
        }
        throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.I + ": Index not found: " + (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        readOnlyJumpSkipIndexManager.J.forEach((fileVersion, index) -> {
            FileVersion a2 = index;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        readOnlyJumpSkipIndexManager.J.clear();
        if (a2 != false) {
            readOnlyJumpSkipIndexManager.k.keySet().forEach(arg_0 -> readOnlyJumpSkipIndexManager.removeAllVersions(arg_0));
        }
        if (readOnlyJumpSkipIndexManager.K != null && !readOnlyJumpSkipIndexManager.K.isDone()) {
            readOnlyJumpSkipIndexManager.K.cancel(true);
        }
        try {
            ReadOnlyJumpSkipIndexManager a3 = (IndexManager)readOnlyJumpSkipIndexManager.B.get();
            if (a3 != null) {
                a3.cleanup((boolean)a2);
                return;
            }
        }
        catch (Exception a3) {
            D.info(ConcurrencyExceptions.B((Object)"Ub\u0014?msK~@j^?Ay\u000ev@{Kg\u000eyOvBzJ"), (Object)readOnlyJumpSkipIndexManager.I, (Object)a3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ File B(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return a2.newIndex(a4.a, new FileVersion(((Long)a3.getKey()).longValue(), ((Integer)a3.getValue()).intValue()));
    }

    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntry;
        ReadOnlyJumpSkipIndexManager a2 = readOnlyJumpSkipIndexManager;
    }

    protected void B() {
        ReadOnlyJumpSkipIndexManager a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a2;
        readOnlyJumpSkipIndexManager.M.set(readOnlyJumpSkipIndexManager.k.keySet().stream().skip(((StorageProperties)a2.c.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = fileVersion;
        ReadOnlyJumpSkipIndexManager a4 = this;
        if (a4.k.containsKey(a3.B())) {
            return a4.B((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.B.get();
        if (indexManager != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.I;
            objectArray[1] = a3.B();
            objectArray[2] = a3.B();
            D.debug(ContextNameValidation.B((Object)"c\u0000\"]y\u001el\u0014n\u001cl\u00188\u0006e]~\u0012j]c\u00008\u0014v]v\u0018`\t8\tq\u0018j"), objectArray);
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    MeterFactory.RateMeter B() {
        ReadOnlyJumpSkipIndexManager a2;
        return a2.h;
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a2;
        void a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a4 = (StorageProperties)readOnlyJumpSkipIndexManager.c.get();
        return readOnlyJumpSkipIndexManager.k.entrySet().stream().filter(arg_0 -> ReadOnlyJumpSkipIndexManager.B((long)a3, (int)a2, arg_0)).map(arg_0 -> readOnlyJumpSkipIndexManager.B((StorageProperties)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ JumpSkipIndexEntries B(FileVersion fileVersion, String string) {
        void a2;
        void a3;
        int n;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        int n2 = n = 3;
        while (n2 > 0) {
            try {
                ReadOnlyJumpSkipIndexManager a4 = readOnlyJumpSkipIndexManager.c((FileVersion)a3);
                return a4.B((String)a2);
            }
            catch (DBException a4) {
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.I;
                objectArray[1] = a3;
                objectArray[2] = a4;
                D.debug(ContextNameValidation.B((Object)"c\u0000\"]Q\u0013|\u0018`]\\?8\u0018`\u001e}\rl\u0014w\u00138\u0006e"), objectArray);
                n2 = --n;
            }
            catch (IllegalAccessError a4) {
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.I;
                objectArray[1] = a3;
                objectArray[2] = a4;
                D.debug(ConcurrencyExceptions.B((Object)"Ub\u0014?GsBzI~B?O|Mz]l\u000edS"), objectArray);
                n2 = --n;
            }
        }
        throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.I + ": Index not found for segment " + (FileVersion)a3 + ", aggregate " + (String)a2);
    }
}

