/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.localstorage.query.MaxTokenExtractor;
import io.axoniq.axonserver.logging.b;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger k = AuditLog.getLogger();

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + b.k.B()[2].getName()));
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return MaxTokenExtractor.B((Object)"[\n\t\u0004\t\u0012\n\u0004\u0012\u0018Y");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    public AuditLog() {
        AuditLog a2;
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated adminUserUpdated) {
        AuditLog a2 = adminUserUpdated;
        AuditLog a3 = this;
        if (k.isDebugEnabled()) {
            k.debug(a2.toString());
        }
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return EventSourceNotFoundException.B((Object)"\u001cT\u0018X\u0015_\u001d");
        }
        return MaxTokenExtractor.B((Object)"/.8&)+.#");
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted adminUserDeleted) {
        AuditLog a2 = adminUserDeleted;
        AuditLog a3 = this;
        if (k.isDebugEnabled()) {
            k.debug(a2.toString());
        }
    }

    public static String username(String a2) {
        if (a2 == null) {
            return EventSourceNotFoundException.B((Object)"e{7u7c4u,ig");
        }
        return StringUtils.sanitize((String)a2);
    }

    @EventListener
    public void on(AbstractAuthenticationEvent abstractAuthenticationEvent) {
        AuditLog a2 = abstractAuthenticationEvent;
        AuditLog a3 = this;
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (k.isDebugEnabled()) {
            k.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            k.info(EventSourceNotFoundException.B((Object)"\u0015u>s7:.s-ryo*\u007f+t8w<:{a$8w"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            k.error(MaxTokenExtractor.B((Object)"+\u0004\u0000\u0002\tK\u0010\u0002\u0013\u0003G\u001e\u0014\u000e\u0015\u0005\u0006\u0006\u0002KE\u0010\u001aIG-&\"+.#QG\u0010\u001a"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }
}

