/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.integration.CommandHandlerController;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final long D;
    private final long C;
    private final int I = 25000;
    private final Logger l;
    private final Map<String, ActiveQuery> k;

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.l = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.I = 25000;
        QueryCache queryCache3 = this;
        queryCache.k = new ConcurrentHashMap();
        queryCache.C = defaultQueryTimeout;
        if (a2 > 0L) {
            this.D = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.D = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    private /* synthetic */ void B() {
        QueryCache a2;
        if ((long)a2.k.size() >= a2.D) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.D + "/" + a2.D + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.k.entrySet();
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.l.debug(AccessControlConfiguration.B((Object)"^)a#z),!i?\u007f-k)E(,7q"), a3);
        return (ActiveQuery)queryCache.k.remove(a3);
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.k.get(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.B((ActiveQuery)a3, a2.B());
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.B();
        return (ActiveQuery)queryCache.k.putIfAbsent(a2, a4);
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l2 = System.currentTimeMillis() - a4.C;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).B() < l2) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).B()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public int size() {
        QueryCache a2;
        return a2.k.size();
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.k.forEach((arg_0, arg_1) -> a3.B((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.k.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.l.debug(CommandHandlerController.B((Object)"\f3\",#9;9o-:9=%o'2|)3=|>)*.6|'=!8#9=|&8*2;5)5*8o>6|,0&9!(\u001c(=9.1\u00068o'2r"), (Object)a2.c(), a3);
        if (a2.c((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.B((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(AccessControlConfiguration.B((Object)"O#b\"i/x%c\",8cld-b(`)~l)?, c?x"), objectArray))) {
                a4.remove(a2.c());
            }
        }
    }
}

