/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.rest.RestResponse;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final Map<String, AtomicInteger> a;
    private final NonReplacingConstraintCache<String, ActiveQuery> j;
    private final FlowControlQueues<QueryInstruction> h;
    private final QueryInterceptors D;
    private final QueryRegistrationCache C;
    private final QueryMetricsRegistry I;
    private final Logger l;
    private final DispatchQueueMetrics k;

    public void deleteMetrics(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        a3.a.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.I.remove((MetricName)BaseMetricName.s, (String)a2);
        queryDispatcher.I.removeForContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void handleComplete(String string, String string2, String string3) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher a4 = queryDispatcher.B((String)a3, (String)a2);
        if (a4 != null) {
            if (a4.F((String)a3)) {
                queryDispatcher.j.remove((Object)a4.c());
            }
            long l2 = System.currentTimeMillis() - a4.B();
            if (a4.c()) {
                void a5;
                queryDispatcher.I.addHandlerResponseTime(a4.B(), a4.F(), (String)a5, a4.B(), l2);
                return;
            }
        } else {
            queryDispatcher.l.debug(RestResponse.B((Object)"/\u000fAH\f\u000f\u0013\u0005H@\b\u000e\u0007\u000f\u0013\r\u0000\u0014\b\u000f\u000f@\u0007\u000f\u0013@\u001a\u001dA\u000f\u000f@\u0002\u000f\f\u0010\r\u0005\u0015\u0005\u0005"), (Object)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(String string, String string2, Runnable runnable) {
        Runnable a22 = runnable;
        QueryDispatcher a3 = this;
        try {
            a22.run();
            return;
        }
        catch (MessagingPlatformException a22) {
            void a4;
            void a5;
            QueryDispatcher queryDispatcher = a3;
            queryDispatcher.l.debug(RaftAdminGroup.B((Object)"\u000fp8m8\".k9r+v)j#l-\",n%ujs?g8{jk$q>p?a>k%ljv%\">c8e/vja&k/l>\"1\u007f"), (Object)a5);
            queryDispatcher.completeWithError((String)a4, (String)a5, a22.getErrorCode(), a22.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void query(SerializedQuery serializedQuery, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        Consumer<String> a3;
        Consumer<QueryResponse> a4;
        void a5;
        QueryDispatcher queryDispatcher = this;
        Object a6 = a5.context();
        a4 = arg_0 -> queryDispatcher.B(a4, (SerializedQuery)a5, (String)a6, arg_0);
        a3 = arg_0 -> queryDispatcher.B(a3, (String)a6, arg_0);
        QueryDispatcher queryDispatcher2 = queryDispatcher;
        queryDispatcher2.queryRate((String)a6).B();
        queryDispatcher2.a.computeIfAbsent(a6, string -> {
            void a2;
            QueryDispatcher queryDispatcher = this;
            Object a3 = new AtomicInteger();
            queryDispatcher.I.gauge((MetricName)BaseMetricName.s, Tags.of((String)"context", (String)a2), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        queryDispatcher.B((SerializedQuery)a5, (String)a6, (Authentication)a2, a4, a3);
    }

    /*
     * WARNING - void declaration
     */
    public void handleResponse(QueryResponse queryResponse, String string, String string2) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = a3.getRequestIdentifier();
        if ((a4 = queryDispatcher.B((String)a2, (String)a4)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a4.B(), (String)a2);
            long l2 = System.currentTimeMillis() - a4.B();
            if (a4.c()) {
                void a5;
                queryDispatcher.I.addEndToEndResponseTime(a4.B(), a4.F(), (String)a5, clientStreamIdentification.c(), a4.B(), l2);
            }
            if (a4.B((QueryResponse)a3, (String)a2) && a4.B()) {
                a4.B((String)a2);
                return;
            }
        } else {
            queryDispatcher.l.debug(RaftAdminGroup.B((Object)"\u0004mj*'m8gc\"#l,m8o+v#m$\",m8\"1\u007f"), (Object)a3.getRequestIdentifier());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(DefaultExecutionContext defaultExecutionContext, Consumer consumer, QueryResponse queryResponse) {
        void a2;
        void a3;
        QueryDispatcher a4 = queryResponse;
        QueryDispatcher a5 = this;
        a5.B((DefaultExecutionContext)a3, (QueryResponse)a4, (Consumer)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ActiveQuery B(String string, String string2) {
        Object a2 = string2;
        QueryDispatcher a3 = this;
        ActiveQuery activeQuery = (ActiveQuery)a3.j.get(a2);
        if (activeQuery == null) {
            void a4;
            a2 = (String)a2 + "/" + (String)a4;
            activeQuery = (ActiveQuery)a3.j.get(a2);
        }
        return activeQuery;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(String string, String string2, String string3, Consumer<QueryHandler> consumer) {
        void a2;
        void a3;
        Object a4 = string;
        QueryDispatcher a5 = this;
        a4 = new QueryDefinition((String)a4, (String)a3);
        if ((a4 = a5.C.find((QueryDefinition)a4, (String)a2)) != null) {
            void a6;
            a6.accept(a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(SerializedQuery serializedQuery, String string, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        Set set;
        QueryDispatcher a2;
        QueryDispatcher queryDispatcher;
        block5: {
            void a3;
            SerializedQuery serializedQuery2;
            void a4;
            Consumer<QueryResponse> consumer3;
            void a5;
            block4: {
                DefaultExecutionContext a6;
                void a7;
                queryDispatcher = this;
                a6 = new DefaultExecutionContext((String)a7, (Authentication)a6);
                consumer3 = arg_0 -> queryDispatcher.B(a6, (Consumer)a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher2 = queryDispatcher;
                    serializedQuery2 = queryDispatcher2.D.queryRequest((SerializedQuery)a4, (ExecutionContext)a6);
                    a2 = serializedQuery2.query();
                    set = queryDispatcher2.B((String)a7, (QueryRequest)a2);
                    if (!set.isEmpty()) break block4;
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.B((String)("No handler for query: " + a2.getQuery()))).build());
                    a3.accept(RestResponse.B((Object)".\u000e#\r\t\u0004\u000e\u0015"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a7;
                    objectArray[1] = a4.query().getQuery();
                    objectArray[2] = exception;
                    queryDispatcher.l.warn(RaftAdminGroup.B((Object)"y78jd+k&g.\">mjf#q:c>a\"\";w/p3\"1\u007f"), objectArray);
                    a2 = ErrorCode.fromException((Throwable)exception);
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(a2.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.B((String)StringUtils.getOrDefault((String)a2.getCode(), (String)exception.getClass().getName()))).build());
                    a3.accept(RestResponse.B((Object)"&\u0000\t\r\u0005\u0005"));
                    a6.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(a2.getMessageIdentifier(), serializedQuery2, true, consumer3, (Consumer)a3, set, queryDispatcher.B((QueryRequest)a2));
            if (queryDispatcher.j.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.B((String)RaftAdminGroup.B((Object)"\u001bw/p3\"=k>jjq?r:n#g.\"\u0003Fjc&p/c.{jr8g9g$v"))).build());
            a3.accept(RestResponse.B((Object)"%\u0015\u0011\f\b\u0003\u0000\u0014\u0004)\u0005"));
            return;
        }
        queryDispatcher.B(a2.getMessageIdentifier(), (ActiveQuery)set);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControlProxied(String string, String string2, long l2, String string3, String string4) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string2;
        QueryDispatcher a7 = this;
        a7.B((String)a5, (String)a6, (String)a4, arg_0 -> a7.B((String)a3, (String)a6, (long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Set<QueryHandler> B(String string, QueryRequest queryRequest) {
        void a2;
        QueryHandler queryHandler;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = ProcessingInstructionHelper.B((List)a3.getProcessingInstructionsList()) == 1 ? ((queryHandler = queryDispatcher.C.findOne((String)a2, (QueryRequest)a3)) == null ? Set.of() : Set.of(queryHandler)) : queryDispatcher.C.find((String)a2, (QueryRequest)a3);
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    public void cancelProxied(String string, String string2) {
        void a2;
        QueryDispatcher a3;
        Object a4 = string2;
        QueryDispatcher queryDispatcher = a3 = this;
        queryDispatcher.cancel(queryDispatcher.B((String)a2, (String)a4));
    }

    /*
     * WARNING - void declaration
     */
    public QueryDispatcher(QueryRegistrationCache queryRegistrationCache, NonReplacingConstraintCache<String, ActiveQuery> nonReplacingConstraintCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int n) {
        void a2;
        void clientIdRegistry2;
        void meterFactory2;
        void queryInterceptors2;
        void queryCache;
        void registrationCache;
        QueryDispatcher queryMetricsRegistry2;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryMetricsRegistry;
        QueryDispatcher queryDispatcher3 = queryMetricsRegistry2 = queryDispatcher;
        QueryDispatcher queryDispatcher4 = queryMetricsRegistry2;
        queryMetricsRegistry2.l = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher5 = queryMetricsRegistry2;
        queryMetricsRegistry2.a = new ConcurrentHashMap();
        queryDispatcher4.C = registrationCache;
        queryDispatcher4.I = queryDispatcher2;
        queryDispatcher3.j = queryCache;
        queryDispatcher3.D = queryInterceptors2;
        QueryDispatcher queryDispatcher6 = queryMetricsRegistry2;
        queryDispatcher3.k = new DispatchQueueMetrics((MeterFactory)meterFactory2, (MetricName)BaseMetricName.t, (MetricName)BaseMetricName.Z, (ClientIdRegistry)clientIdRegistry2);
        QueryDispatcher queryDispatcher7 = queryMetricsRegistry2;
        queryDispatcher6.h = new FlowControlQueues(Comparator.comparing(QueryInstruction::B).reversed(), (int)a2, (QueueMetrics)queryMetricsRegistry2.k, ErrorCode.TOO_MANY_REQUESTS);
        queryDispatcher2.gauge((MetricName)BaseMetricName.i, (Object)queryCache, ConstraintCache::size);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControl(String string, long l2) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.j.get(a2)) != null) {
            void a4;
            a2.B().forEach(arg_0 -> a3.B((ActiveQuery)a2, (long)a4, arg_0));
        }
    }

    private /* synthetic */ boolean B(QueryRequest queryRequest) {
        QueryDispatcher a2 = queryRequest;
        QueryDispatcher a3 = this;
        return ProcessingInstructionHelper.B((List)a2.getProcessingInstructionsList());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void c(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5 = queryHandler;
        QueryDispatcher a6 = this;
        void v0 = a4;
        a6.B((String)v0, a5.c(), () -> QueryDispatcher.B((QueryHandler)a5, (String)v0, (String)a3, (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(Consumer consumer, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryDispatcher a5 = this;
        a3.accept(a4);
        ((AtomicInteger)a5.a.get(a2)).decrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(Consumer consumer, SerializedQuery serializedQuery, String string, QueryResponse queryResponse) {
        void a2;
        QueryDispatcher a3;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryResponse;
        QueryDispatcher a4 = queryDispatcher;
        QueryDispatcher queryDispatcher3 = a3;
        a2.accept(queryDispatcher3);
        if (a4.B((QueryResponse)queryDispatcher3)) {
            void a5;
            void a6;
            a4.I.error(a6.query().getQuery(), (String)a5, a3.getErrorCode());
        }
    }

    public MeterFactory.RateMeter queryRate(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        return a3.I.rateMeter((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void B(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryHandler a5 = queryHandler;
        a5.B((String)a3, (String)a4, (long)a2);
    }

    public void cancel(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.j.remove(a2)) != null) {
            a2.c();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(ActiveQuery activeQuery, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        QueryDispatcher a4 = activeQuery;
        QueryDispatcher a5 = this;
        a5.c((QueryHandler)a3, a4.c(), a4.A(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(String string, ActiveQuery activeQuery) {
        void a2;
        QueryDispatcher queryDispatcher = this;
        try {
            queryDispatcher.l.trace(RaftAdminGroup.B((Object)"F#q:c>a\"k$ejs?g8{jy7,d,"), (Object)a2.c());
            a2.B();
            return;
        }
        catch (MessagingPlatformException a3) {
            void a4;
            QueryDispatcher queryDispatcher2 = queryDispatcher;
            queryDispatcher2.l.debug(RestResponse.B((Object)"%\u0013\u0012\u000e\u0012A\u0004\u0014\u0012\b\u000e\u0006@\u0005\t\u0012\u0010\u0000\u0014\u0002\b\b\u000e\u0006@\u000e\u0006A\u0011\u0014\u0005\u0013\u0019A\u001b\u001cNA#\u0000\u000e\u0002\u0005\r\f\b\u000e\u0006@\u0016\t\u0015\bA\u0005\u0013\u0012\u000e\u0012O"), (Object)a2.c(), (Object)a3);
            a2.B(a3.getErrorCode(), a3.getMessage());
            queryDispatcher2.j.remove((Object)a4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2, boolean bl) {
        void a22;
        void a3;
        void a4;
        void a322;
        QueryDispatcher queryDispatcher = this;
        void v0 = a322;
        QueryRequest queryRequest = v0.query();
        String string = v0.context();
        Object a5 = v0.clientStreamId();
        if ((string = queryDispatcher.C.find(string, queryRequest, (String)a5)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a5;
            objectArray[1] = queryRequest.getQuery();
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.B((String)String.format(RestResponse.B((Object)"#\r\t\u0004\u000e\u0015@D\u0013A\u000e\u000e\u0014A\u0006\u000e\u0015\u000f\u0004A\u0017\t\t\r\u0005A\u0010\u0013\u000f\u0002\u0005\u0012\u0013\b\u000e\u0006ZAE\u0012"), objectArray))).build());
            a3.accept(a5);
            return;
        }
        a5 = queryDispatcher.B(queryRequest.getMessageIdentifier(), a322.clientStreamId());
        ActiveQuery a22 = new ActiveQuery((String)a5, (SerializedQuery)a322, false, (Consumer)a4, (Consumer)a3, Collections.singleton(string), a22 != false && queryDispatcher.B(queryRequest));
        try {
            if (queryDispatcher.j.putIfAbsent(a5, (Object)a22) != null) {
                a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a322.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.B((String)RaftAdminGroup.B((Object)"\u001bw/p3\"=k>jjq?r:n#g.\"\u0003Fjc&p/c.{jr8g9g$v"))).build());
                a3.accept(RestResponse.B((Object)"%\u0015\u0011\f\b\u0003\u0000\u0014\u0004)\u0005"));
                return;
            }
            queryDispatcher.B((String)a5, a22);
            return;
        }
        catch (InsufficientBufferCapacityException a322) {
            a22.B(string.c(), ErrorCode.QUERY_DISPATCH_ERROR, a322.getMessage());
            return;
        }
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.h;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(DefaultExecutionContext defaultExecutionContext, QueryResponse queryResponse, Consumer<QueryResponse> consumer) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher queryDispatcher = this;
        try {
            a4.accept(queryDispatcher.D.queryResponse((QueryResponse)a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception a5) {
            queryDispatcher.l.warn(RaftAdminGroup.B((Object)"y78jG2a/r>k%ljk$\"8g9r%l9gjk$v/p)g:v%p"), (Object)a2.contextName(), (Object)a5);
            Exception exception = a5;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.B((String)exception.getMessage())).build());
            a2.compensate((Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        void a3;
        Object a4 = consumer2;
        QueryDispatcher a5 = this;
        a5.dispatchProxied((SerializedQuery)a3, (Consumer)a2, (Consumer)a4, true);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String B(String string, String string2) {
        void a2;
        Object a3 = string2;
        QueryDispatcher a4 = this;
        return (String)a2 + "/" + (String)a3;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(String string, String string2, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryHandler;
        QueryDispatcher a6 = queryDispatcher;
        a6.c((QueryHandler)a5, (String)a4, (String)a3, (long)a2);
    }

    private /* synthetic */ boolean B(QueryResponse queryResponse) {
        QueryDispatcher a2 = queryResponse;
        QueryDispatcher a3 = this;
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void completeWithError(String string, String string2, ErrorCode errorCode, String string3) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        QueryDispatcher a6 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = a5;
        objectArray[2] = a3.getCode();
        objectArray[3] = a2;
        a6.l.debug(RaftAdminGroup.B((Object)"A%o:n/v#l-\"=k>jjg8p%pjv\"gja%o'w$k)c>k%lju#v\"\"+\"9r/a#d#ajj+l.n/pjY)n#g$v\u0019v8g+o\u0003fwy7_f\",m8\">j/\";w/p3\"\u0011k.?1\u007f\u0017,jG8p%pja%f/8jy7,jG8p%p\u0007g9q+e/8jy7,"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.j.get(a5);
        if (activeQuery != null && activeQuery.B((String)a4, (ErrorCode)a3, (String)a2)) {
            a6.j.remove(a5);
        }
    }
}

