/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.plugin.LocalPluginEventHandler;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ClusterController e;
    private static final Logger K;
    private final RaftConfigServiceFactory M;
    private final ClusterTopology a;
    private static final Logger j;
    private final ApplicationEventPublisher h;
    private final ClusterTemplateController D;
    private final FeatureChecker C;
    public static final String I = "_none";
    private final DistributeLicenseService l;
    private final Predicate<String> k;

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.k = new ContextNameValidation();
        a9.e = a8;
        clusterRestController5.M = a7;
        clusterRestController5.C = a6;
        clusterRestController4.l = a5;
        clusterRestController4.h = a4;
        clusterRestController3.a = a3;
        clusterRestController3.D = a2;
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode B(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        j.info(LocalPluginEventHandler.B((Object)"RKtm)blA|UzD)^fTl\u0010mU}Q`\\z\u0010o_{\u0010rM'"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.e.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.e.isActive((String)object));
    }

    @GetMapping
    public List<JsonClusterNode> B(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        j.info(MeterFactory.B((Object)"\u0012J4lic,@<T:EiE&\u0011%X:Ei_&U,Bg"), (Object)AuditLog.username((Principal)object));
        return a2.e.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.e.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    static {
        j = AuditLog.getLogger();
        K = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void B(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        j.info(MeterFactory.B((Object)"j2L\u0014\u0011\u001bT8D,B=\u0011%X*T'B,\u0011<A-P=Tg"), (Object)AuditLog.username((Principal)a2));
        K.info(LocalPluginEventHandler.B((Object)"~lG)\\`Sl^zU)Ey\\fQmUm\u001c)@lBo_{]`^n\u0010eYjUgCl\u0010|@mQ}U'\u001e'"));
        try {
            void licenseFile;
            clusterRestController.l.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, MeterFactory.B((Object)"\u0007^i],P-T;\u0011/^;\u0011\u0016P-\\ _g\u0011\f_:D;TiE!P=\u0011=Y,\u0011\u0016P-\\ _iC,A%X*P=X&_iV;^<AiX:\u0011*C,P=T-\u0011+T/^;TiD9]&P-X'ViPi] R,_:Tg"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void B(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        j.info(LocalPluginEventHandler.B((Object)"RKtm)blA|UzD)Df\u0010mUeU}U)^fTl\u0010rM'"), (Object)AuditLog.username((Principal)a2), object);
        name.M.getRaftConfigService().deleteNode((String)object);
    }

    @PostMapping
    public ResponseEntity<RestResponse> B(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        j.info(MeterFactory.B((Object)"j2L\u0014\u0011\u001bT8D,B=\u0011=^i[&X'\u0011*]<B=T;\u0011(EiJ4\u000b2Lg"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.e.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, LocalPluginEventHandler.B((Object)"JQg^fD)Sf]kYgU)ZfYgYgW)Sf^}UqD)G`Da\u0010g_J_gDlH}C'"));
            }
            if (!RaftAdminGroup.B((String)string) && !jsonClusterNode.k.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            K.debug(MeterFactory.B((Object)"P-Ua\u0018s\u0011\u001bT.X:E,C _.\u0011$H:T%WiP'UiP-U _.\u0011$TiE&\u0011*^'E,I=\u0011kJ4\u0013g"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            K.debug(LocalPluginEventHandler.B((Object)"hTm\u0018 \n)blW`C}U{YgW)]pCl\\o\u0010h^m\u0010hTmYgW)]l\u0010}_)^f\u0010j_gDlH}C'"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            K.debug(MeterFactory.B((Object)"P-Ua\u0018s\u0011\u001bT.X:E,C _.\u0011$H:T%WiP'UiP-U _.\u0011$TiE&\u0011(]%\u0011*^'E,I=Bg"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.e.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, LocalPluginEventHandler.B((Object)"~fTl\u0010h\\{UhTp\u0010{UnYzDlBlT)Yg\u0010h\u0010j\\|C}U{")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.M.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.h.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, MeterFactory.B((Object)"p*R,A=T-\u0011#^ _iC,@<T:Ee\u0011$P0\u0011=P\"TiPiF!X%TiE&\u00119C&R,B:")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void B(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        j.info(LocalPluginEventHandler.B((Object)"RKtm)blA|UzD)SeEzDlB)Dl]y\\hDl\u0010m_~^e_hT'"), (Object)AuditLog.username((Principal)object));
        if (a2.a.isAdminNode()) {
            ServletOutputStream resp;
            object = MeterFactory.B((Object)"R%D:E,CdE,\\9](E,\u001f0\\%");
            String string = a2.D.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(LocalPluginEventHandler.B((Object)"}UqD&@eQ`^2\u0010jXhBzU}\r|Do\u001d1"));
            v1.addHeader(MeterFactory.B((Object)"\n^'E,_=\u001c\rX:A&B E ^'"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(LocalPluginEventHandler.B((Object)"P_|\u0010jQg\u0010|Cl\u0010}X`C)V|^jD`_gQeY}I)_g\\p\u0010oBf])Qm]`^)^fTl"));
    }
}

