/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBProperties;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginConfigurationSerializer;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final boolean h;
    private final Logger D;
    private final FeatureChecker C;
    public static final String I = "Plugins disabled";
    private static final Logger l = AuditLog.getLogger();
    private final PluginController k;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void B(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.h || !configurationJSON.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        l.info(EmbeddedDBProperties.B((Object)"N,h\n5\u0005p&`2f#5#zw`'q6a254z9s>r\"g6a>z958swn*:,hy5"), objectArray);
        configurationJSON.k.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey B(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.h || !a2.C.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
            }
            l.info(PluginConfigurationSerializer.B((Object)"t+R\r\u000f\u0002J!Z5\\$\u000f$@pF>\\$N<Cp_<Z7F>\u000f+R~\u000f"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.B(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.k.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    private /* synthetic */ String B(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, EmbeddedDBProperties.B((Object)"\u0019zwe;`0|95't4~6r25'g8c>q2q"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, PluginConfigurationSerializer.B((Object)"i9C5A1B5\u000f#G?Z<KpA?[pL?A$N9ApK9]5L$@\"Vp\\5_1]1[?]"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void B(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.h || !context.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        l.info(EmbeddedDBProperties.B((Object)"N,h\n5\u0005p&`2f#5#zw`9g2r>f#p%5'y\"r>{wn*:,hws8gwv8{#p/awn*;"), objectArray);
        context.k.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> B(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.h || !pluginsRestController.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        l.info(PluginConfigurationSerializer.B((Object)"t+R\r\u000f\u0002J!Z5\\$\u000f6@\"\u000f3@>I9H%]1[9@>\u000f?IpT-\u0000+R~\u000f"), objectArray);
        try {
            void context;
            return pluginsRestController.k.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.D.warn(EmbeddedDBProperties.B((Object)"S6|;p35#zwg2a%|2c25'g8e2g#|2fws8gwn*/,h"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void B(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.h || !active.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? EmbeddedDBProperties.B((Object)"f#t%a") : PluginConfigurationSerializer.B((Object)"#[?_");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        l.info(PluginConfigurationSerializer.B((Object)"t+R\r\u000f\u0002J!Z5\\$\u000f$@pT-\u000f C%H9ApT-\u0000+R~\u000f"), objectArray);
        active.k.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.D = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.h = a3.isPluginsEnabled();
        pluginsRestController.k = a2;
        pluginsRestController.C = a5;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void B(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        l.info(EmbeddedDBProperties.B((Object)"\fn*HwG2d\"p$awa85\"{>{$a6y;5'y\"r>{wn*:,hy5"), objectArray);
        version.k.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    @GetMapping
    public Iterable<PluginInfo> B(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        l.info(PluginConfigurationSerializer.B((Object)"\u000bT-rp}5^%J#[p[?\u000f<F#[pL%]\"J>[p_<Z7F>\\~\u000f"), (Object)AuditLog.username((Principal)object));
        return a2.k.listPlugins();
    }
}

