/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.EventProcessorRestController;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.axoniq.axonserver.transport.rest.b;
import io.axoniq.axonserver.util.TimeLimitedCache;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private final RoleController C;
    private final UserAdminService I;
    private static final Logger l = LoggerFactory.getLogger(UserRestController.class);
    private static final Logger k = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    public UserRestController(UserAdminService userAdminService, RoleController roleController) {
        void a2;
        UserRestController a3;
        UserRestController a4 = roleController;
        UserRestController userRestController = a3 = this;
        userRestController.I = a2;
        userRestController.C = a4;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"public/users"})
    public List<UserJson> B(@Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = this;
        try {
            return userRestController.I.users((Authentication)new PrincipalAuthentication((Principal)a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            l.info(EventProcessorRestController.B((Object)"fZ@|\u001dmTRI\u0001HRXSN\u0001[@TMXE\u001d\f\u001dZ@"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"users"})
    public void B(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = userRestController2;
        UserRestController userRestController2 = userJson;
        UserRestController userJson2 = userRestController;
        if (a2 != null && userRestController2.userName.equals(a2.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, TimeLimitedCache.B((Object)"*\u001d\u0010R\u0005\u001e\b\u001d\u0013\u0017\u0000R\u0010\u001dD\u0011\f\u0013\n\u0015\u0001R\u001d\u001d\u0011\u0000D\u001d\u0013\u001cD\u0011\u0016\u0017\u0000\u0017\n\u0006\r\u0013\b\u0001"));
        }
        Set<Object> set = new HashSet();
        if (userRestController2.roles != null) {
            set = Arrays.stream(userRestController2.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserRestController userRestController3 = userRestController2;
        userJson2.I.createOrUpdateUser(userRestController3.userName, userRestController3.password, set.stream().map(adminUserRole -> {
            UserRestController a2 = adminUserRole;
            UserRestController a3 = this;
            return new b(a3, (AdminUserRole)a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication((Principal)a2));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"users/{name}"})
    public void B(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        void name;
        UserRestController userRestController = this;
        try {
            userRestController.I.deleteUser((String)name, (Authentication)new PrincipalAuthentication((Principal)a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            k.error(TimeLimitedCache.B((Object)")\u001f\u000f9R \u0017\b\u0017\u0010\u0017D\u0007\u0017\u0017\u0016R\u001f\u000fD\u0014\u0005\u001b\b\u0017\u0000RIR\u001f\u000f"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }
}

