/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.CommandHandler;
import io.axoniq.axonserver.configuration.runtime.CommandHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminCommandHandlerLogConsumer;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Command Handlers", description="Operations to manage command handlers for integration endpoints")
public class IntegrationCommandHandlerControllerV2 {
    private static final Logger D;
    private final RaftGroupServiceFactory C;
    private static final Integer I;
    private final ObjectMapper l;
    private final CommandHandlers k;

    private static /* synthetic */ ResponseEntity c(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Update a command handler", description="Update an existing command handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Updated command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)handlerId);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.B((String)integrationCommandHandlerControllerV22.name(), (String)ObjectUtils.B((Object)"FjEn"));
            ValidationUtils.B((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)IndexEntry.B((Object)"G\u000fD\u000b"));
            ValidationUtils.B((String)object.commandUrl(), (int)2000, (String)ObjectUtils.B((Object)"KdEfIeL^Zg"));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, IndexEntry.B((Object)"\"F\u000fMNO\u000fJ\u001aF\u001c\t\u0003\\\u001d]NK\u000b\t^\t\u0001[NE\u000f[\tL\u001c"));
            }
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (D.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                D.info(ObjectUtils.B((Object)"PSvu+znY~Mx\\+\\d\b~XoI\u007fM+KdEfIeL+@jFoDnZ+Sv\bbF+MeL{GbF\u007f\bpU%"), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), I, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.l.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.B((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ResponseEntity.created((URI)URIUtils.B((StringBuffer)a3.getRequestURL(), (String)a2.getId())).body((Object)new IntegrationAPI.Id(a2.getId()));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Delete a command handler", description="Remove a command handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Deletion request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> B(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = principal;
        IntegrationCommandHandlerControllerV2 principal2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)handlerId);
            object = (Principal)ObjectUtils.B((Object)object, (Object)GrpcContextAuthenticationProvider.I);
            if (D.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                D.info(ObjectUtils.B((Object)"PSvu+znY~Mx\\+\\d\boMgM\u007fM+KdEfIeL+@jFoDnZ+Sv\bbF+MeL{GbF\u007f\bpU%"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.c((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)this2));
        }
    }

    static {
        I = 100;
        D = AuditLog.getLogger();
    }

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints/{endpoint}/commandHandlers"})
    @Operation(summary="Register a command handler", description="Register a new command handler for a specific endpoint. Command handlers process commands sent to the endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Command handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", requiredMode=Schema.RequiredMode.REQUIRED, example="default") String string2) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.B((String)integrationCommandHandlerControllerV22.name(), (String)IndexEntry.B((Object)"g\u000fD\u000b"));
            ValidationUtils.B((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)ObjectUtils.B((Object)"FjEn"));
            ValidationUtils.B((String)integrationCommandHandlerControllerV22.commandUrl(), (int)2000, (String)IndexEntry.B((Object)"J\u0001D\u0003H\u0000M;[\u0002"));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, ObjectUtils.B((Object)"GGjL+NjK\u007fGy\bf]x\\+Jn\b;\bdZ+DjZlMy"));
            }
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (D.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                D.info(IndexEntry.B((Object)"5R\u0013tN{\u000bX\u001bL\u001d]N]\u0001\t\u001cL\t@\u001d]\u000b[NJ\u0001D\u0003H\u0000MNA\u000fG\nE\u000b[NR\u0013\t\u0007GNL\u0000M\u001eF\u0007G\u001a\t\u0015T@"), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), I, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.l.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.B((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationCommandHandlerControllerV2(ObjectMapper objectMapper, CommandHandlers commandHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationCommandHandlerControllerV2 a4;
        IntegrationCommandHandlerControllerV2 a5 = raftGroupServiceFactory;
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = a4 = this;
        a4.l = a3;
        integrationCommandHandlerControllerV2.k = a2;
        integrationCommandHandlerControllerV2.C = a5;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.CommandHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> B(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) @RequestParam(value="context") String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = string2;
        IntegrationCommandHandlerControllerV2 handlerId = integrationCommandHandlerControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)object);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (D.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                D.info(IndexEntry.B((Object)"r\u0015T3\t<L\u001f\\\u000bZ\u001a\t\u001aFNN\u000b]NJ\u0001D\u0003H\u0000MNA\u000fG\nE\u000b[NR\u0013\t\u0007GNL\u0000M\u001eF\u0007G\u001a\t\u0015T@"), objectArray);
            }
            if (!(object = (CommandHandler)handlerId.k.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, IndexEntry.B((Object)"&H\u0000M\u0002L\u001c\t\u0000F\u001a\t\bF\u001bG\n")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, ObjectUtils.B((Object)"CIeLgMy\beG\u007f\bmG~Fo\bbF+MeL{GbF\u007f"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, IndexEntry.B((Object)"a\u000fG\nE\u000b[NG\u0001]NO\u0001\\\u0000MN@\u0000\t\rF\u0000]\u000bQ\u001a"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.CommandHandler(object.getName(), Integer.valueOf(object.getLoadFactor()), object.getCommandUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.B((Throwable)principal2);
        }
    }
}

