/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.admin.AdminEndpoint;
import io.axoniq.axonserver.configuration.admin.AdminEndpoints;
import io.axoniq.axonserver.configuration.runtime.Endpoint;
import io.axoniq.axonserver.configuration.runtime.Endpoints;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.EndpointLogMessage;
import io.axoniq.axonserver.integration.EndpointFactory;
import io.axoniq.axonserver.integration.WrappingTypes;
import io.axoniq.axonserver.integration.logconsumer.AdminEndpointLogConsumer;
import io.axoniq.axonserver.integration.logconsumer.AdminPatchEndpointLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.MapCodec;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Endpoints", description="Operations for managing integration endpoints")
public class IntegrationEndpointRestControllerV2 {
    private final Map<UUID, Set<String>> a;
    private static final Logger j = AuditLog.getLogger();
    private final VisibleContexts h;
    private final RaftGroupServiceFactory D;
    private final AdminEndpoints C;
    private final Endpoints I;
    private final ObjectMapper l;
    private final EndpointFactory k;

    @GetMapping(value={"v2/wrappingTypes"})
    @Operation(summary="Get available wrapping types", description="Retrieves all available wrapping types that can be used when creating an integration endpoint")
    @ApiResponse(responseCode="200", description="List of wrapping types retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(type="string")))})
    public List<String> B() {
        return List.of(WrappingTypes.I.B(), WrappingTypes.k.B());
    }

    private static /* synthetic */ boolean B(Set set, AdminEndpoint adminEndpoint) {
        Set a2 = adminEndpoint;
        Set a3 = set;
        return a3.contains(a2.getContext());
    }

    @GetMapping(value={"v2/endpointTypes"})
    @Operation(summary="Get available endpoint types", description="Retrieves all available endpoint types that can be used when creating an integration endpoint")
    @ApiResponse(responseCode="200", description="List of endpoint types retrieved successfully", content={@Content(schema=@Schema(implementation=Set.class))})
    public Set<IntegrationAPI.EndpointType> c() {
        IntegrationEndpointRestControllerV2 a2;
        return a2.k.types();
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Update an endpoint", description="Updates an existing integration endpoint with the provided configuration")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Updated endpoint configuration", implementation=IntegrationAPI.Endpoint.class) IntegrationAPI.Endpoint endpoint, @PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = endpoint;
        IntegrationEndpointRestControllerV2 endpoint2 = integrationEndpointRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpointId;
            ValidationUtils.B((String)endpointId);
            endpoint2.B((IntegrationAPI.Endpoint)object);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (j.isInfoEnabled()) {
                j.info(AccessControlConfiguration.B((Object)"W7q\u0011,\u001ei=y)\u007f8,8cly<h-x),)b(|#e\"xlw1\""), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object.name()));
            }
            IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpoint2;
            object = integrationEndpointRestControllerV22.l.writeValueAsString(object);
            object = EndpointLogMessage.newBuilder().setId((String)endpointId).setData((String)object).setContext((String)a2).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationEndpointRestControllerV22.D.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.B((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    @GetMapping(value={"v2/endpoints"})
    @Transactional(readOnly=true)
    @Operation(summary="List all endpoints", description="Retrieves all integration endpoints with their handlers and connection status")
    @ApiResponse(responseCode="200", description="List of endpoints retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.EndpointOverview.class)))})
    public List<IntegrationAPI.EndpointOverview> c(@Parameter(hidden=true) Principal principal) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 a2 = integrationEndpointRestControllerV2;
        object = new PrincipalAuthentication((Principal)ObjectUtils.B((Object)object, (Object)GrpcContextAuthenticationProvider.I));
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = a2;
        object = integrationEndpointRestControllerV22.h.visibleContexts(false, (Authentication)object);
        return integrationEndpointRestControllerV22.C.findAll().stream().filter(arg_0 -> IntegrationEndpointRestControllerV2.B((Set)object, arg_0)).map(adminEndpoint -> {
            IntegrationEndpointRestControllerV2 a3 = adminEndpoint;
            IntegrationEndpointRestControllerV2 a4 = this;
            return new IntegrationAPI.EndpointOverview(a3.getContext(), a3.getId().toString(), a3.getName(), a3.getType(), a3.getBaseUrl(), a3.getCommandUrl(), a3.getQueryUrl(), a3.getEventUrl(), a3.getHealthUrl(), a3.getWrappingType(), a3.getContentType(), a3.isActive(), a3.getMetaData(), a3.getCommandHandlers().stream().map(a2 -> new IntegrationAPI.CommandHandlerOverview(a2.getId().toString(), a2.getName(), a2.getLoadFactor(), a2.getCommandUrl())).toList(), a3.getEventHandlers().stream().map(a2 -> new IntegrationAPI.EventHandlerOverview(a2.getId().toString(), a2.getName(), a2.getBatchSize(), a2.getFilter(), a2.getSequencingPolicy(), a2.getSequencingPolicyParameters(), a2.getEventUrl())).toList(), a3.getQueryHandlers().stream().map(a2 -> new IntegrationAPI.QueryHandlerOverview(a2.getId().toString(), a2.getName(), a2.getQueryUrl())).toList(), a4.a.getOrDefault(a3.getId(), Collections.emptySet()).size());
        }).toList();
    }

    private static /* synthetic */ ResponseEntity c(HttpServletRequest httpServletRequest, EndpointLogMessage endpointLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = endpointLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PatchMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Change endpoint active state", description="Activates or deactivates an integration endpoint. When deactivated, the endpoint will not process messages.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="State change request accepted"), @ApiResponse(responseCode="400", description="Invalid endpoint ID format"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> B(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="active") @Schema(description="Activation state: true to activate, false to deactivate") boolean bl, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        void var1_3;
        void this_2 = var1_3;
        IntegrationEndpointRestControllerV2 endpointId = this;
        try {
            void request;
            void a2;
            void active;
            Principal principal2;
            ValidationUtils.B((String)this_2);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (j.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = active != false ? AccessControlConfiguration.B((Object)">i?y!i") : PluginConfigurationJSON.B((Object)"ddavq");
                objectArray[2] = StringUtils.sanitize((String)this_2);
                j.info(PluginConfigurationJSON.B((Object)"O~iX4Wqta`gq4q{%ox4`zadj}k`%ox:"), objectArray);
            }
            EndpointLogMessage this_2 = EndpointLogMessage.newBuilder().setId((String)this_2).setData(String.valueOf((boolean)active)).setContext((String)a2).setAction(Action.UPDATE).build();
            return ((CompletableFuture)endpointId.D.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminPatchEndpointLogConsumer.class.getSimpleName(), this_2.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.B((HttpServletRequest)request, this_2, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (MessagingPlatformException principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    private /* synthetic */ Set<String> B() {
        IntegrationEndpointRestControllerV2 a2;
        return a2.k.typeNames();
    }

    @EventListener
    public void B(TopologyEvents.EndpointDisconnected endpointDisconnected) {
        IntegrationEndpointRestControllerV2 a2 = endpointDisconnected;
        IntegrationEndpointRestControllerV2 a3 = this;
        a3.a.getOrDefault(a2.B(), Collections.emptySet()).remove(a2.B());
    }

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, EndpointLogMessage endpointLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = endpointLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Delete an endpoint", description="Removes an integration endpoint and all its associated handlers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Endpoint successfully deleted"), @ApiResponse(responseCode="400", description="Invalid endpoint ID format"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> B(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 principal2 = integrationEndpointRestControllerV2;
        try {
            void a3;
            EndpointLogMessage endpointId;
            ValidationUtils.B((String)endpointId);
            object = (Principal)ObjectUtils.B((Object)object, (Object)GrpcContextAuthenticationProvider.I);
            if (j.isInfoEnabled()) {
                j.info(AccessControlConfiguration.B((Object)"W7q\u0011,\u001ei=y)\u007f8,8clh)`)x),)b(|#e\"xlw1\""), (Object)AuditLog.username((String)object.getName()), (Object)StringUtils.sanitize((String)endpointId));
            }
            endpointId = EndpointLogMessage.newBuilder().setId((String)endpointId).setContext((String)a3).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.D.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), endpointId.toByteArray()).thenApply(a2 -> ValidationUtils.B())).exceptionally(ValidationUtils::B);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpointId}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.Endpoint.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> B(@PathVariable(value="endpointId") String string, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = string;
        IntegrationEndpointRestControllerV2 endpointId = integrationEndpointRestControllerV2;
        try {
            void a2;
            Principal principal2;
            ValidationUtils.B((String)object);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (j.isInfoEnabled()) {
                j.info(AccessControlConfiguration.B((Object)"\u0017w1Ql^)}9i?xlx#,)b(|#e\"xlw1\""), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object));
            }
            if (!(object = (Endpoint)endpointId.I.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, AccessControlConfiguration.B((Object)"\tb(|#e\"xlb#xlj#y\"h")))).getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, PluginConfigurationJSON.B((Object)"Qkpu{lzq4k{q4c{pza4lz%wjzqq}`"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.Endpoint(object.getName(), object.getType(), object.getBaseUrl(), object.getCommandUrl(), object.getQueryUrl(), object.getEventUrl(), object.getHealthUrl(), object.getWrappingType(), object.getContentType(), object.getMetaData()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.B((Throwable)principal2);
        }
    }

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3);
    }

    @GetMapping(value={"internal/raft/endpoints"})
    @Transactional(readOnly=true)
    @Operation(summary="List internal endpoints", description="Internal API to list all endpoints for Raft synchronization (not for public use)")
    @ApiResponse(responseCode="200", description="List of internal endpoints retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.EndpointOverview.class)))})
    public List<IntegrationAPI.EndpointOverview> B(@Parameter(hidden=true) Principal principal) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 a2 = integrationEndpointRestControllerV2;
        object = new PrincipalAuthentication((Principal)ObjectUtils.B((Object)object, (Object)GrpcContextAuthenticationProvider.I));
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = a2;
        object = integrationEndpointRestControllerV22.h.visibleContexts(false, (Authentication)object);
        return integrationEndpointRestControllerV22.I.findAll().stream().filter(arg_0 -> IntegrationEndpointRestControllerV2.B((Set)object, arg_0)).map(endpoint -> {
            IntegrationEndpointRestControllerV2 a2 = endpoint;
            IntegrationEndpointRestControllerV2 a3 = this;
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            LinkedList linkedList3 = new LinkedList();
            a2.getCommandHandlers().forEach(commandHandler -> {
                List a2 = commandHandler;
                List a3 = linkedList;
                a3.add(new IntegrationAPI.CommandHandlerOverview(a2.getId().toString(), a2.getName(), a2.getLoadFactor(), a2.getCommandUrl()));
            });
            a2.getEventHandlers().forEach(eventHandler -> {
                List a2 = eventHandler;
                List a3 = linkedList2;
                a3.add(new IntegrationAPI.EventHandlerOverview(a2.getId().toString(), a2.getName(), a2.getBatchSize(), a2.getFilter(), a2.getSequencingPolicy(), a2.getSequencingPolicyParameters(), a2.getEventUrl()));
            });
            a2.getQueryHandlers().forEach(queryHandler -> {
                List a2 = queryHandler;
                List a3 = linkedList3;
                a3.add(new IntegrationAPI.QueryHandlerOverview(a2.getId().toString(), a2.getName(), a2.getQueryUrl()));
            });
            return new IntegrationAPI.EndpointOverview(a2.getContext(), a2.getId().toString(), a2.getName(), a2.getType(), a2.getBaseUrl(), a2.getCommandUrl(), a2.getQueryUrl(), a2.getEventUrl(), a2.getHealthUrl(), a2.getWrappingType(), a2.getContentType(), a2.isActive(), a2.getMetaData(), linkedList, linkedList2, linkedList3, a3.a.getOrDefault(a2.getId(), Collections.emptySet()).size());
        }).toList();
    }

    @EventListener
    public void B(TopologyEvents.EndpointConnected endpointConnected) {
        IntegrationEndpointRestControllerV2 a3 = endpointConnected;
        IntegrationEndpointRestControllerV2 a4 = this;
        a4.a.computeIfAbsent(a3.B(), a2 -> new CopyOnWriteArraySet()).add(a3.F());
    }

    private /* synthetic */ void B(IntegrationAPI.Endpoint endpoint) {
        IntegrationEndpointRestControllerV2 a2 = endpoint;
        IntegrationEndpointRestControllerV2 a3 = this;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = a2;
        ValidationUtils.B((String)integrationEndpointRestControllerV2.name(), (String)PluginConfigurationJSON.B((Object)"kuhq"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.baseUrl(), (String)AccessControlConfiguration.B((Object)"n-\u007f)Y>`"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.type(), (String)"type");
        ValidationUtils.B((String)integrationEndpointRestControllerV2.wrappingType(), (String)PluginConfigurationJSON.B((Object)"rfddu}ksQmuq"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.contentType(), (String)AccessControlConfiguration.B((Object)"o#b8i\"x\u0018u<i"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.type(), (String)"type", (Collection)a3.B());
        ValidationUtils.B((String)integrationEndpointRestControllerV2.wrappingType(), (String)PluginConfigurationJSON.B((Object)"rfddu}ksQmuq"), (Collection)a3.B());
        ValidationUtils.c((String)integrationEndpointRestControllerV2.contentType(), (String)AccessControlConfiguration.B((Object)"o#b8i\"x\u0018u<i"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.name(), (int)200, (String)PluginConfigurationJSON.B((Object)"kuhq"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.baseUrl(), (int)2000, (String)AccessControlConfiguration.B((Object)"n-\u007f)Y>`"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.healthUrl(), (int)2000, (String)PluginConfigurationJSON.B((Object)"|`ui`mAwx"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.commandUrl(), (int)2000, (String)AccessControlConfiguration.B((Object)"/c!a-b(Y>`"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.queryUrl(), (int)2000, (String)PluginConfigurationJSON.B((Object)"ta`f|Awx"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.eventUrl(), (int)2000, (String)AccessControlConfiguration.B((Object)")z)b8Y>`"));
        ValidationUtils.B((String)integrationEndpointRestControllerV2.contentType(), (int)200, (String)PluginConfigurationJSON.B((Object)"wjzqqk`Qmuq"));
        ValidationUtils.B((String)MapCodec.encode((Map)integrationEndpointRestControllerV2.metaData()), (int)4000, (String)"metaData");
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints"})
    @Operation(summary="Register a new endpoint", description="Creates a new integration endpoint with the provided configuration")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Endpoint successfully created"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Endpoint configuration details", implementation=IntegrationAPI.Endpoint.class) IntegrationAPI.Endpoint endpoint, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = endpoint;
        IntegrationEndpointRestControllerV2 endpoint2 = integrationEndpointRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            endpoint2.B((IntegrationAPI.Endpoint)object);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (j.isInfoEnabled()) {
                j.info(PluginConfigurationJSON.B((Object)"O~iX4Wqta`gq4q{%f`slgqqw4`zadj}k`%ox:"), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object.name()));
            }
            IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpoint2;
            object = integrationEndpointRestControllerV22.l.writeValueAsString(object);
            object = EndpointLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationEndpointRestControllerV22.D.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.c((HttpServletRequest)request, (EndpointLogMessage)object, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationEndpointRestControllerV2(ObjectMapper objectMapper, RaftGroupServiceFactory raftGroupServiceFactory, AdminEndpoints adminEndpoints, Endpoints endpoints, VisibleContexts visibleContexts, EndpointFactory endpointFactory) {
        IntegrationEndpointRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        IntegrationEndpointRestControllerV2 a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = integrationEndpointRestControllerV22;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpointFactory;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV23 = a8 = integrationEndpointRestControllerV2;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV24 = a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV25 = a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV26 = a8;
        integrationEndpointRestControllerV26.a = new ConcurrentHashMap();
        integrationEndpointRestControllerV25.l = a7;
        integrationEndpointRestControllerV25.D = a6;
        integrationEndpointRestControllerV24.C = a5;
        integrationEndpointRestControllerV24.I = a4;
        integrationEndpointRestControllerV23.h = a3;
        integrationEndpointRestControllerV23.k = a2;
    }

    private static /* synthetic */ boolean B(Set set, Endpoint endpoint) {
        Set a2 = endpoint;
        Set a3 = set;
        return a3.contains(a2.getContext());
    }
}

