/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.component.processor.EventProcessorResultListener;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.EventHandler;
import io.axoniq.axonserver.configuration.runtime.EventHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.eventstore.EventStoreTokenSupplier;
import io.axoniq.axonserver.eventstore.EventSupplier;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminEventHandlerLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import io.axoniq.axonserver.streams.SequencingPolicyDefinition;
import io.axoniq.axonserver.streams.cluster.DefaultSequencingPolicyDefinition;
import io.axoniq.axonserver.streams.sequencing.SequencingPolicy;
import io.axoniq.axonserver.streams.sequencing.SequencingPolicyProvider;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.LambdaMetafactory;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Event Handlers", description="API endpoints for managing integration event handlers")
public class IntegrationEventHandlerRestControllerV2 {
    private final RaftGroupServiceFactory j;
    private final EventSupplier h;
    private final EventHandlers D;
    private final EventStoreTokenSupplier C;
    private final ObjectMapper I;
    private final SequencingPolicyProvider l;
    private static final Logger k = AuditLog.getLogger();

    private /* synthetic */ void B(String string, String string2) {
        SequencingPolicy a22;
        String a32 = string2;
        IntegrationEventHandlerRestControllerV2 a4 = this;
        if (a22 != null) {
            String[] stringArray = StringUtils.isEmpty((String)a32) ? new String[]{} : a32.split(ShowDetail.B((Object)"\r"));
            int n = a32 = 0;
            while (n < stringArray.length) {
                stringArray[++a32] = stringArray[a32].trim();
                n = a32;
            }
            List<String> a32 = Arrays.asList(stringArray);
            a22 = a4.l.get((SequencingPolicyDefinition)new DefaultSequencingPolicyDefinition((String)a22, a32));
            try {
                Integer[] integerArray = new Integer[1];
                integerArray[0] = 0;
                a22.sequencer(a32, 0, integerArray);
                return;
            }
            catch (Exception a22) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, "sequencingPolicy: " + a22.getMessage());
            }
        }
    }

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete an event handler", description="Removes an event handler from an integration endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Event handler successfully deleted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Event handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @DeleteMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> B(@Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(description="UUID of the event handler to delete", required=true) @PathVariable(value="handler") @Schema(description="Event handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = principal;
        IntegrationEventHandlerRestControllerV2 principal2 = integrationEventHandlerRestControllerV2;
        try {
            void a3;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)handlerId);
            object = (Principal)ObjectUtils.B((Object)object, (Object)GrpcContextAuthenticationProvider.I);
            if (k.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                k.info(ShowDetail.B((Object)"z\n\\,\u0001#D\u0000T\u0014R\u0005\u0001\u0005NQE\u0014M\u0014U\u0014\u0001\u0014W\u0014O\u0005\u0001\u0019@\u001fE\u001dD\u0003\u0001\n\\QH\u001f\u0001\u0014O\u0015Q\u001eH\u001fUQZ\f\u000f"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a3).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.j.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(a2 -> ValidationUtils.B())).exceptionally(ValidationUtils::B);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.EventHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> B(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = string2;
        IntegrationEventHandlerRestControllerV2 handlerId = integrationEventHandlerRestControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)object);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (k.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                k.info(EventProcessorResultListener.B((Object)"6U\u0010sM|\b_\u0018K\u001eZMZ\u0002\u000e\nK\u0019\u000e\bX\b@\u0019\u000e\u0005O\u0003J\u0001K\u001f\u000e\u0016SMG\u0003\u000e\b@\t^\u0002G\u0003ZMU\u0010\u0000"), objectArray);
            }
            if (!(object = (EventHandler)handlerId.D.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, EventProcessorResultListener.B((Object)"f\f@\tB\b\\M@\u0002ZMH\u0002[\u0003J")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, ShowDetail.B((Object)"i\u0010O\u0015M\u0014SQO\u001eUQG\u001eT\u001fEQH\u001f\u0001\u0014O\u0015Q\u001eH\u001fU"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, EventProcessorResultListener.B((Object)"%O\u0003J\u0001K\u001f\u000e\u0003A\u0019\u000e\u000bA\u0018@\t\u000e\u0004@MM\u0002@\u0019K\u0015Z"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.EventHandler(object.getName(), object.getBatchSize(), object.getFilter(), object.getSequencingPolicy(), object.getSequencingPolicyParameters(), object.getSegments(), "", object.getEventUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.B((Throwable)principal2);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Register a new event handler", description="Registers a new event handler for an integration endpoint. The handler will process events according to the specified sequencing policy.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Event handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class))}), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @PostMapping(value={"v2/endpoints/{endpoint}/eventHandlers"})
    public CompletableFuture<ResponseEntity<Object>> B(@Parameter(description="Event handler configuration") @RequestBody @Schema(description="Event handler configuration details") IntegrationAPI.EventHandler var1_1, @Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String var2_2, @Parameter(hidden=true) Principal var3_3, @Parameter(hidden=true) HttpServletRequest var4_4, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String var5_5) {
        block8: {
            block7: {
                v0 = this /* !! */ ;
                this /* !! */  = var1_1;
                eventHandler = v0;
                ValidationUtils.B((String)endpoint);
                v1 = this /* !! */ ;
                eventHandler.B((IntegrationAPI.EventHandler)v1);
                if (v1.startPosition() != null && !this /* !! */ .startPosition().isEmpty() && !this /* !! */ .startPosition().equalsIgnoreCase(EventProcessorResultListener.B((Object)"9o$b"))) break block7;
                var6_6 = eventHandler.C.firstToken((String)a);
                this /* !! */  = this /* !! */ .withStartPosition((Long)var6_6);
                v2 = principal;
                ** GOTO lbl25
            }
            if (!this /* !! */ .startPosition().equalsIgnoreCase(ShowDetail.B((Object)"9d0e"))) break block8;
            var6_6 = eventHandler.C.lastToken((String)a);
            this /* !! */  = this /* !! */ .withStartPosition((Long)var6_6);
            v2 = principal;
            ** GOTO lbl25
        }
        if (Long.parseLong(this /* !! */ .startPosition()) >= 0L) ** GOTO lbl-1000
        throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, EventProcessorResultListener.B((Object)"]\u0019O\u001fZ=A\u001eG\u0019G\u0002@MC\u0018]\u0019\u000e\u000fKM\u001eMA\u001f\u000e\u0001O\u001fI\b\\"));
        {
            catch (Exception var6_8) {
                return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)var6_8));
            }
lbl-1000:
            // 1 sources

            {
                v2 = principal;
lbl25:
                // 3 sources

                var6_6 = (Principal)ObjectUtils.B((Object)v2, (Object)GrpcContextAuthenticationProvider.I);
                if (IntegrationEventHandlerRestControllerV2.k.isInfoEnabled()) {
                    v3 = new Object[3];
                    v3[0] = AuditLog.username((String)var6_6.getName());
                    v3[1] = StringUtils.sanitize((String)this /* !! */ .name());
                    v3[2] = StringUtils.sanitize((String)endpoint);
                    IntegrationEventHandlerRestControllerV2.k.info(EventProcessorResultListener.B((Object)"u\u0016S0\u000e?K\u001c[\b]\u0019\u000e\u0019AM\\\bI\u0004]\u0019K\u001f\u000e\bX\b@\u0019\u000e\u0005O\u0003J\u0001K\u001f\u000e\u0016SMG\u0003\u000e\b@\t^\u0002G\u0003ZMU\u0010\u0000"), v3);
                }
                v4 = eventHandler;
                this /* !! */  = v4.I.writeValueAsString((Object)this /* !! */ );
                this /* !! */  = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)this /* !! */ ).setContext((String)a).setEndpointId((String)endpoint).setAction(Action.ADD).build();
                return v4.j.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), this /* !! */ .toByteArray()).thenApply((Function<AppendEntryResponse, ResponseEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, B(jakarta.servlet.http.HttpServletRequest io.axoniq.axonserver.grpc.internal.HandlerLogMessage io.axoniq.axonserver.grpc.internal.AppendEntryResponse ), (Lio/axoniq/axonserver/grpc/internal/AppendEntryResponse;)Lorg/springframework/http/ResponseEntity;)((HttpServletRequest)request, (HandlerLogMessage)this /* !! */ )).exceptionally((Function<Throwable, ResponseEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, B(java.lang.Throwable ), (Ljava/lang/Throwable;)Lorg/springframework/http/ResponseEntity;)());
            }
        }
    }

    @Operation(summary="Get available sequencing policies", description="Retrieves the list of available sequencing policies that can be used for event handlers")
    @ApiResponse(responseCode="200", description="Successfully retrieved sequencing policies", content={@Content(array=@ArraySchema(schema=@Schema(type="string")))})
    @GetMapping(value={"v2/sequencingPolicies"})
    public Set<String> B() {
        IntegrationEventHandlerRestControllerV2 a2;
        return a2.l.sequencingPolicies();
    }

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Update an existing event handler", description="Updates the configuration of an existing event handler for an integration endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Event handler update accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Event handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @PutMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> B(@Parameter(description="Updated event handler configuration", required=true) @RequestBody @Schema(description="Updated event handler details", requiredMode=Schema.RequiredMode.REQUIRED) IntegrationAPI.EventHandler eventHandler, @Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(description="UUID of the event handler to update", required=true) @PathVariable(value="handler") @Schema(description="Event handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = eventHandler;
        IntegrationEventHandlerRestControllerV2 eventHandler2 = integrationEventHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)handlerId);
            eventHandler2.B((IntegrationAPI.EventHandler)object);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (k.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                k.info(ShowDetail.B((Object)"z\n\\,\u0001#D\u0000T\u0014R\u0005\u0001\u0005NQT\u0001E\u0010U\u0014\u0001\u0014W\u0014O\u0005\u0001\u0019@\u001fE\u001dD\u0003\u0001\n\\QH\u001f\u0001\u0014O\u0015Q\u001eH\u001fUQZ\f\u000f"), objectArray);
            }
            IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = eventHandler2;
            object = integrationEventHandlerRestControllerV22.I.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationEventHandlerRestControllerV22.j.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEventHandlerRestControllerV2.B((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationEventHandlerRestControllerV2(EventStoreTokenSupplier eventStoreTokenSupplier, ObjectMapper objectMapper, RaftGroupServiceFactory raftGroupServiceFactory, EventHandlers eventHandlers, SequencingPolicyProvider sequencingPolicyProvider, EventSupplier eventSupplier) {
        IntegrationEventHandlerRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        IntegrationEventHandlerRestControllerV2 a8;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = integrationEventHandlerRestControllerV22;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = eventSupplier;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV23 = a8 = integrationEventHandlerRestControllerV2;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV24 = a8;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV25 = a8;
        integrationEventHandlerRestControllerV25.C = a7;
        integrationEventHandlerRestControllerV25.I = a6;
        integrationEventHandlerRestControllerV24.j = a5;
        integrationEventHandlerRestControllerV24.D = a4;
        integrationEventHandlerRestControllerV23.l = a3;
        integrationEventHandlerRestControllerV23.h = a2;
    }

    private /* synthetic */ void B(IntegrationAPI.EventHandler eventHandler) {
        IntegrationEventHandlerRestControllerV2 a2 = eventHandler;
        IntegrationEventHandlerRestControllerV2 a3 = this;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = a2;
        ValidationUtils.B((String)integrationEventHandlerRestControllerV2.name(), (String)EventProcessorResultListener.B((Object)"\u0003O\u0000K"));
        ValidationUtils.B((String)integrationEventHandlerRestControllerV2.sequencingPolicy(), (String)ShowDetail.B((Object)"\u0002D\u0000T\u0014O\u0012H\u001fF!N\u001dH\u0012X"));
        ValidationUtils.B((String)integrationEventHandlerRestControllerV2.sequencingPolicy(), (String)EventProcessorResultListener.B((Object)"\u001eK\u001c[\b@\u000eG\u0003I=A\u0001G\u000eW"), (Collection)a3.B());
        ValidationUtils.B((String)integrationEventHandlerRestControllerV2.name(), (int)200, (String)ShowDetail.B((Object)"\u001f@\u001cD"));
        ValidationUtils.B((String)integrationEventHandlerRestControllerV2.eventUrl(), (int)2000, (String)EventProcessorResultListener.B((Object)"\bX\b@\u0019{\u001fB"));
        ValidationUtils.B((String)integrationEventHandlerRestControllerV2.sequencingPolicyParameters(), (int)2000, (String)ShowDetail.B((Object)"\u0002D\u0000T\u0014O\u0012H\u001fF!N\u001dH\u0012X!@\u0003@\u001cD\u0005D\u0003R"));
        ValidationUtils.B((String)integrationEventHandlerRestControllerV2.filter(), (int)4000, (String)EventProcessorResultListener.B((Object)"\u000bG\u0001Z\b\\"));
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = a3;
        integrationEventHandlerRestControllerV22.h.validateFilter(a2.filter());
        integrationEventHandlerRestControllerV22.B(integrationEventHandlerRestControllerV2.sequencingPolicy(), a2.sequencingPolicyParameters());
    }
}

