/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.QueryHandler;
import io.axoniq.axonserver.configuration.runtime.QueryHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminQueryHandlerLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.v2.RolesRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Query Handlers", description="Operations to manage query handlers for integration endpoints")
public class IntegrationQueryHandlerRestControllerV2 {
    private final QueryHandlers C;
    private final ObjectMapper I;
    private static final Logger l = AuditLog.getLogger();
    private final RaftGroupServiceFactory k;

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationQueryHandlerRestControllerV2(ObjectMapper objectMapper, QueryHandlers queryHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationQueryHandlerRestControllerV2 a4;
        IntegrationQueryHandlerRestControllerV2 a5 = raftGroupServiceFactory;
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = a4 = this;
        a4.I = a3;
        integrationQueryHandlerRestControllerV2.C = a2;
        integrationQueryHandlerRestControllerV2.k = a5;
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete a query handler", description="Remove a query handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query handler successfully deleted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @DeleteMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> B(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = principal;
        IntegrationQueryHandlerRestControllerV2 principal2 = integrationQueryHandlerRestControllerV2;
        try {
            void a3;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)handlerId);
            object = (Principal)ObjectUtils.B((Object)object, (Object)GrpcContextAuthenticationProvider.I);
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                l.info(RolesRestControllerV2.B((Object)"l?J\u0019\u0017\u0016R5B!D0\u00170XdS![!C!\u00175B!E=\u0017,V*S(R6\u0017?Jd^*\u0017!Y G+^*CdL9\u0019"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a3).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.k.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(a2 -> ValidationUtils.B())).exceptionally(ValidationUtils::B);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)this2));
        }
    }

    private static /* synthetic */ ResponseEntity B(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.B((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Update a query handler", description="Update an existing query handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PutMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Updated query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)handlerId);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.B((String)integrationQueryHandlerRestControllerV22.name(), (String)RolesRestControllerV2.B((Object)"*V)R"));
            ValidationUtils.B((String)object.name(), (int)200, (String)SslConfiguration.B((Object)"0\u00163\u0012"));
            ValidationUtils.B((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)RolesRestControllerV2.B((Object)"5B!E=b6["));
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                l.info(SslConfiguration.B((Object)",%\n\u0003W\f\u0012/\u0002;\u0004*W*\u0018~\u0002.\u0013?\u0003;W/\u0002;\u0005'W6\u00160\u00132\u0012,W%\n~\u001e0W;\u0019:\u00071\u001e0\u0003~\f#Y"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.I.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.k.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.B((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Register a query handler", description="Register a new query handler for a specific endpoint to handle incoming query requests")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Query handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PostMapping(value={"v2/endpoints/{endpoint}/queryHandlers"})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.B((String)integrationQueryHandlerRestControllerV22.name(), (String)RolesRestControllerV2.B((Object)"*V)R"));
            ValidationUtils.B((String)integrationQueryHandlerRestControllerV22.name(), (int)200, (String)SslConfiguration.B((Object)"0\u00163\u0012"));
            ValidationUtils.B((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)RolesRestControllerV2.B((Object)"5B!E=b6["));
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                l.info(SslConfiguration.B((Object)",%\n\u0003W\f\u0012/\u0002;\u0004*W*\u0018~\u0005;\u00107\u0004*\u0012,W/\u0002;\u0005'W6\u00160\u00132\u0012,W%\n~\u001e0W;\u0019:\u00071\u001e0\u0003~\f#Y"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.I.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.k.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.B((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::B);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.QueryHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> B(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = string2;
        IntegrationQueryHandlerRestControllerV2 handlerId = integrationQueryHandlerRestControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.B((String)endpoint);
            ValidationUtils.B((String)object);
            principal2 = (Principal)ObjectUtils.B((Object)principal2, (Object)GrpcContextAuthenticationProvider.I);
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                l.info(SslConfiguration.B((Object)"\u0005\f#*~%;\u0006+\u0012-\u0003~\u00031W9\u0012*W/\u0002;\u0005'W6\u00160\u00132\u0012,W%\n~\u001e0W;\u0019:\u00071\u001e0\u0003~\f#Y"), objectArray);
            }
            if (!(object = (QueryHandler)handlerId.C.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, RolesRestControllerV2.B((Object)"\u007f%Y [!EdY+CdQ+B*S")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, RolesRestControllerV2.B((Object)"\u007f%Y [!EdY+CdQ+B*Sd^*\u0017!Y G+^*C"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, SslConfiguration.B((Object)"\u0016\u00160\u00132\u0012,W0\u0018*W8\u0018+\u0019:W7\u0019~\u00141\u0019*\u0012&\u0003"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.QueryHandler(object.getName(), object.getQueryUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.B((Throwable)principal2);
        }
    }
}

