/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.ByteString;
import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.runtime.CommandHandler;
import io.axoniq.axonserver.configuration.runtime.Contexts;
import io.axoniq.axonserver.configuration.runtime.Endpoint;
import io.axoniq.axonserver.configuration.runtime.EventHandler;
import io.axoniq.axonserver.configuration.runtime.QueryHandler;
import io.axoniq.axonserver.enterprise.event.ConsistencyCondition;
import io.axoniq.axonserver.enterprise.event.EventStoreService;
import io.axoniq.axonserver.enterprise.event.TagsAndNameCriterion;
import io.axoniq.axonserver.eventstore.PersistentStreamEvent;
import io.axoniq.axonserver.eventstore.api.Event;
import io.axoniq.axonserver.eventstore.api.LabeledEvent;
import io.axoniq.axonserver.eventstore.api.RegularSequence;
import io.axoniq.axonserver.eventstore.api.Sequence;
import io.axoniq.axonserver.eventstore.api.SequencedEvent;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.integration.EndpointController;
import io.axoniq.axonserver.integration.EndpointFactory;
import io.axoniq.axonserver.integration.PayloadUtils;
import io.axoniq.axonserver.integration.WrappedCommandHandler;
import io.axoniq.axonserver.integration.WrappedEndpoint;
import io.axoniq.axonserver.integration.WrappedEventHandler;
import io.axoniq.axonserver.integration.WrappedQueryHandler;
import io.axoniq.axonserver.integration.http.HttpCustomHeaders;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.file.AggregateWithoutSnapshotException;
import io.axoniq.axonserver.localstorage.query.MaxTokenExtractor;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.streams.connection.StreamEvent;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.transport.rest.v2.C;
import io.axoniq.axonserver.transport.rest.v2.D;
import io.axoniq.axonserver.transport.rest.v2.E;
import io.axoniq.axonserver.transport.rest.v2.H;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.transport.rest.v2.a;
import io.axoniq.axonserver.transport.rest.v2.c;
import io.axoniq.axonserver.transport.rest.v2.e;
import io.axoniq.axonserver.transport.rest.v2.g;
import io.axoniq.axonserver.transport.rest.v2.i;
import io.axoniq.axonserver.transport.rest.v2.l;
import io.axoniq.axonserver.util.ObjectUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Min;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin
@Tag(name="Integration", description="API endpoints for integration with Axon Server via REST")
public class IntegrationRestControllerV2 {
    private final CommandDispatcher b;
    private final String e;
    private static final String K = "{name}";
    private final EventDispatcher M;
    public static final String a = "message";
    private static final Logger j = LoggerFactory.getLogger(IntegrationRestControllerV2.class);
    private final QueryDispatcher h;
    private final EndpointFactory D;
    public static final String C = "success";
    private final EventStoreService I;
    private final Contexts l;
    private final EndpointController k;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"v2/events/{name}"}, consumes={"*/*"})
    @Operation(summary="Publish an event with binary payload", description="Publishes an event to Axon Server with a binary payload")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Event successfully published"), @ApiResponse(responseCode="400", description="Invalid event format"), @ApiResponse(responseCode="500", description="Event publishing failed")})
    @Transactional(readOnly=true)
    public CompletableFuture<ResponseEntity<Object>> c(@PathVariable(value="name") @Schema(description="Event name", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(name="AxonIQ-MessageId", description="Message identifier", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-MessageId", required=false) String string2, @Parameter(name="AxonIQ-PayloadRevision", description="Payload revision", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-PayloadRevision", required=false) String string3, @Parameter(name="AxonIQ-AggregateId", description="Aggregate identifier", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-AggregateId", required=false) String string4, @Parameter(name="AxonIQ-AggregateType", description="Aggregate type", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-AggregateType", required=false) String string5, @Parameter(name="AxonIQ-SequenceNumber", description="Sequence number", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-SequenceNumber", required=false) Long l2, @Parameter(name="AxonIQ-DateTime", description="Date and time of the event", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-DateTime", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime offsetDateTime, @RequestBody Resource resource, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string6) {
        Object object;
        Event.Builder builder;
        void a2;
        IntegrationRestControllerV2 integrationRestControllerV2 = completableFuture;
        CompletableFuture completableFuture = new CompletableFuture();
        if (integrationRestControllerV2.l.isDcbContext((String)a2).orElse(false).booleanValue()) {
            completableFuture.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Publishing events is not supported for the context: " + (String)a2)));
            return completableFuture;
        }
        try {
            void axonIQMessageId;
            Authentication principal;
            principal = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
            builder = io.axoniq.axonserver.grpc.event.Event.newBuilder();
            object = axonIQMessageId != null ? axonIQMessageId : UUID.randomUUID().toString();
        }
        catch (IOException principal) {
            CompletableFuture completableFuture2 = completableFuture;
            completableFuture2.complete(ValidationUtils.B((Throwable)principal));
            return completableFuture2;
        }
        {
            void body;
            void axonIQPayloadRevision;
            void axonIQSequenceNumber;
            void axonIQAggregateType;
            void axonIQAggregateId;
            void axonIQDateTime;
            io.axoniq.axonserver.grpc.event.Event name;
            void v3 = name;
            name = builder.setMessageIdentifier(object).setTimestamp(axonIQDateTime != null ? axonIQDateTime.toInstant().toEpochMilli() : System.currentTimeMillis()).setAggregateIdentifier((String)ObjectUtils.B((Object)axonIQAggregateId, (Object)"")).setAggregateType((String)ObjectUtils.B((Object)axonIQAggregateType, (Object)"")).setAggregateSequenceNumber(((Long)ObjectUtils.B((Object)axonIQSequenceNumber, (Object)0L)).longValue()).setPayload(IntegrationRestControllerV2.B((String)v3, (String)v3, (String)axonIQPayloadRevision, (Resource)body)).build();
            integrationRestControllerV2.M.appendEvent((String)a2, principal, Flux.just((Object)new SerializedEvent(name))).subscribe((CoreSubscriber)IntegrationRestControllerV2.B((CompletableFuture)completableFuture));
            return completableFuture;
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/commands"}, consumes={"application/json"}, produces={"application/json"})
    @Operation(summary="Dispatch a command with JSON payload", description="Sends a command to Axon Server for processing with a JSON payload")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Command successfully processed", content={@Content(schema=@Schema(implementation=IntegrationAPI.CommandResponse.class))}), @ApiResponse(responseCode="400", description="Invalid command format"), @ApiResponse(responseCode="500", description="Command processing failed")})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Command to be dispatched", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.Command.class) IntegrationAPI.Command command, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string) {
        void a2;
        SerializedCommand command2;
        IntegrationRestControllerV2 integrationRestControllerV2 = integrationRestControllerV22;
        IntegrationRestControllerV2 integrationRestControllerV22 = authentication;
        IntegrationRestControllerV2 principal = integrationRestControllerV2;
        void v1 = command2;
        ValidationUtils.B((String)v1.name(), (String)MaxTokenExtractor.B((Object)"\u0005\u0006\u0006\u0002"));
        CompletableFuture<ResponseEntity<Object>> completableFuture = new CompletableFuture<ResponseEntity<Object>>();
        MediaType mediaType = PayloadUtils.B((String)v1.payloadContentType());
        String string2 = (String)ObjectUtils.B((Object)v1.id(), (Object)UUID.randomUUID().toString());
        integrationRestControllerV22 = (Authentication)ObjectUtils.B((Object)integrationRestControllerV22, (Object)GrpcContextAuthenticationProvider.I);
        command2 = new SerializedCommand(principal.B((IntegrationAPI.Command)command2, string2, (Authentication)integrationRestControllerV22, mediaType));
        principal.b.dispatch((String)a2, (Authentication)integrationRestControllerV22, command2, serializedCommandResponse -> {
            void a2;
            CompletableFuture a3 = serializedCommandResponse;
            CompletableFuture a4 = completableFuture;
            if (!a3.getErrorCode().isBlank()) {
                a4.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.find((String)a3.getErrorCode()), a3.wrapped().getErrorMessage().getMessage())));
                return;
            }
            a4.complete(ResponseEntity.ok((Object)new IntegrationAPI.CommandResponse(a3.wrapped().getMessageIdentifier(), PayloadUtils.B((Map)a3.wrapped().getMetaDataMap()), PayloadUtils.B((ByteString)a3.wrapped().getPayload().getData(), (MediaType)a2), a3.wrapped().getPayload().getType(), a3.wrapped().getPayload().getRevision())));
        });
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"v2/commands/{name}"}, consumes={"*/*"})
    @Operation(summary="Dispatch a command with binary payload", description="Sends a command to Axon Server for processing with a binary payload")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Command successfully processed"), @ApiResponse(responseCode="400", description="Invalid command format"), @ApiResponse(responseCode="500", description="Command processing failed")})
    public CompletableFuture<ResponseEntity<Object>> B(@PathVariable(value="name") @Schema(description="Command name", requiredMode=Schema.RequiredMode.REQUIRED) String string, @RequestHeader(value="AxonIQ-MessageId", required=false) @Parameter(name="AxonIQ-MessageId", description="Message identifier", in=ParameterIn.HEADER) String string2, @RequestHeader(value="AxonIQ-PayloadType", required=false) @Parameter(name="AxonIQ-PayloadType", description="Payload type", in=ParameterIn.HEADER) String string3, @RequestHeader(value="AxonIQ-PayloadRevision", required=false) @Parameter(name="AxonIQ-PayloadRevision", description="Payload revision", in=ParameterIn.HEADER) String string4, @RequestHeader(value="AxonIQ-Priority", required=false) @Parameter(name="AxonIQ-Priority", description="Priority level", in=ParameterIn.HEADER) Integer n, @RequestHeader(value="AxonIQ-RoutingKey", required=false) @Parameter(name="AxonIQ-RoutingKey", description="Routing key", in=ParameterIn.HEADER) String string5, @RequestBody Resource resource, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string6) {
        IntegrationRestControllerV2 integrationRestControllerV2 = integrationRestControllerV22;
        CompletableFuture<ResponseEntity<Object>> completableFuture = new CompletableFuture<ResponseEntity<Object>>();
        try {
            void a2;
            void axonIQRoutingKey;
            void axonIQPriority;
            void body;
            void axonIQPayloadRevision;
            void axonIQPayloadType;
            Command name;
            void principal;
            Authentication axonIQMessageId;
            IntegrationRestControllerV2 integrationRestControllerV22 = axonIQMessageId != null ? axonIQMessageId : UUID.randomUUID().toString();
            axonIQMessageId = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
            name = Command.newBuilder().setName((String)name).setMessageIdentifier((String)integrationRestControllerV22).setTimestamp(System.currentTimeMillis()).setClientId(integrationRestControllerV2.B(axonIQMessageId)).setComponentName(integrationRestControllerV2.B()).setPayload(IntegrationRestControllerV2.B((String)name, (String)axonIQPayloadType, (String)axonIQPayloadRevision, (Resource)body)).addProcessingInstructions(ProcessingInstructionHelper.F((long)(axonIQPriority != null ? (long)axonIQPriority.intValue() : 0L))).addProcessingInstructions(ProcessingInstructionHelper.B((String)(axonIQRoutingKey != null ? axonIQRoutingKey : integrationRestControllerV22))).build();
            integrationRestControllerV2.b.dispatch((String)a2, axonIQMessageId, new SerializedCommand(name), serializedCommandResponse -> {
                CompletableFuture a2 = serializedCommandResponse;
                CompletableFuture a3 = completableFuture;
                if (!a2.getErrorCode().isBlank()) {
                    a3.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.find((String)a2.getErrorCode()), a2.wrapped().getErrorMessage().getMessage())));
                    return;
                }
                HttpHeaders httpHeaders = new HttpHeaders();
                CompletableFuture completableFuture2 = a2;
                IntegrationRestControllerV2.B((String)completableFuture2.wrapped().getMessageIdentifier(), (HttpHeaders)httpHeaders);
                if (completableFuture2.wrapped().hasPayload()) {
                    IntegrationRestControllerV2.B((SerializedObject)a2.wrapped().getPayload(), (HttpHeaders)httpHeaders);
                    a3.complete(((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).body((Object)new ByteArrayResource(a2.wrapped().getPayload().getData().toByteArray())));
                    return;
                }
                a3.complete(((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).build());
            });
            return completableFuture;
        }
        catch (IOException iOException) {
            CompletableFuture<ResponseEntity<Object>> completableFuture2 = completableFuture;
            completableFuture2.complete(ValidationUtils.B((Throwable)iOException));
            return completableFuture2;
        }
    }

    private static /* synthetic */ void B(SerializedObject serializedObject, HttpHeaders httpHeaders) {
        SerializedObject a2 = httpHeaders;
        SerializedObject a3 = serializedObject;
        if (!a3.getType().isBlank()) {
            a2.add(HttpCustomHeaders.a.B(), a3.getType());
        }
        if (!a3.getRevision().isBlank()) {
            a2.add(HttpCustomHeaders.I.B(), a3.getRevision());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static /* synthetic */ SerializedObject B(String string, String string2, String string3, Resource resource) throws IOException {
        void a2;
        void a3;
        String a4 = string3;
        String a5 = string;
        return SerializedObject.newBuilder().setType((String)(a3 != null ? a3 : a5)).setRevision(a4 != null ? a4 : "").setData(ByteString.readFrom((InputStream)a2.getInputStream())).build();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IntegrationAPI.Event B(SerializedEvent serializedEvent, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a3 = serializedEvent;
        IntegrationRestControllerV2 a4 = this;
        return new IntegrationAPI.Event(a3.d(), a3.i(), a3.F(), a3.F(), a3.B(), a3.A(), a2.toString(), PayloadUtils.B((ByteString)a3.B().getPayload().getData(), (MediaType)a2), PayloadUtils.B((Map)a3.B().getMetaDataMap()), OffsetDateTime.ofInstant(Instant.ofEpochMilli(a3.B()), ZoneId.systemDefault()));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/queries"}, consumes={"application/json"}, produces={"application/json"})
    @Operation(summary="Dispatch a query with JSON payload", description="Sends a query to Axon Server for processing with a JSON payload")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query successfully processed", content={@Content(schema=@Schema(implementation=IntegrationAPI.QueryResponse.class))}), @ApiResponse(responseCode="400", description="Invalid query", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Query processing failed")})
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody @Schema(description="Query to be dispatched", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.Query.class) IntegrationAPI.Query query, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string) {
        void a3;
        Authentication principal;
        IntegrationRestControllerV2 integrationRestControllerV2 = integrationRestControllerV22;
        IntegrationRestControllerV2 integrationRestControllerV22 = query;
        IntegrationRestControllerV2 query2 = integrationRestControllerV2;
        IntegrationRestControllerV2 integrationRestControllerV23 = integrationRestControllerV22;
        ValidationUtils.B((String)integrationRestControllerV23.name(), (String)AggregateWithoutSnapshotException.B((Object)"f\u0006e\u0002"));
        CompletableFuture<ResponseEntity<Object>> completableFuture = new CompletableFuture<ResponseEntity<Object>>();
        String string2 = integrationRestControllerV23.id() != null ? integrationRestControllerV22.id() : UUID.randomUUID().toString();
        MediaType mediaType = PayloadUtils.B((String)integrationRestControllerV22.payloadContentType());
        principal = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
        integrationRestControllerV22 = new SerializedQuery((String)a3, query2.B((IntegrationAPI.Query)integrationRestControllerV22, string2, principal, mediaType));
        query2.h.query((SerializedQuery)integrationRestControllerV22, principal, queryResponse -> {
            void a2;
            CompletableFuture a3 = queryResponse;
            CompletableFuture a4 = completableFuture;
            if (!a3.getErrorCode().isBlank()) {
                a4.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.find((String)a3.getErrorCode()), a3.getErrorMessage().getMessage())));
                return;
            }
            a4.complete(ResponseEntity.ok((Object)new IntegrationAPI.QueryResponse(a3.getMessageIdentifier(), PayloadUtils.B((Map)a3.getMetaDataMap()), PayloadUtils.B((ByteString)a3.getPayload().getData(), (MediaType)a2), a3.getPayload().getType(), a3.getPayload().getRevision())));
        }, a2 -> {});
        return completableFuture;
    }

    private /* synthetic */ ConsistencyCondition B(IntegrationAPI.ConsistencyCondition consistencyCondition) {
        IntegrationRestControllerV2 a2 = consistencyCondition;
        IntegrationRestControllerV2 a3 = this;
        return new D(a3, (IntegrationAPI.ConsistencyCondition)a2);
    }

    private static /* synthetic */ void B(String string, HttpHeaders httpHeaders) {
        String a2 = httpHeaders;
        String a3 = string;
        if (!a3.isBlank()) {
            a2.add(HttpCustomHeaders.J.B(), a3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private /* synthetic */ SerializedEvent B(IntegrationAPI.Event event, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a3 = mediaType;
        IntegrationRestControllerV2 a4 = this;
        return new SerializedEvent(a4.B((IntegrationAPI.Event)a2, (MediaType)a3));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Map<String, MetaDataValue> B(Map<String, String> map) {
        void a2;
        IntegrationRestControllerV2 integrationRestControllerV2 = this;
        Object a3 = new HashMap();
        if (a2 != null) {
            a2.forEach((arg_0, arg_1) -> IntegrationRestControllerV2.B((Map)a3, arg_0, arg_1));
        }
        return a3;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/dcbEvents"}, consumes={"application/json"})
    @Transactional(readOnly=true)
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody IntegrationAPI.ConditionalAppend conditionalAppend, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") String string) {
        void a2;
        Authentication principal;
        void conditionalAppend2;
        IntegrationRestControllerV2 integrationRestControllerV2 = completableFuture;
        if (conditionalAppend2.events().isEmpty()) {
            return CompletableFuture.completedFuture(ResponseEntity.ok().build());
        }
        CompletableFuture completableFuture = new CompletableFuture();
        MediaType mediaType = PayloadUtils.B((String)((IntegrationAPI.LabeledEvent)conditionalAppend2.events().get(0)).event().payloadContentType());
        principal = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
        if (integrationRestControllerV2.l.isDcbContext((String)a2).orElse(false).booleanValue()) {
            principal = integrationRestControllerV2.I.startTransaction((String)a2, () -> principal.getName());
            void v0 = conditionalAppend2;
            principal.condition(integrationRestControllerV2.B(v0.consistencyCondition()));
            v0.events().forEach(arg_0 -> integrationRestControllerV2.B((EventStoreService.AppendTransaction)principal, mediaType, arg_0));
            ((CompletableFuture)principal.commit().thenAccept(sequence -> {
                CompletableFuture a2 = sequence;
                CompletableFuture a3 = completableFuture;
                a3.complete(ResponseEntity.ok((Object)new IntegrationAPI.AppendResponse(a2.value())));
            })).exceptionally(throwable -> {
                Throwable a2 = throwable;
                CompletableFuture a3 = completableFuture;
                a3.complete(ValidationUtils.B((Throwable)a2));
                return null;
            });
            return completableFuture;
        }
        completableFuture.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Conditional append is not supported for the context: " + (String)a2)));
        return completableFuture;
    }

    private static /* synthetic */ long B(SequencedEvent a2, long a3) {
        return Math.max(a3, a2.sequence().value());
    }

    @NotNull
    private static /* synthetic */ Map<String, String> B(String a2) {
        return Map.of("error", a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ByteString B(JsonNode jsonNode, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a222 = jsonNode;
        IntegrationRestControllerV2 a3 = this;
        try {
            return PayloadUtils.B((JsonNode)a222, (MediaType)a2);
        }
        catch (IOException a222) {
            throw new MessagingPlatformException(ErrorCode.OTHER, "Error translating payload to bytes - " + (MediaType)a2, (Throwable)a222);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"v2/endpoints/{endpointId}/test-query"})
    @Operation(summary="Test a query handler", description="Tests a query handler configuration by sending a test query to the specified endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Test query successfully processed"), @ApiResponse(responseCode="400", description="Invalid query or endpoint configuration"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Test query processing failed")})
    public ResponseEntity<Object> B(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @RequestParam(value="queryUrl", required=false) @Schema(description="Query URL to override endpoint configuration") String string3, @Parameter(hidden=true) Authentication authentication, @RequestBody @Schema(description="Query payload for testing", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.Query.class) IntegrationAPI.Query query) {
        void var3_7;
        IntegrationRestControllerV2 integrationRestControllerV2 = integrationRestControllerV22;
        IntegrationRestControllerV2 integrationRestControllerV22 = var3_7;
        IntegrationRestControllerV2 queryUrlParam = integrationRestControllerV2;
        try {
            Authentication principal;
            void a2;
            WrappedEndpoint endpointId;
            ValidationUtils.B((String)endpointId);
            void v1 = a2;
            ValidationUtils.B((String)v1.name(), (String)AggregateWithoutSnapshotException.B((Object)"f\u0006e\u0002"));
            j.info(MaxTokenExtractor.B((Object)"?\u0002\u0018\u0013K\u0016\u001e\u0002\u0019\u001eK\u0017\n\u001e\u0007\b\n\u0003QG\u0010\u001a"), (Object)a2);
            endpointId = queryUrlParam.k.get(UUID.fromString((String)endpointId));
            String context = v1.name();
            j.info(AggregateWithoutSnapshotException.B((Object)"Y\u0012m\u0015qGf\u0006e\u00022Gs\u001a"), (Object)context);
            String string4 = integrationRestControllerV22 == null ? endpointId.endpoint().getQueryUrl().replace("{name}", context) : integrationRestControllerV22.replace("{name}", context);
            j.info(MaxTokenExtractor.B((Object)"2\u0018\u000e\u0005\u0000K\u0016\u001e\u0002\u0019\u001eK29+QG\u0010\u001a"), (Object)string4);
            integrationRestControllerV22 = new e(queryUrlParam.e, (String)integrationRestControllerV22);
            integrationRestControllerV22 = new WrappedQueryHandler("", (QueryHandler)integrationRestControllerV22, endpointId);
            integrationRestControllerV22 = queryUrlParam.D.endpointHandler(endpointId.type()).queryInvoker((WrappedQueryHandler)integrationRestControllerV22);
            String string5 = a2.id() != null ? a2.id() : UUID.randomUUID().toString();
            MediaType mediaType = PayloadUtils.B((String)a2.payloadContentType());
            principal = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
            integrationRestControllerV22 = (QueryResponse)integrationRestControllerV22.dispatchRequest(queryUrlParam.B((IntegrationAPI.Query)a2, string5, principal, mediaType)).get(10L, TimeUnit.SECONDS);
            if (integrationRestControllerV22.hasErrorMessage()) {
                j.error(AggregateWithoutSnapshotException.B((Object)"6}\u0002z\u001e(\u0013m\u0014|Gn\u0006a\u000bm\u00032Gs\u001a"), (Object)integrationRestControllerV22.getErrorMessage());
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)IntegrationRestControllerV2.B((String)integrationRestControllerV22.getErrorMessage().getMessage()));
            }
            return ResponseEntity.ok().body(Map.of("success", true, "message", MaxTokenExtractor.B((Object)"6\u001e\u0002\u0019\u001eK\u0002\u0013\u0002\b\u0012\u001f\u0002\u000fG\u0018\u0012\b\u0004\u000e\u0014\u0018\u0001\u001e\u000b\u0007\u001e"), AggregateWithoutSnapshotException.B((Object)"\u0016}\u0002z\u001eF\u0006e\u0002"), context, MaxTokenExtractor.B((Object)"\u001a\u0012\u000e\u0015\u00122\u0019\u000b"), string4));
        }
        catch (InterruptedException endpointId) {
            Thread.currentThread().interrupt();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)IntegrationRestControllerV2.B((String)endpointId.getMessage()));
        }
        catch (Exception endpointId) {
            j.info(AggregateWithoutSnapshotException.B((Object)"!i\u000ed\u0002lG|\b(\u0013m\u0014|Gy\u0012m\u0015qGm\tl\u0017g\u000ef\u0013"), (Throwable)endpointId);
            ErrorCode context = ErrorCode.fromException((Throwable)endpointId);
            return ResponseEntity.status((HttpStatusCode)context.getHttpCode()).body((Object)IntegrationRestControllerV2.B((String)endpointId.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private /* synthetic */ io.axoniq.axonserver.grpc.event.Event B(IntegrationAPI.Event event, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a3 = event;
        IntegrationRestControllerV2 a4 = this;
        return io.axoniq.axonserver.grpc.event.Event.newBuilder().setMessageIdentifier(a3.id() != null ? a3.id() : UUID.randomUUID().toString()).setTimestamp(a3.dateTime() != null ? a3.dateTime().toInstant().toEpochMilli() : System.currentTimeMillis()).setAggregateIdentifier((String)ObjectUtils.B((Object)a3.aggregateId(), (Object)"")).setAggregateType((String)ObjectUtils.B((Object)a3.aggregateType(), (Object)"")).setAggregateSequenceNumber(a3.sequenceNumber()).setPayload(SerializedObject.newBuilder().setType((String)ObjectUtils.B((Object)a3.payloadType(), (Object)"")).setRevision((String)ObjectUtils.B((Object)a3.payloadRevision(), (Object)"")).setData(a4.B(a3.payload(), (MediaType)a2)).build()).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private /* synthetic */ io.axoniq.axonserver.grpc.event.Event B(IntegrationAPI.Snapshot snapshot, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a3 = snapshot;
        IntegrationRestControllerV2 a4 = this;
        return io.axoniq.axonserver.grpc.event.Event.newBuilder().setMessageIdentifier(a3.id() != null ? a3.id() : UUID.randomUUID().toString()).setTimestamp(a3.dateTime() != null ? a3.dateTime().toInstant().toEpochMilli() : System.currentTimeMillis()).setAggregateIdentifier(a3.aggregateId() != null ? a3.aggregateId() : "").setAggregateType(a3.aggregateType() != null ? a3.aggregateType() : "").setAggregateSequenceNumber(a3.sequenceNumber()).setPayload(SerializedObject.newBuilder().setType((String)ObjectUtils.B((Object)a3.payloadType(), (Object)"")).setRevision((String)ObjectUtils.B((Object)a3.payloadRevision(), (Object)"")).setData(a4.B(a3.payload(), (MediaType)a2)).build()).build();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IntegrationAPI.Snapshot B(SerializedEvent serializedEvent, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a3 = serializedEvent;
        IntegrationRestControllerV2 a4 = this;
        return new IntegrationAPI.Snapshot(a3.d(), a3.i(), a3.F(), a3.F(), a3.B(), a3.A(), a2.toString(), PayloadUtils.B((ByteString)a3.B().getPayload().getData(), (MediaType)a2), PayloadUtils.B((Map)a3.B().getMetaDataMap()), OffsetDateTime.ofInstant(Instant.ofEpochMilli(a3.B()), ZoneId.systemDefault()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"v2/endpoints/{endpointId}/test-command"})
    @Operation(summary="Test a command handler", description="Tests a command handler configuration by sending a test command to the specified endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Test command successfully processed"), @ApiResponse(responseCode="400", description="Invalid command or endpoint configuration"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Test command processing failed")})
    public ResponseEntity<Object> B(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @RequestParam(value="commandUrl", required=false) @Schema(description="Command URL to override endpoint configuration") String string3, @RequestBody @Schema(description="Command payload for testing", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.Command.class) IntegrationAPI.Command command, @Parameter(hidden=true) Authentication authentication) {
        void var1_6;
        void this_2 = var1_6;
        IntegrationRestControllerV2 endpointId = this;
        try {
            Authentication a2;
            H commandUrlParam;
            void payload;
            ValidationUtils.B((String)this_2);
            void v0 = payload;
            ValidationUtils.B((String)v0.name(), (String)MaxTokenExtractor.B((Object)"\u0005\u0006\u0006\u0002"));
            WrappedEndpoint this_2 = endpointId.k.get(UUID.fromString((String)this_2));
            String context = v0.name();
            j.info(AggregateWithoutSnapshotException.B((Object)"3m\u0014|GK\be\ni\tl](\u001cuK(7i\u001ed\bi\u00032Gs\u001a"), (Object)context, (Object)payload);
            String string4 = commandUrlParam == null ? this_2.endpoint().getCommandUrl().replace("{name}", context) : commandUrlParam.replace("{name}", context);
            j.info(MaxTokenExtractor.B((Object)"2\u0018\u000e\u0005\u0000K\u0004\u0004\n\u0006\u0006\u0005\u0003K29+QG\u0010\u001a"), (Object)string4);
            commandUrlParam = new H(context, (String)commandUrlParam);
            commandUrlParam = endpointId.D.endpointHandler(this_2.type()).commandInvoker(new WrappedCommandHandler("", (CommandHandler)commandUrlParam, this_2, 100));
            String string5 = payload.id() != null ? payload.id() : UUID.randomUUID().toString();
            MediaType mediaType = PayloadUtils.B((String)payload.payloadContentType());
            a2 = (Authentication)ObjectUtils.B((Object)a2, (Object)GrpcContextAuthenticationProvider.I);
            commandUrlParam = (CommandResponse)commandUrlParam.dispatchRequest(endpointId.B((IntegrationAPI.Command)payload, string5, a2, mediaType)).get(10L, TimeUnit.SECONDS);
            if (commandUrlParam.hasErrorMessage()) {
                j.error(AggregateWithoutSnapshotException.B((Object)"K\be\ni\tlG|\u0002{\u0013(\u0001i\u000ed\u0002lG%Gs\u001a"), (Object)commandUrlParam.getErrorMessage());
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)IntegrationRestControllerV2.B((String)commandUrlParam.getErrorMessage().getMessage()));
            }
            return ResponseEntity.ok().body(Map.of("success", true, "message", MaxTokenExtractor.B((Object)"$\u0004\n\u0006\u0006\u0005\u0003K\u0002\u0013\u0002\b\u0012\u001f\u0002\u000fG\u0018\u0012\b\u0004\u000e\u0014\u0018\u0001\u001e\u000b\u0007\u001e"), AggregateWithoutSnapshotException.B((Object)"\u0004g\ne\u0006f\u0003F\u0006e\u0002"), context, MaxTokenExtractor.B((Object)"\b\b\u0006\n\n\t\u000f2\u0019\u000b"), string4));
        }
        catch (InterruptedException this_2) {
            Thread.currentThread().interrupt();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)IntegrationRestControllerV2.B((String)this_2.getMessage()));
        }
        catch (Exception this_2) {
            j.info(AggregateWithoutSnapshotException.B((Object)"!i\u000ed\u0002lG|\b(\u0013m\u0014|Gk\be\ni\tlGm\tl\u0017g\u000ef\u0013"), (Throwable)this_2);
            ErrorCode context = ErrorCode.fromException((Throwable)this_2);
            return ResponseEntity.status((HttpStatusCode)context.getHttpCode()).body((Object)IntegrationRestControllerV2.B((String)this_2.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/dcbEvents/source"})
    @Operation(summary="Source events matched by criteria", description="Retrieves events matching specified criteria from Axon Server")
    @Transactional(readOnly=true)
    @ApiResponse(responseCode="200", description="Events successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.SourcedEvents.class)), mediaType="application/json")})
    public CompletableFuture<ResponseEntity<Object>> B(@Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string, @RequestParam(value="minSequence", required=false, defaultValue="0") @Schema(description="Minimum sequence number (inclusive)", defaultValue="0") int n, @RequestParam(value="payloadContentType", required=false, defaultValue="application/octet-stream") @Schema(description="Content type of the event payload", defaultValue="application/octet-stream") String string2, @RequestBody List<IntegrationAPI.Criterion> list) {
        void context;
        Authentication principal;
        void a2;
        MediaType payloadContentType;
        IntegrationRestControllerV2 integrationRestControllerV2 = completableFuture;
        payloadContentType = PayloadUtils.B((String)payloadContentType);
        if (a2.isEmpty()) {
            return CompletableFuture.completedFuture(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, MaxTokenExtractor.B((Object)"*\u0013K\u000b\u000e\u0006\u0018\u0013K\b\u0005\u0002K\u0004\u0019\u000e\u001f\u0002\u0019\u000e\u0004\tK\n\u001e\u0014\u001fG\t\u0002K\u0014\u001b\u0002\b\u000e\r\u000e\u000e\u0003"))));
        }
        CompletableFuture completableFuture = new CompletableFuture();
        principal = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
        if (integrationRestControllerV2.l.isDcbContext((String)context).orElse(false).booleanValue()) {
            void minSequence;
            ArrayList arrayList = new ArrayList();
            Sequence sequence = integrationRestControllerV2.I.head((String)context, () -> principal.getName());
            AtomicLong atomicLong = new AtomicLong(sequence.value());
            Flux.from((Publisher)integrationRestControllerV2.I.source((String)context, () -> principal.getName(), integrationRestControllerV2.B((List)a2), RegularSequence.seq((int)minSequence), sequence)).subscribe(sequencedEvent -> {
                void a2;
                void a3;
                AtomicLong a4 = sequencedEvent;
                AtomicLong a5 = atomicLong;
                a5.updateAndGet(arg_0 -> IntegrationRestControllerV2.B((SequencedEvent)a4, arg_0));
                a3.add(new IntegrationAPI.DcbEvent(a4.event().identifier(), a4.event().version(), a4.event().name(), a2.toString(), PayloadUtils.B((ByteString)ByteString.copyFrom((byte[])a4.event().payload()), (MediaType)a2), a4.event().metadata(), OffsetDateTime.ofInstant(Instant.ofEpochMilli(a4.event().timestamp()), ZoneId.systemDefault())));
            }, throwable -> {
                Throwable a2 = throwable;
                CompletableFuture a3 = completableFuture;
                a3.complete(ValidationUtils.B((Throwable)a2));
            }, () -> {
                void a2;
                List a3 = arrayList;
                CompletableFuture a4 = completableFuture;
                a4.complete(ResponseEntity.ok((Object)new IntegrationAPI.SourcedEvents(a2.get(), a3)));
            });
            return completableFuture;
        }
        completableFuture.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Source events is not supported for the context: " + (String)context)));
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void B(EventStoreService.AppendTransaction appendTransaction, MediaType mediaType, IntegrationAPI.LabeledEvent labeledEvent) {
        void a2;
        void a3;
        IntegrationRestControllerV2 a4 = labeledEvent;
        IntegrationRestControllerV2 a5 = this;
        a3.append(a5.B((IntegrationAPI.LabeledEvent)a4, (MediaType)a2));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/events"}, consumes={"application/json"})
    @Transactional(readOnly=true)
    public CompletableFuture<ResponseEntity<Object>> B(@RequestBody List<IntegrationAPI.Event> list, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") String string) {
        Authentication principal;
        void a2;
        IntegrationRestControllerV2 integrationRestControllerV2 = object;
        Object object = list;
        IntegrationRestControllerV2 events = integrationRestControllerV2;
        if (object.isEmpty()) {
            return CompletableFuture.completedFuture(ResponseEntity.ok().build());
        }
        CompletableFuture<ResponseEntity<Object>> completableFuture = new CompletableFuture<ResponseEntity<Object>>();
        if (events.l.isDcbContext((String)a2).orElse(false).booleanValue()) {
            completableFuture.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Publishing events is not supported for the context: " + (String)a2)));
            return completableFuture;
        }
        MediaType mediaType = PayloadUtils.B((String)((IntegrationAPI.Event)object.get(0)).payloadContentType());
        principal = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
        object = object.stream().map(event -> {
            void a2;
            IntegrationRestControllerV2 a3 = event;
            IntegrationRestControllerV2 a4 = this;
            return a4.B((IntegrationAPI.Event)a3, (MediaType)a2);
        });
        CompletableFuture<ResponseEntity<Object>> completableFuture2 = completableFuture;
        events.M.appendEvent((String)a2, principal, Flux.fromStream((Stream)object)).subscribe((CoreSubscriber)IntegrationRestControllerV2.B(completableFuture2));
        return completableFuture2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IntegrationAPI.Snapshot B(MediaType mediaType, SerializedEvent serializedEvent) {
        void a2;
        IntegrationRestControllerV2 a3 = serializedEvent;
        IntegrationRestControllerV2 a4 = this;
        return a4.B((SerializedEvent)a3, (MediaType)a2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/aggregates/{aggregateId}/snapshots"}, produces={"application/json"})
    public List<IntegrationAPI.Snapshot> B(@PathVariable(value="aggregateId") String string, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") String string2, @RequestParam(value="minSequence", required=false, defaultValue="0") long l2, @RequestParam(value="maxResults", required=false, defaultValue="1") int n, @RequestParam(value="payloadContentType", required=false, defaultValue="application/octet-stream") @Schema(description="Content type of the event payload", defaultValue="application/octet-stream") String string3) {
        void principal;
        void context;
        void a2;
        void minSequence;
        GetAggregateSnapshotsRequest aggregateId;
        IntegrationRestControllerV2 integrationRestControllerV2 = object;
        Object object = string3;
        IntegrationRestControllerV2 a3 = integrationRestControllerV2;
        object = PayloadUtils.B((String)object);
        aggregateId = GetAggregateSnapshotsRequest.newBuilder().setAggregateId((String)aggregateId).setInitialSequence((long)minSequence).setMaxSequence(Long.MAX_VALUE).setMaxResults((int)a2).build();
        return a3.M.aggregateSnapshots((String)context, (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I), aggregateId).map(arg_0 -> a3.B((MediaType)object, arg_0)).toStream().toList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"v2/queries/{name}"}, consumes={"*/*"})
    @Operation(summary="Dispatch a query with binary payload", description="Sends a query to Axon Server for processing with a binary payload")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query successfully processed"), @ApiResponse(responseCode="400", description="Invalid query", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Query processing failed")})
    public CompletableFuture<ResponseEntity<Object>> B(@PathVariable(value="name") @Schema(description="Query name", requiredMode=Schema.RequiredMode.REQUIRED) String string, @RequestHeader(value="AxonIQ-MessageId", required=false) @Parameter(name="AxonIQ-MessageId", description="Message identifier", in=ParameterIn.HEADER) String string2, @RequestHeader(value="AxonIQ-PayloadType", required=false) @Parameter(name="AxonIQ-PayloadType", description="Payload type", in=ParameterIn.HEADER) String string3, @RequestHeader(value="AxonIQ-PayloadRevision", required=false) @Parameter(name="AxonIQ-PayloadRevision", description="Payload revision", in=ParameterIn.HEADER) String string4, @Parameter(name="AxonIQ-ResponseType", description="Query response type", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-ResponseType", required=false, defaultValue="java.lang.Object") String string5, @Parameter(name="AxonIQ-ResponseTypeEncoding", description="Query response type encoding", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-ResponseTypeEncoding", required=false) String string6, @Parameter(name="AxonIQ-ResponseCardinality", description="Query response type", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-ResponseCardinality", required=false, defaultValue="single") String string7, @Min(value=1L) @Parameter(name="AxonIQ-NumberOfResponders", description="Query response type", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-NumberOfResponders", required=false, defaultValue="1") Integer n, @RequestBody Resource resource, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string8) {
        Object object;
        void var2_4;
        void this_2 = var2_4;
        IntegrationRestControllerV2 axonIQMessageId = this;
        CompletableFuture<ResponseEntity<Object>> completableFuture = new CompletableFuture<ResponseEntity<Object>>();
        try {
            object = this_2 != null ? this_2 : UUID.randomUUID().toString();
        }
        catch (Exception exception) {
            CompletableFuture<ResponseEntity<Object>> completableFuture2 = completableFuture;
            completableFuture2.complete(ValidationUtils.B((Throwable)exception));
            return completableFuture2;
        }
        {
            void a3;
            void axonIQNumberOfResponders;
            void body;
            void axonIQPayloadRevision;
            void axonIQPayloadType;
            void axonIQResponseTypeEncoding;
            void axonIQResponseType;
            void axonIQResponseCardinality;
            QueryRequest name;
            void principal;
            void var13_15 = object;
            Authentication this_2 = (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I);
            name = QueryRequest.newBuilder().setQuery((String)name).setMessageIdentifier((String)var13_15).setTimestamp(System.currentTimeMillis()).setClientId(axonIQMessageId.B(this_2)).setComponentName(axonIQMessageId.B()).setResponseType(axonIQMessageId.B(IntegrationAPI.QueryResponseCardinality.fromValue((String)axonIQResponseCardinality), (String)axonIQResponseType, (String)ObjectUtils.B((Object)axonIQResponseTypeEncoding, (Object)"application/octet-stream"))).setPayload(IntegrationRestControllerV2.B((String)"", (String)axonIQPayloadType, (String)axonIQPayloadRevision, (Resource)body)).addProcessingInstructions(ProcessingInstructionHelper.c((long)axonIQNumberOfResponders.intValue())).build();
            name = new SerializedQuery((String)a3, name);
            axonIQMessageId.h.query((SerializedQuery)name, this_2, queryResponse -> {
                CompletableFuture a2 = queryResponse;
                CompletableFuture a3 = completableFuture;
                if (!a2.getErrorCode().isBlank()) {
                    a3.complete(ValidationUtils.B((Throwable)new MessagingPlatformException(ErrorCode.find((String)a2.getErrorCode()), a2.getErrorMessage().getMessage())));
                    return;
                }
                HttpHeaders httpHeaders = new HttpHeaders();
                CompletableFuture completableFuture2 = a2;
                IntegrationRestControllerV2.B((String)completableFuture2.getMessageIdentifier(), (HttpHeaders)httpHeaders);
                if (completableFuture2.hasPayload()) {
                    IntegrationRestControllerV2.B((SerializedObject)a2.getPayload(), (HttpHeaders)httpHeaders);
                    a3.complete(((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).body((Object)new ByteArrayResource(a2.getPayload().getData().toByteArray())));
                    return;
                }
                a3.complete(((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).build());
            }, a2 -> {});
            return completableFuture;
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/aggregates/{aggregateId}/events"})
    @Operation(summary="Read aggregate events", description="Retrieves events for a specific aggregate from Axon Server")
    @ApiResponse(responseCode="200", description="Events successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.Event.class)), mediaType="application/json")})
    public List<IntegrationAPI.Event> B(@PathVariable(value="aggregateId") @Schema(description="Aggregate identifier", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @RequestParam(value="minSequence", required=false, defaultValue="0") @Schema(description="Minimum sequence number (inclusive)", defaultValue="0") int n, @RequestParam(value="payloadContentType", required=false, defaultValue="application/octet-stream") @Schema(description="Content type of the event payload", defaultValue="application/octet-stream") String string3) {
        void principal;
        void context;
        void minSequence;
        GetAggregateEventsRequest aggregateId;
        IntegrationRestControllerV2 integrationRestControllerV2 = object;
        Object object = string3;
        IntegrationRestControllerV2 a2 = integrationRestControllerV2;
        object = PayloadUtils.B((String)object);
        aggregateId = GetAggregateEventsRequest.newBuilder().setAggregateId((String)aggregateId).setInitialSequence((long)minSequence).build();
        return a2.M.aggregateEvents((String)context, (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I), aggregateId).map(arg_0 -> a2.B((MediaType)object, arg_0)).toStream().toList();
    }

    private /* synthetic */ String B(Authentication authentication) {
        IntegrationRestControllerV2 a2 = authentication;
        IntegrationRestControllerV2 a3 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3.e;
        objectArray[1] = a2.getName();
        return String.format(AggregateWithoutSnapshotException.B((Object)"@\u0013|\u0017%\"f\u0003x\ba\t|'-\u0014SB{:"), objectArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"v2/endpoints/{endpointId}/test-event"})
    @Operation(summary="Test an event handler", description="Tests an event handler configuration by sending a test event to the specified endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Test event successfully processed"), @ApiResponse(responseCode="400", description="Invalid event or endpoint configuration"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Test event processing failed")})
    public ResponseEntity<Object> B(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @RequestParam(value="eventUrl", required=false) @Schema(description="Event URL to override endpoint configuration") String string3, @RequestParam(value="name", required=false) @Schema(description="Handler name to use for the test") String string4, @RequestBody @Schema(description="Event payload for testing", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.Event.class) IntegrationAPI.Event event) {
        IntegrationRestControllerV2 integrationRestControllerV2 = integrationRestControllerV22;
        try {
            C eventUrlParam;
            String handlerName;
            void context2;
            io.axoniq.axonserver.grpc.event.Event a2;
            void endpointId;
            ValidationUtils.B((String)endpointId);
            j.info(MaxTokenExtractor.B((Object)"?\u0002\u0018\u0013K\u0002\u001d\u0002\u0005\u0013K\u0017\n\u001e\u0007\b\n\u0003QG\u0010\u001a"), (Object)a2);
            IntegrationRestControllerV2 integrationRestControllerV22 = integrationRestControllerV2.k.get(UUID.fromString((String)endpointId));
            if (!context2.equals(integrationRestControllerV22.context())) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, AggregateWithoutSnapshotException.B((Object)".f\u0011i\u000ba\u0003(\u0004g\t|\u0002p\u0013"));
            }
            String context2 = handlerName == null ? a2.payloadType() : handlerName;
            j.info(MaxTokenExtractor.B((Object)".\u0011\u000e\t\u001fG\u0005\u0006\u0006\u0002QG\u0010\u001a"), (Object)context2);
            handlerName = eventUrlParam == null ? integrationRestControllerV22.endpoint().getEventUrl().replace("{name}", context2) : eventUrlParam.replace("{name}", context2);
            j.info(AggregateWithoutSnapshotException.B((Object)"2{\u000ef\u0000(\u0002~\u0002f\u0013(2Z+2Gs\u001a"), (Object)handlerName);
            MediaType mediaType = PayloadUtils.B((String)a2.payloadContentType());
            IntegrationRestControllerV2 integrationRestControllerV23 = integrationRestControllerV2;
            a2 = integrationRestControllerV23.B((IntegrationAPI.Event)a2, mediaType);
            a2 = new StreamEvent(0, (PersistentStreamEvent)new PersistentStreamEvent.SimplePersistentStreamEvent(0L, a2), false);
            eventUrlParam = new C(context2, (String)eventUrlParam);
            eventUrlParam = new WrappedEventHandler("", (EventHandler)eventUrlParam, (WrappedEndpoint)integrationRestControllerV22);
            integrationRestControllerV23.D.endpointHandler(integrationRestControllerV22.type()).eventPublisher((WrappedEventHandler)eventUrlParam).publish(List.of(a2)).get(10L, TimeUnit.SECONDS);
            j.info(MaxTokenExtractor.B((Object)"\"\u001d\u0002\u0005\u0013K\u0013\u000e\u0014\u001fG\u0018\u0012\b\u0004\u000e\u0014\u0018\u0001\u001e\u000bK\u0001\u0004\u0015K\u0002\u0005\u0003\u001b\b\u0002\t\u001fG\u0010\u001aK\u0010\u0002\u0013\u0003G\u000e\u0011\u000e\t\u001fG\u0010\u001a"), (Object)endpointId, (Object)context2);
            return ResponseEntity.ok().body(Map.of("success", true, "message", AggregateWithoutSnapshotException.B((Object)"M\u0011m\t|Gx\u0012j\u000ba\u0014`\u0002lG{\u0012k\u0004m\u0014{\u0001}\u000bd\u001e"), MaxTokenExtractor.B((Object)"\u0002\u001d\u0002\u0005\u0013%\u0006\u0006\u0002"), context2, AggregateWithoutSnapshotException.B((Object)"m\u0011m\t|2z\u000b"), handlerName));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)IntegrationRestControllerV2.B((String)interruptedException.getMessage()));
        }
        catch (Exception interruptedException) {
            j.info(MaxTokenExtractor.B((Object)"!\n\u000e\u0007\u0002\u000fG\u001f\bK\u0013\u000e\u0014\u001fG\u000e\u0011\u000e\t\u001fG\u000e\t\u000f\u0017\u0004\u000e\u0005\u0013"), (Throwable)interruptedException);
            ErrorCode context2 = ErrorCode.fromException((Throwable)interruptedException);
            return ResponseEntity.status((HttpStatusCode)context2.getHttpCode()).body((Object)IntegrationRestControllerV2.B((String)("Failed to test event endpoint: " + interruptedException.getMessage())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ SerializedObject B(IntegrationAPI.QueryResponseCardinality queryResponseCardinality, String string, String string2) {
        void a2;
        void a3;
        IntegrationRestControllerV2 a4 = queryResponseCardinality;
        IntegrationRestControllerV2 a5 = this;
        if (a3 == null) {
            return SerializedObject.getDefaultInstance();
        }
        if (a4 == null) {
            a4 = IntegrationAPI.QueryResponseCardinality.SINGLE;
        }
        return SerializedObject.newBuilder().setType(a4.type()).setData(ByteString.copyFromUtf8((String)a5.B((IntegrationAPI.QueryResponseCardinality)a4, (String)a3, (String)a2))).build();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"v2/snapshots/{aggregateId}"}, consumes={"*/*"})
    public CompletableFuture<ResponseEntity<Object>> B(@PathVariable(value="aggregateId") String string, @Parameter(name="AxonIQ-MessageId", description="Message identifier", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-MessageId", required=false) String string2, @Parameter(name="AxonIQ-PayloadRevision", description="Payload revision", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-PayloadRevision", required=false) String string3, @Parameter(name="AxonIQ-PayloadType", description="Payload type", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-PayloadRevision", required=false) String string4, @Parameter(name="AxonIQ-AggregateType", description="Aggregate type", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-AggregateType", required=false) String string5, @Parameter(name="AxonIQ-SequenceNumber", description="Sequence number", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-SequenceNumber", required=false) Long l2, @Parameter(name="AxonIQ-DateTime", description="Date and time of the event", in=ParameterIn.HEADER) @RequestHeader(value="AxonIQ-DateTime", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime offsetDateTime, @RequestBody Resource resource, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") String string6) {
        long l3;
        Event.Builder builder;
        Object object;
        Event.Builder builder2;
        void var1_4;
        void this22 = var1_4;
        IntegrationRestControllerV2 aggregateId = this;
        CompletableFuture<ResponseEntity<Object>> completableFuture = new CompletableFuture<ResponseEntity<Object>>();
        try {
            void axonIQMessageId;
            builder2 = io.axoniq.axonserver.grpc.event.Event.newBuilder();
            object = axonIQMessageId != null ? axonIQMessageId : UUID.randomUUID().toString();
        }
        catch (IOException this22) {
            CompletableFuture<ResponseEntity<Object>> completableFuture2 = completableFuture;
            completableFuture2.complete(ValidationUtils.B((Throwable)this22));
            return completableFuture2;
        }
        {
            void axonIQDateTime;
            builder = builder2.setMessageIdentifier(object);
            l3 = axonIQDateTime != null ? axonIQDateTime.toInstant().toEpochMilli() : System.currentTimeMillis();
        }
        {
            void principal;
            void a2;
            void body;
            void axonIQPayloadRevision;
            void axonIQSequenceNumber;
            void axonIQAggregateType;
            void payloadType;
            void v5 = payloadType;
            io.axoniq.axonserver.grpc.event.Event this22 = builder.setTimestamp(l3).setAggregateIdentifier((String)ObjectUtils.B((Object)this22, (Object)"")).setAggregateType((String)ObjectUtils.B((Object)axonIQAggregateType, (Object)"")).setAggregateSequenceNumber(((Long)ObjectUtils.B((Object)axonIQSequenceNumber, (Object)0L)).longValue()).setPayload(IntegrationRestControllerV2.B((String)v5, (String)v5, (String)axonIQPayloadRevision, (Resource)body)).build();
            aggregateId.M.appendSnapshot((String)a2, this22, (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I)).subscribe((CoreSubscriber)IntegrationRestControllerV2.B(completableFuture));
            return completableFuture;
        }
    }

    @NotNull
    private /* synthetic */ Set<TagsAndNameCriterion> B(List<IntegrationAPI.Criterion> list) {
        List<IntegrationAPI.Criterion> a2 = list;
        IntegrationRestControllerV2 a3 = this;
        if (a2 == null) {
            return Set.of();
        }
        return a2.stream().map(criterion -> {
            IntegrationRestControllerV2 a2 = criterion;
            IntegrationRestControllerV2 a3 = this;
            return new l(a3, (IntegrationAPI.Criterion)a2);
        }).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IntegrationAPI.Event B(MediaType mediaType, SerializedEvent serializedEvent) {
        void a2;
        IntegrationRestControllerV2 a3 = serializedEvent;
        IntegrationRestControllerV2 a4 = this;
        return a4.B((SerializedEvent)a3, (MediaType)a2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/aggregates/{aggregateId}/eventsPaged"}, produces={"application/json"})
    public IntegrationAPI.AggregatePage B(@PathVariable(value="aggregateId") String string, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") String string2, @RequestParam(value="pageOffset") long l2, @RequestParam(value="pageSize") int n, @RequestParam(value="payloadContentType", required=false, defaultValue="application/octet-stream") @Schema(description="Content type of the event payload", defaultValue="application/octet-stream") String string3) {
        void principal22;
        void context;
        void a2;
        void pageOffset;
        MediaType a3;
        IntegrationRestControllerV2 integrationRestControllerV2 = object;
        Object object = string;
        IntegrationRestControllerV2 aggregateId = integrationRestControllerV2;
        a3 = PayloadUtils.B((String)a3);
        object = GetAggregateEventsRequest.newBuilder().setAggregateId((String)object).setInitialSequence((long)(pageOffset * (long)a2)).setMaxSequence((long)((pageOffset + 1L) * (long)a2 + 1L)).build();
        object = aggregateId.M.aggregateEvents((String)context, (Authentication)ObjectUtils.B((Object)principal22, (Object)GrpcContextAuthenticationProvider.I), (GetAggregateEventsRequest)object).toStream().toList();
        boolean principal22 = object.size() <= a2;
        long l3 = principal22 ? (long)object.size() : (long)a2;
        return new IntegrationAPI.AggregatePage((long)pageOffset, l3, principal22, object.stream().limit((long)a2).map(serializedEvent -> {
            void a2;
            IntegrationRestControllerV2 a3 = serializedEvent;
            IntegrationRestControllerV2 a4 = this;
            return a4.B((SerializedEvent)a3, (MediaType)a2);
        }).toList());
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationRestControllerV2(CommandDispatcher commandDispatcher, EventDispatcher eventDispatcher, EndpointFactory endpointFactory, QueryDispatcher queryDispatcher, EndpointController endpointController, Contexts contexts, EventStoreService eventStoreService, Topology topology) {
        IntegrationRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        IntegrationRestControllerV2 a10;
        IntegrationRestControllerV2 integrationRestControllerV2 = integrationRestControllerV22;
        IntegrationRestControllerV2 integrationRestControllerV22 = topology;
        IntegrationRestControllerV2 integrationRestControllerV23 = a10 = integrationRestControllerV2;
        IntegrationRestControllerV2 integrationRestControllerV24 = a10;
        IntegrationRestControllerV2 integrationRestControllerV25 = a10;
        IntegrationRestControllerV2 integrationRestControllerV26 = a10;
        integrationRestControllerV26.b = a9;
        integrationRestControllerV26.M = a8;
        integrationRestControllerV25.D = a7;
        integrationRestControllerV25.h = a6;
        integrationRestControllerV24.k = a5;
        integrationRestControllerV24.l = a4;
        integrationRestControllerV23.I = a3;
        integrationRestControllerV23.e = a2.getName();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints/test-health"})
    @Operation(summary="Test endpoint health", description="Tests the health endpoint configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Health endpoint is reachable"), @ApiResponse(responseCode="500", description="Health endpoint test failed")})
    public ResponseEntity<Object> B(@RequestBody @Schema(description="Endpoint configuration to test", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.Endpoint.class) IntegrationAPI.Endpoint endpoint, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string) {
        IntegrationRestControllerV2 integrationRestControllerV2 = object;
        Object object = string;
        IntegrationRestControllerV2 a2 = integrationRestControllerV2;
        try {
            void endpoint2;
            object = new E((IntegrationAPI.Endpoint)endpoint2, (String)object);
            a2.D.endpointHandler(endpoint2.type()).heartbeatInvoker((Endpoint)object).test().get();
            return ResponseEntity.ok().build();
        }
        catch (InterruptedException this2) {
            Thread.currentThread().interrupt();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)IntegrationRestControllerV2.B((String)this2.getMessage()));
        }
        catch (Exception this2) {
            j.info(MaxTokenExtractor.B((Object)"-\u0006\u0002\u000b\u000e\u0003K\u0013\u0004G\u001f\u0002\u0018\u0013K\u000f\u000e\u0006\u0007\u0013\u0003G\u000e\t\u000f\u0017\u0004\u000e\u0005\u0013"), (Throwable)this2);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)IntegrationRestControllerV2.B((String)this2.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Event B(IntegrationAPI.DcbEvent dcbEvent, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a3 = mediaType;
        IntegrationRestControllerV2 a4 = this;
        return new i(a4, (IntegrationAPI.DcbEvent)a2, (MediaType)a3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private /* synthetic */ QueryRequest B(IntegrationAPI.Query query, String string, Authentication authentication, MediaType mediaType) {
        void a2;
        void a3;
        void a4;
        IntegrationRestControllerV2 a5 = query;
        IntegrationRestControllerV2 a6 = this;
        return QueryRequest.newBuilder().setQuery(a5.name()).setMessageIdentifier((String)a4).setTimestamp(System.currentTimeMillis()).setClientId(a6.B((Authentication)a3)).setComponentName(a6.B()).setResponseType(a6.B(a5.responseCardinality(), a5.responseType(), (String)ObjectUtils.B((Object)a5.responseTypeEncoding(), (Object)a2.toString()))).setPayload(SerializedObject.newBuilder().setType((String)ObjectUtils.B((Object)a5.payloadType(), (Object)a5.name())).setRevision((String)ObjectUtils.B((Object)a5.payloadRevision(), (Object)"")).setData(a6.B(a5.payload(), (MediaType)a2)).build()).addProcessingInstructions(ProcessingInstructionHelper.c((long)((Integer)ObjectUtils.B((Object)a5.numberOfResponses(), (Object)1)).intValue())).putAllMetaData(a6.B(a5.metaData())).build();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void B(Map map, String string, String string2) {
        void a2;
        String a3 = string2;
        Map a4 = map;
        a4.put(a2, MetaDataValue.newBuilder().setTextValue(a3).build());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ String B(IntegrationAPI.QueryResponseCardinality queryResponseCardinality, String string, String string2) {
        void a2;
        int n;
        block8: {
            String a3 = string2;
            IntegrationRestControllerV2 a4 = this;
            int n2 = -1;
            switch (a3.hashCode()) {
                case -43840953: {
                    if (!a3.equals(MaxTokenExtractor.B((Object)"\n\u0017\u001b\u000b\u0002\u0004\n\u0013\u0002\b\u0005H\u0001\u0014\u0004\t"))) break;
                    n = n2 = 0;
                    break block8;
                }
                case -1248326952: {
                    if (!a3.equals(AggregateWithoutSnapshotException.B((Object)"\u0006x\u0017d\u000ek\u0006|\u000eg\t'\u001fe\u000b"))) break;
                    n2 = 1;
                }
            }
            n = n2;
        }
        switch (n) {
            case 0: {
                Object[] objectArray = new Object[1];
                objectArray[0] = a2;
                return String.format(MaxTokenExtractor.B((Object)"\u001cKE\u000e\u001f\u001b\u0002\b\u0013\u000e\u00039\u0002\u0018\u0017\u0004\t\u0018\u0002?\u001e\u001b\u0002I]KEN\u0014I\u001a"), objectArray);
            }
            case 1: {
                void a5;
                Object[] objectArray = new Object[3];
                objectArray[0] = a5;
                objectArray[1] = a2;
                objectArray[2] = a5;
                return String.format(AggregateWithoutSnapshotException.B((Object)"4B{Y4\u0002p\u0017m\u0004|\u0002l5m\u0014x\bf\u0014m3q\u0017mY-\u00144Hm\u001fx\u0002k\u0013m\u0003Z\u0002{\u0017g\t{\u0002\\\u001ex\u00026['B{Y"), objectArray);
            }
        }
        return (String)ObjectUtils.B((Object)a2, (Object)"");
    }

    @NotNull
    private static /* synthetic */ BaseSubscriber<Void> B(CompletableFuture<ResponseEntity<Object>> a2) {
        return new a(a2);
    }

    private /* synthetic */ String B() {
        IntegrationRestControllerV2 a2;
        return "Http-Endpoint@" + a2.e;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private /* synthetic */ Command B(IntegrationAPI.Command command, String string, Authentication authentication, MediaType mediaType) {
        void a2;
        void a3;
        void a4;
        IntegrationRestControllerV2 a5 = command;
        IntegrationRestControllerV2 a6 = this;
        return Command.newBuilder().setName(a5.name()).setMessageIdentifier((String)a4).setTimestamp(System.currentTimeMillis()).setClientId(a6.B((Authentication)a3)).setComponentName(a6.B()).setPayload(SerializedObject.newBuilder().setType((String)ObjectUtils.B((Object)a5.payloadType(), (Object)a5.name())).setRevision((String)ObjectUtils.B((Object)a5.payloadRevision(), (Object)"")).setData(a6.B(a5.payload(), (MediaType)a2)).build()).putAllMetaData(a6.B(a5.metaData())).addProcessingInstructions(ProcessingInstructionHelper.F((long)a5.priority())).addProcessingInstructions(ProcessingInstructionHelper.B((String)(a5.routingKey() != null ? a5.routingKey() : a4))).build();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/snapshots"}, consumes={"application/json"})
    public Mono<Void> B(@RequestBody IntegrationAPI.Snapshot snapshot, @Parameter(hidden=true) Authentication authentication, @RequestParam(value="context") String string) {
        void principal;
        void a2;
        IntegrationRestControllerV2 integrationRestControllerV2 = integrationRestControllerV22;
        IntegrationRestControllerV2 integrationRestControllerV22 = snapshot;
        IntegrationRestControllerV2 snapshot2 = integrationRestControllerV2;
        MediaType mediaType = PayloadUtils.B((String)integrationRestControllerV22.payloadContentType());
        IntegrationRestControllerV2 integrationRestControllerV23 = snapshot2;
        integrationRestControllerV22 = integrationRestControllerV23.B((IntegrationAPI.Snapshot)integrationRestControllerV22, mediaType);
        return integrationRestControllerV23.M.appendSnapshot((String)a2, (io.axoniq.axonserver.grpc.event.Event)integrationRestControllerV22, (Authentication)ObjectUtils.B((Object)principal, (Object)GrpcContextAuthenticationProvider.I));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ LabeledEvent B(IntegrationAPI.LabeledEvent labeledEvent, MediaType mediaType) {
        void a2;
        IntegrationRestControllerV2 a3 = mediaType;
        IntegrationRestControllerV2 a4 = this;
        a3 = a4.B(a2.event(), (MediaType)a3);
        Set set = a2.labels() != null ? a2.labels().entrySet().stream().map(entry -> {
            Object a2 = entry;
            IntegrationRestControllerV2 a3 = this;
            return new c(a3, (Map.Entry)a2);
        }).collect(Collectors.toSet()) : Set.of();
        return new g(a4, set, (Event)a3);
    }
}

