CREATE TABLE application
(
    id           BIGINT generated by default as identity,
    description  VARCHAR(255),
    token_prefix VARCHAR(255),
    hashed_token VARCHAR(255),
    name         VARCHAR(255),
    primary key (id)
);

ALTER TABLE application
    add constraint application_uk1 unique (hashed_token);

ALTER TABLE application
    add constraint application_uk2 unique (name);

CREATE TABLE application_roles
(
    application_id BIGINT not null,
    roles_id       BIGINT not null,
    primary key (application_id, roles_id)
);

CREATE TABLE application_role
(
    id       BIGINT generated by default as identity,
    context  VARCHAR(255),
    end_date TIMESTAMP,
    role     VARCHAR(255),
    primary key (id)
);

ALTER TABLE application_roles
    add constraint application_roles_uk unique (roles_id);

ALTER TABLE application_roles
    add constraint application_roles_fk1 foreign key (roles_id) references application_role;

ALTER TABLE application_roles
    add constraint application_roles_fk2 foreign key (application_id) references application;

CREATE TABLE cluster_node
(
    name               VARCHAR(255) not null,
    grpc_external_port INTEGER,
    grpc_internal_port INTEGER,
    grpc_port          INTEGER,
    host_name          VARCHAR(255),
    http_port          INTEGER,
    internal_host_name VARCHAR(255),
    primary key (name)
);

ALTER TABLE cluster_node
    add constraint cluster_node_uq1 unique (internal_host_name, grpc_internal_port);

CREATE TABLE path_mapping
(
    path VARCHAR(255) not null,
    role VARCHAR(255),
    primary key (path)
);

CREATE TABLE application_model_version
(
    application_name VARCHAR(255) not null,
    version          INTEGER      not null,
    primary key (application_name)
);

CREATE TABLE safepoint
(
    context VARCHAR(255) not null,
    type    VARCHAR(255) not null,
    token   BIGINT       not null,
    primary key (context, type)
);

CREATE TABLE users
(
    username VARCHAR(45)  NOT NULL,
    password VARCHAR(255) NOT NULL,
    enabled  TINYINT      NOT NULL DEFAULT 1,
    PRIMARY KEY (username)
);

CREATE TABLE user_roles
(
    user_role_id integer NOT NULL AUTO_INCREMENT,
    username     varchar(45) NOT NULL,
    role         varchar(45) NOT NULL,
    PRIMARY KEY (user_role_id),
    CONSTRAINT fk_username FOREIGN KEY (username) REFERENCES users (username)
);

CREATE TABLE ROLE
(
    name VARCHAR(45) NOT NULL,
    PRIMARY KEY (name)
);

CREATE TABLE ROLE_TYPES
(
    role_name VARCHAR(45) NOT NULL,
    types     VARCHAR(45) NOT NULL,
    CONSTRAINT fk_rolename FOREIGN KEY (role_name) REFERENCES role (name)
);

CREATE TABLE context
(
    name VARCHAR(255) not null,
    primary key (name)
);

CREATE TABLE context_cluster_node
(
    context_name      VARCHAR(255) not null REFERENCES context (name),
    cluster_node_name VARCHAR(255) not null REFERENCES cluster_node (name),
    storage           BOOLEAN      not null,
    messaging         BOOLEAN      not null,
    PRIMARY KEY (context_name, cluster_node_name)
);

create table LOAD_BALANCING_STRATEGY
(
    ID           bigint generated by default as identity,
    NAME         VARCHAR(255) not null,
    LABEL        VARCHAR(255) not null,
    FACTORY_BEAN VARCHAR(255) not null,
    primary key (ID)
);

create unique index UK_LOAD_BALANCING_STRATEGY_NAME
    on LOAD_BALANCING_STRATEGY (NAME);

create table PROCESSOR_LOAD_BALANCING
(
    COMPONENT VARCHAR(255) not null,
    CONTEXT   VARCHAR(255) not null,
    NAME      VARCHAR(255) not null,
    STRATEGY  VARCHAR(255) not null,
    primary key (COMPONENT, CONTEXT, NAME)
);


