-- select e1_0.name,
-- e1_0.command_url,e1_0.context,e1_0.default_batch_size,e1_0.event_url,e1_0.health_url,e1_0.query_url,e1_0.serialization_type,e1_0.type,e1_0.wrapping_type
-- from endpoint e1_0

create table adm_endpoint
(
    id                   uuid          not null primary key,
    name                 varchar(200)  not null,
    base_url             varchar(2000) not null,
    command_url          varchar(2000),
    context              varchar(2000),
    event_url            varchar(2000),
    health_url           varchar(2000),
    query_url            varchar(2000),
    type                 varchar(200)  not null,
    wrapping_type        varchar(200)  not null,
    content_type         varchar(200),
    active               boolean,
    serialized_meta_data varchar(4000)
);

create table rg_endpoint
(
    id                   uuid          not null primary key,
    name                 varchar(200)  not null,
    base_url             varchar(2000) not null,
    command_url          varchar(2000),
    context              varchar(2000),
    event_url            varchar(2000),
    health_url           varchar(2000),
    query_url            varchar(2000),
    type                 varchar(200)  not null,
    wrapping_type        varchar(200)  not null,
    content_type         varchar(200),
    active               boolean,
    serialized_meta_data varchar(4000)
);

create table adm_command_handler
(
    id          uuid         not null primary key,
    name        varchar(200) not null,
    endpoint    uuid         not null references adm_endpoint (id),
    command_url varchar(2000),
    load_factor int
);

create table rg_command_handler
(
    id          uuid         not null primary key,
    name        varchar(200) not null,
    endpoint    uuid         not null references rg_endpoint (id),
    command_url varchar(2000),
    load_factor int
);

create table adm_query_handler
(
    id        uuid         not null primary key,
    name      varchar(200) not null,
    query_url varchar(2000),
    endpoint  uuid         not null references adm_endpoint (id)
);

create table rg_query_handler
(
    id        uuid         not null primary key,
    name      varchar(200) not null,
    query_url varchar(2000),
    endpoint  uuid         not null references rg_endpoint (id)
);

create table adm_event_handler
(
    id                           uuid         not null primary key,
    name                         varchar(200) not null,
    event_url                    varchar(2000),
    endpoint                     uuid         not null references adm_endpoint (id),
    batch_size                   int,
    filter                       varchar(4000),
    sequencing_policy            varchar(200),
    sequencing_policy_parameters varchar(2000),
    segments                     int,
    position                     long
);

create table rg_event_handler
(
    id                           uuid         not null primary key,
    name                         varchar(200),
    event_url                    varchar(2000),
    endpoint                     uuid not null references rg_endpoint (id),
    batch_size                   int,
    filter                       varchar(4000),
    sequencing_policy            varchar(200),
    sequencing_policy_parameters varchar(2000),
    segments                     int,
    position                     long
);
